/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import glowredman.amazingtrophies.AmazingTrophies;
import glowredman.amazingtrophies.AssetHandler;
import glowredman.amazingtrophies.api.AmazingTrophiesAPI;
import glowredman.amazingtrophies.model.BasicTrophyModelHandler;
import glowredman.amazingtrophies.model.EntityTrophyModelHandler;
import glowredman.amazingtrophies.model.ItemTrophyModelHandler;
import glowredman.amazingtrophies.model.PedestalTrophyModelHandler;
import glowredman.amazingtrophies.model.complex.ComplexTrophyModelHandler;
import glowredman.amazingtrophies.trophy.RendererTrophy;
import glowredman.amazingtrophies.trophy.TileEntityTrophy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ClientHandler {
    static void setupAssetHandler() {
        FMLClientHandler.instance().getClient().field_110449_ao.add(new AssetHandler());
        ClientHandler.createAssetDirsAndFiles();
    }

    static void registerTrophyModelHandlers() {
        AmazingTrophiesAPI.registerTrophyModelHandlerProvider("pedestal", PedestalTrophyModelHandler::new);
        AmazingTrophiesAPI.registerTrophyModelHandlerProvider("basic", BasicTrophyModelHandler::new);
        AmazingTrophiesAPI.registerTrophyModelHandlerProvider("entity", EntityTrophyModelHandler::new);
        AmazingTrophiesAPI.registerTrophyModelHandlerProvider("item", ItemTrophyModelHandler::new);
        AmazingTrophiesAPI.registerTrophyModelHandlerProvider("complex", ComplexTrophyModelHandler::new);
    }

    static void setupTrophyRenderer() {
        RendererTrophy trophyRenderer = new RendererTrophy();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophy.class, (TileEntitySpecialRenderer)trophyRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)AmazingTrophiesAPI.getTrophyBlock()), (IItemRenderer)trophyRenderer);
    }

    private static void createAssetDirsAndFiles() {
        try {
            Path langDir = AmazingTrophies.CONFIG_DIR.resolve("lang");
            Path langFile = langDir.resolve("en_US.lang");
            Files.createDirectories(langDir, new FileAttribute[0]);
            Files.createDirectories(AmazingTrophies.CONFIG_DIR.resolve("models"), new FileAttribute[0]);
            Files.createDirectories(AmazingTrophies.CONFIG_DIR.resolve("textures").resolve("blocks"), new FileAttribute[0]);
            if (Files.notExists(langFile, new LinkOption[0])) {
                Files.createFile(langFile, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            AmazingTrophies.LOGGER.warn("Could not create default dirs/files for custom assets.", (Throwable)e);
        }
    }
}

