/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.condition;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.api.ConditionHandler;
import net.minecraft.inventory.Container;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;

public class OpenContainerConditionHandler
extends ConditionHandler {
    public static final String ID = "container.open";
    public static final String PROPERTY_CONTAINERS = "containers";
    private final Multimap<Class<? extends Container>, String> conditions = HashMultimap.create();
    private Container previous;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void parse(String id, JsonObject json) {
        for (Class clazz : ConfigHandler.getSetProperty(json, PROPERTY_CONTAINERS, OpenContainerConditionHandler::parseTarget)) {
            this.conditions.put((Object)clazz, (Object)id);
        }
    }

    @Override
    protected boolean isForgeEventHandler() {
        return !this.conditions.isEmpty();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onOpenContainer(PlayerOpenContainerEvent event) {
        Container current = event.entityPlayer.field_71070_bA;
        if (event.getResult() == Event.Result.DENY || current == this.previous) {
            return;
        }
        for (String id : this.conditions.get(current.getClass())) {
            this.getListener().accept(id, event.entityPlayer);
        }
        this.previous = current;
    }

    private static Class<? extends Container> parseTarget(JsonElement json) {
        Class<?> clazz;
        String name = json.getAsString();
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find target class!", e);
        }
        if (Container.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException(name + " is not a subclass of " + Container.class.getName() + "!");
    }
}

