/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.entity.block.EntityBlockEnhancedTNTPrimed;
import chylex.hee.mechanics.enhancements.IEnhanceableTile;
import chylex.hee.mechanics.enhancements.types.TNTEnhancements;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.tileentity.TileEntityEnhancedTNT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockEnhancedTNT
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;

    public BlockEnhancedTNT() {
        super(Material.field_151590_u);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityEnhancedTNT();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.func_72864_z(x, y, z)) {
            world.func_147464_a(x, y, z, (Block)this, 1);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.tryIgniteTNT(world, x, y, z, true, null);
        BlockPosM.tmp(x, y, z).setAir(world);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (world.func_72864_z(x, y, z)) {
            this.tryIgniteTNT(world, x, y, z, true, null);
            BlockPosM.tmp(x, y, z).setAir(world);
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        TileEntityEnhancedTNT tile;
        if (!world.field_72995_K && (tile = (TileEntityEnhancedTNT)world.func_147438_o(x, y, z)) != null) {
            EntityBlockEnhancedTNTPrimed tnt = new EntityBlockEnhancedTNTPrimed(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, explosion.func_94613_c(), tile.getEnhancements());
            tnt.field_70516_a = tile.getEnhancements().contains(TNTEnhancements.NO_FUSE) ? 1 : world.field_73012_v.nextInt(tnt.field_70516_a / 4) + tnt.field_70516_a / 8;
            world.func_72838_d((Entity)tnt);
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity tile;
        boolean exploded = false;
        if (!player.field_71075_bZ.field_75098_d) {
            exploded = this.tryIgniteTNT(world, x, y, z, false, null);
        }
        if (!exploded && (tile = world.func_147438_o(x, y, z)) instanceof IEnhanceableTile) {
            this.func_149642_a(world, x, y, z, ((IEnhanceableTile)tile).createEnhancedItemStack());
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float hitX, float hitY, float hitZ) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151033_d) {
            this.tryIgniteTNT(world, x, y, z, true, (EntityLivingBase)player);
            BlockPosM.tmp(x, y, z).setAir(world);
            player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, meta, hitX, hitY, hitZ);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        EntityArrow arrow;
        if (!world.field_72995_K && entity instanceof EntityArrow && (arrow = (EntityArrow)entity).func_70027_ad()) {
            this.tryIgniteTNT(world, x, y, z, true, arrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)arrow.field_70250_c : null);
            BlockPosM.tmp(x, y, z).setAir(world);
        }
    }

    private boolean tryIgniteTNT(World world, int x, int y, int z, boolean ignite, EntityLivingBase igniter) {
        TileEntityEnhancedTNT tile;
        if (!world.field_72995_K && (tile = (TileEntityEnhancedTNT)world.func_147438_o(x, y, z)) != null && (ignite || tile.getEnhancements().contains(TNTEnhancements.TRAP))) {
            EntityBlockEnhancedTNTPrimed tnt = new EntityBlockEnhancedTNTPrimed(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, igniter, tile.getEnhancements());
            world.func_72838_d((Entity)tnt);
            world.func_72956_a((Entity)tnt, "game.tnt.primed", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.iconTop = iconRegister.func_94245_a(this.func_149641_N() + "_top");
        this.iconBottom = iconRegister.func_94245_a(this.func_149641_N() + "_bottom");
    }
}

