/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.CollisionEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class DragonAttackPunch
extends DragonSpecialAttackBase {
    private static final byte PHASE_PREPARATION = 0;
    private static final byte PHASE_DISTANCE = 1;
    private static final byte PHASE_ATTACK = 2;
    private EntityPlayer target;
    private EntityPlayer tempTarget;
    private float speed;
    private boolean ended;

    public DragonAttackPunch(EntityBossDragon dragon, int attackId, int weight) {
        super(dragon, attackId, weight);
    }

    @Override
    public void init() {
        super.init();
        this.tempTarget = null;
        this.target = null;
        this.speed = 1.0f;
        this.ended = false;
    }

    @Override
    public void update() {
        super.update();
        if (this.phase == 0) {
            this.tempTarget = this.dragon.attacks.getRandomPlayer();
            if (this.tempTarget == null) {
                this.ended = true;
                return;
            }
            Vec3 vec = Vec3.func_72443_a((double)(-this.tempTarget.field_70165_t), (double)0.0, (double)(-this.tempTarget.field_70161_v)).func_72432_b();
            this.dragon.targetX = vec.field_72450_a * 55.0 * (1.0 + this.rand.nextDouble() * 0.25) + (double)this.rand.nextInt(25);
            this.dragon.targetY = 72 + this.rand.nextInt(12);
            this.dragon.targetZ = vec.field_72449_c * 55.0 * (1.0 + this.rand.nextDouble() * 0.25) + (double)this.rand.nextInt(25);
            this.phase = 1;
        } else if (this.phase == 1) {
            if (this.dragon.func_70011_f(this.dragon.targetX, this.dragon.targetY, this.dragon.targetZ) < 10.0 || this.tick > 180) {
                this.target = this.tempTarget;
                this.phase = (byte)2;
                this.tick = 0;
            }
        } else if (this.phase == 2) {
            if (this.tick > 20) {
                this.speed = 3.0f;
            }
            if (this.dragon.dragonPartHead.func_70068_e((Entity)this.tempTarget) < 35.0) {
                this.target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), 10.0f + (float)this.getDifficulty());
                this.ended = true;
            }
        }
    }

    @Override
    public boolean hasEnded() {
        return this.ended || this.target != null && this.target.field_70128_L;
    }

    @Override
    public float overrideMovementSpeed() {
        return this.speed;
    }

    @Override
    public void onTargetSetEvent(TargetSetEvent event) {
        event.newTarget = this.target;
    }

    @Override
    public void onTargetPositionSetEvent(TargetPositionSetEvent event) {
        event.cancel();
    }

    @Override
    public void onCollisionEvent(CollisionEvent event) {
        super.onCollisionEvent(event);
        event.velocityX *= 2.0 * Math.min(2.5, (double)this.speed);
        event.velocityY *= 1.4 * (double)this.speed;
        event.velocityZ *= 2.0 * Math.min(2.5, (double)this.speed);
    }
}

