/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.projectile;

import chylex.hee.entity.fx.FXType;
import chylex.hee.mechanics.enhancements.EnhancementEnumHelper;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.types.EnderPearlEnhancements;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.system.util.ReflectionUtils;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityProjectileEnhancedEnderPearl
extends EntityEnderPearl {
    private List<Enum> pearlTypes = new ArrayList<Enum>();
    private EntityPlayer ride = null;
    private short life = 0;

    public EntityProjectileEnhancedEnderPearl(World world) {
        super(world);
    }

    public EntityProjectileEnhancedEnderPearl(World world, EntityLivingBase thrower) {
        super(world, thrower);
        if (thrower instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)thrower;
            ItemStack is = player.field_71071_by.func_70448_g();
            if (is != null) {
                this.pearlTypes.addAll(EnhancementHandler.getEnhancements(is));
            }
            if (this.pearlTypes.contains(EnderPearlEnhancements.RIDING)) {
                this.ride = (EntityPlayer)thrower;
                for (Object o : world.field_72996_f) {
                    if (!(o instanceof EntityProjectileEnhancedEnderPearl)) continue;
                    EntityProjectileEnhancedEnderPearl pearl = (EntityProjectileEnhancedEnderPearl)((Object)o);
                    if (pearl.ride == null || !pearl.ride.func_70005_c_().equals(player.func_70005_c_())) continue;
                    pearl.ride = null;
                    if (!pearl.pearlTypes.contains(EnderPearlEnhancements.NO_FALL_DAMAGE)) {
                        player.func_70097_a(DamageSource.field_76379_h, 5.0f);
                    }
                    pearl.func_70106_y();
                    break;
                }
            }
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)(this.ride == null ? "" : this.ride.func_70005_c_()));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.ride != null) {
                this.field_70180_af.func_75692_b(16, (Object)this.ride.func_70005_c_());
                this.updateRidePosition();
                this.ride.field_70143_R = 0.0f;
                this.ride.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.ride.field_70131_O, this.field_70161_v);
            }
            if (this.pearlTypes.contains(EnderPearlEnhancements.DOUBLE_SPEED)) {
                if (this.field_70193_a) {
                    this.field_70159_w *= 0.2;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.2;
                } else {
                    super.func_70071_h_();
                    if (this.ride != null) {
                        this.updateRidePosition();
                    }
                }
            }
            if ((this.life = (short)(this.life + 1)) > 200) {
                this.func_70106_y();
            }
        } else {
            EntityClientPlayerMP clientPlayer = FMLClientHandler.instance().getClient().field_71439_g;
            if (this.field_70180_af.func_75681_e(16).equals(clientPlayer.func_70005_c_())) {
                clientPlayer.func_70107_b(this.field_70165_t, this.field_70163_u + (double)clientPlayer.field_70131_O, this.field_70161_v);
            }
        }
    }

    private void updateRidePosition() {
        this.ride.field_70169_q = this.ride.field_70165_t = this.field_70165_t;
        this.ride.field_70142_S = this.ride.field_70165_t;
        this.ride.field_70167_r = this.ride.field_70163_u = this.field_70163_u + (double)this.ride.field_70131_O + (double)this.field_70129_M;
        this.ride.field_70137_T = this.ride.field_70163_u;
        this.ride.field_70166_s = this.ride.field_70161_v = this.field_70161_v;
        this.ride.field_70136_U = this.ride.field_70161_v;
        NetHandlerPlayServer serverHandler = ((EntityPlayerMP)this.ride).field_71135_a;
        ReflectionUtils.setFieldValue(serverHandler, "floatingTickCount", 0);
        ReflectionUtils.setFieldValue(serverHandler, "lastPosX", this.ride.field_70165_t);
        ReflectionUtils.setFieldValue(serverHandler, "lastPosY", this.ride.field_70163_u);
        ReflectionUtils.setFieldValue(serverHandler, "lastPosZ", this.ride.field_70161_v);
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72308_g != null) {
            if (this.ride != null && mop.field_72308_g.equals((Object)this.ride)) {
                return;
            }
            mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
        }
        for (int i = 0; i < 32; ++i) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v, this.field_70146_Z.nextGaussian(), 0.0, this.field_70146_Z.nextGaussian());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityPlayerMP) {
                EnderTeleportEvent event;
                EntityPlayerMP player = (EntityPlayerMP)this.func_85052_h();
                if (player.field_71135_a.func_147362_b().func_150724_d() && player.field_70170_p == this.field_70170_p && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)player, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f)))) {
                    if (this.pearlTypes.contains(EnderPearlEnhancements.EXPLOSIVE)) {
                        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.7f, false, true);
                    }
                    if (this.pearlTypes.contains(EnderPearlEnhancements.FREEZE)) {
                        for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(5.0, 3.0, 5.0))) {
                            double dist = entity.func_70068_e((Entity)this);
                            if (!(dist <= 5.0)) continue;
                            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 80 + (int)(10.0 * (6.0 - dist)), 3, true));
                        }
                    }
                    if (player.func_70115_ae()) {
                        player.func_70078_a((Entity)null);
                    }
                    player.func_70634_a(event.targetX, event.targetY, event.targetZ);
                    player.field_70143_R = 0.0f;
                    if (!this.pearlTypes.contains(EnderPearlEnhancements.NO_FALL_DAMAGE)) {
                        player.func_70097_a(DamageSource.field_76379_h, event.attackDamage);
                    }
                    if (this.pearlTypes.contains(EnderPearlEnhancements.FREEZE)) {
                        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C20Effect(FXType.Basic.ENDER_PEARL_FREEZE, (Entity)this));
                    }
                }
            }
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return this.pearlTypes.contains(EnderPearlEnhancements.NO_GRAVITY) ? 0.0f : super.func_70185_h() * (this.pearlTypes.contains(EnderPearlEnhancements.INCREASED_RANGE) ? 0.75f : 1.0f);
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74778_a("enhancements", EnhancementEnumHelper.serialize(this.pearlTypes));
        nbt.func_74777_a("life", this.life);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.pearlTypes = EnhancementEnumHelper.deserialize(nbt.func_74779_i("enhancements"), EnderPearlEnhancements.class);
        this.life = nbt.func_74765_d("life");
    }
}

