/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.gui;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.gui.slots.SlotBasicItem;
import chylex.hee.gui.slots.SlotEnhancementsSubject;
import chylex.hee.gui.slots.SlotReadOnly;
import chylex.hee.gui.slots.SlotShowCase;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.compendium.content.fragments.KnowledgeFragmentEnhancement;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.IEnhanceableTile;
import chylex.hee.mechanics.enhancements.IEnhancementEnum;
import chylex.hee.mechanics.enhancements.SlotList;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C08PlaySound;
import chylex.hee.packets.client.C19CompendiumData;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.ArrayUtils;

public class ContainerEndPowderEnhancements
extends Container {
    private EntityPlayerMP owner;
    public final IInventory containerInv;
    public final IEnhanceableTile enhanceableTile;
    public final Slot[] powderSlots = new Slot[8];
    public final Slot[] ingredientSlots = new Slot[8];
    public final IInventory enhancementListInv;
    public final ItemStack[] clientEnhancementItems = new ItemStack[7];
    public final String[] clientEnhancementTooltips = new String[7];
    public final boolean[] clientEnhancementBlocked = new boolean[7];
    public final int[] enhancementSlotX = new int[7];
    private IEnhancementEnum selectedEnhancement;
    private int selectedSlot = -1;
    private int prevSelectedSlot = -1;

    public ContainerEndPowderEnhancements(InventoryPlayer inv, IEnhanceableTile tileOptional) {
        int i;
        int a;
        this.containerInv = new InventoryBasic("", false, 2 + this.ingredientSlots.length + this.powderSlots.length);
        this.enhanceableTile = tileOptional;
        this.enhancementListInv = new InventoryBasic("", false, this.enhancementSlotX.length);
        for (a = 0; a < this.enhancementSlotX.length; ++a) {
            this.enhancementSlotX[a] = -3200;
        }
        if (this.isEnhancingTile()) {
            this.func_75146_a(new SlotShowCase(this.containerInv, 0, 80, 17));
            this.containerInv.func_70299_a(0, tileOptional.createEnhancedItemStack());
            this.func_75146_a(new SlotReadOnly(this.containerInv, 1, 3200, 17));
        } else {
            this.func_75146_a(new SlotEnhancementsSubject(this, this.containerInv, 0, 53, 17));
            this.func_75146_a(new SlotBasicItem(this.containerInv, 1, 107, 17, null));
        }
        for (a = 0; a < this.powderSlots.length; ++a) {
            this.powderSlots[a] = new SlotBasicItem(this.containerInv, 2 + a, -3200, 57, ItemList.end_powder);
            this.func_75146_a(this.powderSlots[a]);
        }
        for (a = 0; a < this.ingredientSlots.length; ++a) {
            this.ingredientSlots[a] = new Slot(this.containerInv, 2 + this.powderSlots.length + a, -3200, 57);
            this.func_75146_a(this.ingredientSlots[a]);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 88 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, 146));
        }
    }

    public void func_75132_a(ICrafting crafter) {
        super.func_75132_a(crafter);
        if (crafter instanceof EntityPlayerMP) {
            if (this.owner != null) {
                throw new IllegalArgumentException("Cannot add second player to End Powder Enhancement container!");
            }
            this.owner = (EntityPlayerMP)crafter;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        ItemStack is = null;
        ItemStack mainIS = this.containerInv.func_70301_a(0);
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack is2 = slot.func_75211_c();
            is = is2.func_77946_l();
            if (slotId < 2 + this.powderSlots.length + this.ingredientSlots.length) {
                if (!this.func_75135_a(is2, 2 + this.powderSlots.length + this.ingredientSlots.length, this.field_75151_b.size(), true)) {
                    return null;
                }
            } else {
                int shownPowderSlots = 0;
                int shownIngredientSlots = 0;
                if (mainIS != null && this.selectedEnhancement != null) {
                    SlotList slots = EnhancementHandler.getEnhancementSlotsForItem(mainIS.func_77973_b());
                    shownPowderSlots = slots.amountPowder;
                    shownIngredientSlots = slots.amountIngredient;
                }
                if (EnhancementHandler.canEnhanceItem(is2.func_77973_b()) && !this.isEnhancingTile()) {
                    if (!this.func_75135_a(is2, 0, 1, false)) {
                        return null;
                    }
                } else if (shownPowderSlots > 0 && is2.func_77973_b() == ItemList.end_powder) {
                    if (!this.func_75135_a(is2, 2, 2 + shownPowderSlots, false)) {
                        return null;
                    }
                } else {
                    if (shownIngredientSlots > 0 && !this.func_75135_a(is2, 2 + this.powderSlots.length, 2 + this.powderSlots.length + shownIngredientSlots, false)) {
                        return null;
                    }
                    return null;
                }
                if (mainIS != null && this.selectedEnhancement == null) {
                    return null;
                }
            }
            if (is2.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return is;
    }

    public void func_75134_a(EntityPlayer player) {
        int a;
        super.func_75134_a(player);
        int n = a = this.isEnhancingTile() ? 1 : 0;
        while (a < this.containerInv.func_70302_i_()) {
            if (this.containerInv.func_70301_a(a) != null) {
                player.func_71019_a(this.containerInv.func_70301_a(a), false);
            }
            ++a;
        }
    }

    public void func_75141_a(int slot, ItemStack is) {
        super.func_75141_a(slot, is);
        if (slot == 0 && this.isEnhancingTile()) {
            this.onSubjectChanged();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75131_a(ItemStack[] items) {
        super.func_75131_a(items);
        if (this.isEnhancingTile()) {
            this.onSubjectChanged();
        }
    }

    public void updateClientItems() {
        int a;
        ItemStack mainIS = this.func_75139_a(0).func_75211_c();
        List<IEnhancementEnum> enhancements = mainIS == null ? null : EnhancementHandler.getEnhancementsForItem(mainIS.func_77973_b());
        int n = a = enhancements == null ? 0 : enhancements.size();
        while (a < this.enhancementSlotX.length) {
            this.clientEnhancementItems[a] = null;
            this.clientEnhancementTooltips[a] = "";
            ++a;
        }
        if (enhancements == null) {
            return;
        }
        PlayerCompendiumData compendiumData = mainIS != null ? HardcoreEnderExpansion.proxy.getClientCompendiumData() : null;
        for (int a2 = 0; a2 < enhancements.size(); ++a2) {
            ItemStack is;
            IEnhancementEnum enhancement = enhancements.get(a2);
            this.clientEnhancementItems[a2] = is = compendiumData != null && compendiumData.hasUnlockedFragment(KnowledgeFragmentEnhancement.getEnhancementFragment(enhancement)) ? enhancement.getItemSelector().getRepresentativeItem() : new ItemStack(ItemList.special_effects, 1, 18);
        }
    }

    public void onSubjectChanged() {
        int index;
        int a;
        ItemStack mainIS = this.func_75139_a(0).func_75211_c();
        this.updateClientItems();
        HardcoreEnderExpansion.proxy.sendMessage(ModCommonProxy.MessageType.ENHANCEMENT_SLOT_RESET, ArrayUtils.EMPTY_INT_ARRAY);
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        SlotList slots = mainIS == null ? new SlotList(new SlotList.SlotType[0]) : EnhancementHandler.getEnhancementSlotsForItem(mainIS.func_77973_b());
        for (a = slots.amountPowder; a < this.powderSlots.length; ++a) {
            index = this.powderSlots[0].field_75222_d + a;
            if (this.containerInv.func_70301_a(index) == null) continue;
            toDrop.add(this.containerInv.func_70301_a(index));
            this.containerInv.func_70299_a(index, null);
        }
        for (a = slots.amountIngredient; a < this.ingredientSlots.length; ++a) {
            index = this.ingredientSlots[0].field_75222_d + a;
            if (this.containerInv.func_70301_a(index) == null) continue;
            toDrop.add(this.containerInv.func_70301_a(index));
            this.containerInv.func_70299_a(index, null);
        }
        if (this.owner != null && !this.owner.field_70170_p.field_72995_K) {
            for (ItemStack is : toDrop) {
                this.owner.func_71019_a(is, false);
            }
        }
    }

    public void onEnhancementSlotClick(int slot) {
        if (this.selectedSlot != slot) {
            List<IEnhancementEnum> enhancements = EnhancementHandler.getEnhancementsForItem(this.func_75139_a(0).func_75211_c().func_77973_b());
            if (slot < 0 || slot >= enhancements.size()) {
                Log.reportedError("Received S01 enhancement gui packet with invalid slot - $0", slot);
            } else {
                this.selectedEnhancement = enhancements.get(slot);
                this.selectedSlot = slot;
            }
        } else if (this.selectedEnhancement != null) {
            ItemStack is;
            int a;
            ItemStack mainIS = this.func_75139_a(0).func_75211_c();
            List<IEnhancementEnum> enhancements = EnhancementHandler.getEnhancementsForItem(mainIS.func_77973_b());
            if (slot < 0 || slot >= enhancements.size()) {
                Log.reportedError("Received S01 enhancement gui packet with invalid slot - $0", slot);
                return;
            }
            IEnhancementEnum enhancement = enhancements.get(slot);
            if (EnhancementHandler.getEnhancements(mainIS).contains(enhancement)) {
                return;
            }
            SlotList slots = EnhancementHandler.getEnhancementSlotsForItem(mainIS.func_77973_b());
            int enhancedAmount = mainIS.field_77994_a;
            for (a = 0; a < slots.amountIngredient; ++a) {
                is = this.ingredientSlots[a].func_75211_c();
                if (is == null || !enhancement.getItemSelector().isValid(is)) {
                    enhancedAmount = 0;
                    break;
                }
                if (is.field_77994_a >= enhancedAmount) continue;
                enhancedAmount = is.field_77994_a;
            }
            for (a = 0; a < slots.amountPowder; ++a) {
                is = this.powderSlots[a].func_75211_c();
                if (is == null) {
                    enhancedAmount = 0;
                    break;
                }
                if (is.field_77994_a >= enhancedAmount) continue;
                enhancedAmount = is.field_77994_a;
            }
            if (enhancedAmount > 0) {
                int a2;
                ItemStack newIS = EnhancementHandler.addEnhancement(mainIS, enhancement);
                newIS.field_77994_a = enhancedAmount;
                ItemStack currentOutput = this.func_75139_a(1).func_75211_c();
                if (!(currentOutput == null || currentOutput.func_77973_b() == newIS.func_77973_b() && currentOutput.func_77960_j() == newIS.func_77960_j() && ItemStack.func_77970_a((ItemStack)currentOutput, (ItemStack)newIS))) {
                    return;
                }
                if (currentOutput != null && currentOutput.field_77994_a + newIS.field_77994_a > newIS.func_77976_d()) {
                    newIS.field_77994_a = enhancedAmount = newIS.func_77976_d() - currentOutput.field_77994_a;
                }
                if (currentOutput != null) {
                    newIS.field_77994_a += currentOutput.field_77994_a;
                }
                if (mainIS.field_77994_a - enhancedAmount == 0 && mainIS.field_77994_a > 1) {
                    newIS.field_77994_a = --enhancedAmount;
                }
                if (this.owner != null) {
                    enhancement.onEnhanced(newIS, (EntityPlayer)this.owner);
                    if (this.isEnhancingTile()) {
                        this.enhanceableTile.getEnhancements().clear();
                        this.enhanceableTile.getEnhancements().addAll(EnhancementHandler.getEnhancements(newIS));
                    }
                }
                this.containerInv.func_70299_a(this.isEnhancingTile() ? 0 : 1, newIS);
                if (!this.isEnhancingTile() && (mainIS.field_77994_a -= enhancedAmount) <= 0) {
                    this.containerInv.func_70299_a(0, null);
                }
                for (a2 = 0; a2 < slots.amountPowder; ++a2) {
                    if ((this.powderSlots[a2].func_75211_c().field_77994_a -= enhancedAmount) > 0) continue;
                    this.containerInv.func_70299_a(2 + a2, null);
                }
                for (a2 = 0; a2 < slots.amountIngredient; ++a2) {
                    if ((this.ingredientSlots[a2].func_75211_c().field_77994_a -= enhancedAmount) > 0) continue;
                    this.containerInv.func_70299_a(2 + this.powderSlots.length + a2, null);
                }
                if (this.isEnhancingTile() || this.func_75139_a(0).func_75211_c() == null) {
                    this.onSubjectChanged();
                }
                if (CompendiumEvents.getPlayerData((EntityPlayer)this.owner).tryUnlockFragment(KnowledgeFragmentEnhancement.getEnhancementFragment(this.selectedEnhancement))) {
                    PacketPipeline.sendToPlayer((EntityPlayer)this.owner, new C19CompendiumData((EntityPlayer)this.owner));
                }
                PacketPipeline.sendToPlayer((EntityPlayer)this.owner, new C08PlaySound(10, this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 1.0f, 1.0f));
            } else if (this.owner != null) {
                for (a = 0; a < slots.amountPowder; ++a) {
                    if (this.powderSlots[a].func_75211_c() != null) continue;
                    return;
                }
                for (a = 0; a < slots.amountIngredient; ++a) {
                    if (this.ingredientSlots[a].func_75211_c() != null) continue;
                    return;
                }
                Random rand = this.owner.field_70170_p.field_73012_v;
                int powderBroken = 1;
                if (slots.amountPowder > 2) {
                    float add = (rand.nextFloat() + rand.nextFloat()) * 0.49f * (float)(slots.amountPowder - 1);
                    powderBroken += rand.nextBoolean() ? MathUtil.floor(add) : MathUtil.ceil(add);
                }
                while (powderBroken > 0) {
                    int index = rand.nextInt(slots.amountPowder);
                    if (this.powderSlots[index].func_75211_c() == null) continue;
                    if (--this.powderSlots[index].func_75211_c().field_77994_a <= 0) {
                        this.containerInv.func_70299_a(2 + index, null);
                    }
                    --powderBroken;
                }
                if (rand.nextInt(4 + (slots.amountPowder + slots.amountIngredient >> 1)) == 0) {
                    CompendiumEvents.getPlayerData((EntityPlayer)this.owner).tryUnlockFragment(KnowledgeFragmentEnhancement.getEnhancementFragment(this.selectedEnhancement));
                    PacketPipeline.sendToPlayer((EntityPlayer)this.owner, new C19CompendiumData((EntityPlayer)this.owner));
                }
                PacketPipeline.sendToPlayer((EntityPlayer)this.owner, new C08PlaySound(9, this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 0.8f, 1.2f));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onEnhancementSlotChangeClient(int selectedSlot) {
        ItemStack mainIS = this.func_75139_a(0).func_75211_c();
        if (mainIS == null) {
            this.prevSelectedSlot = -1;
            return;
        }
        if (selectedSlot == -1) {
            selectedSlot = this.prevSelectedSlot;
        } else {
            this.prevSelectedSlot = selectedSlot;
        }
        List<IEnhancementEnum> enhancements = EnhancementHandler.getEnhancementsForItem(mainIS.func_77973_b());
        List<Enum> currentEnhancements = EnhancementHandler.getEnhancements(mainIS);
        StringBuilder build = new StringBuilder();
        for (int a = 0; a < enhancements.size(); ++a) {
            IEnhancementEnum enhancement = enhancements.get(a);
            this.clientEnhancementTooltips[a] = build.append(EnumChatFormatting.LIGHT_PURPLE).append(DragonUtil.stripChatFormatting(enhancement.getName())).append("\n").append(EnumChatFormatting.GRAY).append(I18n.func_135052_a((String)(currentEnhancements.contains(enhancement) ? "enhancements.alreadyEnhanced" : (selectedSlot == a ? "enhancements.clickEnhance" : "enhancements.clickSelect")), (Object[])new Object[0])).toString();
            this.clientEnhancementBlocked[a] = currentEnhancements.contains(enhancement);
            build.setLength(0);
        }
    }

    public boolean isEnhancingTile() {
        return this.enhanceableTile != null;
    }
}

