/*
 * Decompiled with CFR 0.152.
 */
package emt.tile.generator;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import emt.client.gui.EMT_UITextures;
import emt.tile.DefinitelyNotAIC2Source;
import emt.tile.TileEntityEMT;
import emt.util.EMTConfigHandler;
import emt.util.EMTEssentiasOutputs;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_Block_Event;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXEssentiaSource;

public class TileEntityBaseGenerator
extends TileEntityEMT
implements IInventory,
IAspectContainer,
IEssentiaTransport,
IHasWorldObjectAndCoords,
IEnergyConnected,
IBasicEnergyContainer,
ITileWithModularUI {
    public DefinitelyNotAIC2Source energySource = new DefinitelyNotAIC2Source(this, 100000L, 2);
    public Aspect aspect;
    public double generating;
    public int tick = 0;
    public boolean isActive = false;
    public int tier;
    public int storage;
    public short mpshownstroage;
    public int maxstorage;
    public byte maxfuel;
    public byte fuel;
    public byte refuel;
    public long timer = 0L;
    public boolean dead = true;
    public byte color;
    private boolean side;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public TileEntityBaseGenerator(int aspect) {
        this();
        switch (aspect) {
            case 0: {
                this.aspect = Aspect.ENERGY;
                break;
            }
            case 1: {
                this.aspect = Aspect.FIRE;
                break;
            }
            case 2: {
                this.aspect = Aspect.AURA;
                break;
            }
            case 3: {
                this.aspect = Aspect.TREE;
                break;
            }
            case 4: {
                this.aspect = Aspect.AIR;
                break;
            }
            case 5: {
                this.aspect = Aspect.GREED;
            }
        }
        this.generating = EMTEssentiasOutputs.outputs.get(this.aspect.getTag());
    }

    public TileEntityBaseGenerator() {
        this.energySource.setCapacity(EMTConfigHandler.EssentiaGeneratorStorage);
        this.maxstorage = (int)this.energySource.getCapacity();
        this.maxfuel = (byte)64;
        this.fuel = 0;
        this.refuel = 1;
        this.color = (byte)-1;
    }

    public void func_145845_h() {
        this.side = !this.field_145850_b.field_72995_K;
        this.dead = false;
        ++this.timer;
        if (this.timer <= 0x7FFFFFFFFFFFFFFEL) {
            this.timer = 0L;
        }
        this.storeFuel();
        this.fillfrompipe();
        this.createEnergy();
        this.inputintoGTnet();
    }

    public void storeFuel() {
        if (!this.side) {
            return;
        }
        if (this.fuel < this.maxfuel) {
            for (int x = this.field_145851_c - 4; x < this.field_145851_c + 4; ++x) {
                for (int y = this.field_145848_d - 4; y < this.field_145848_d + 4; ++y) {
                    for (int z = this.field_145849_e - 4; z < this.field_145849_e + 4; ++z) {
                        IAspectSource as;
                        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                        if (!(tile instanceof IAspectSource) || !(as = (IAspectSource)tile).doesContainerContainAmount(this.aspect, (int)this.refuel) || !as.takeFromContainer(this.aspect, (int)this.refuel)) continue;
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXEssentiaSource(this.field_145851_c, this.field_145848_d, this.field_145849_e, (byte)(this.field_145851_c - x), (byte)(this.field_145848_d - y), (byte)(this.field_145849_e - z), this.aspect.getColor()), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
                        this.addToContainer(this.aspect, this.refuel);
                    }
                }
            }
        }
    }

    public void fillfrompipe() {
        if (!this.side) {
            return;
        }
        if (this.fuel == this.maxfuel) {
            return;
        }
        TileEntity[] te = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            te[i] = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i]);
            if (te[i] == null) continue;
            IEssentiaTransport pipe = (IEssentiaTransport)te[i];
            if (!pipe.canOutputTo(ForgeDirection.VALID_DIRECTIONS[i])) {
                return;
            }
            if (pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]) == null || !pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]).equals(this.aspect) || pipe.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i]) >= this.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i])) continue;
            this.addToContainer(this.aspect, pipe.takeEssentia(this.aspect, 1, ForgeDirection.VALID_DIRECTIONS[i]));
        }
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)("tile.EMT.essentia." + this.aspect.getTag() + ".name"));
    }

    public void createEnergy() {
        if (!this.side) {
            if (this.isActive && this.tick < 400) {
                ++this.tick;
            }
            return;
        }
        if (this.fuel > 0) {
            if ((double)this.storage + this.generating / 20.0 / 20.0 < (double)this.maxstorage) {
                this.isActive = true;
                this.energySource.addEnergy(this.generating / 20.0 / 20.0);
                this.storage = (int)this.energySource.getEnergyStored();
                ++this.tick;
                if (this.tick == 400) {
                    this.fuel = (byte)(this.fuel - 1);
                    this.tick = 0;
                }
            } else {
                this.isActive = false;
            }
        } else {
            this.isActive = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energySource.setEnergyStored(tag.func_74763_f("estore"));
        if (tag.func_74771_c("fuel") > this.fuel) {
            this.fuel = tag.func_74771_c("fuel");
        }
        if (!tag.func_74779_i("aspect").isEmpty()) {
            this.aspect = Aspect.getAspect((String)tag.func_74779_i("aspect"));
            this.generating = EMTEssentiasOutputs.outputs.get(this.aspect.getTag());
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("fuel", (int)this.fuel);
        tag.func_74772_a("estore", this.energySource.getEnergyStored());
        if (this.aspect != null) {
            tag.func_74778_a("aspect", this.aspect.getTag());
        }
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int gaugeEnergyScaled(int i) {
        return this.mpshownstroage * 1000 * i / this.maxstorage;
    }

    public int gaugeFuelScaled(int i) {
        return this.fuel * i / this.maxfuel;
    }

    public boolean func_94041_b(int i, ItemStack Stack) {
        return false;
    }

    public AspectList getAspects() {
        return new AspectList().add(this.aspect, (int)this.fuel);
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return tag.equals(this.aspect);
    }

    public int addToContainer(Aspect tag, int amount) {
        if (!tag.equals(this.aspect) || amount < 0) {
            return amount;
        }
        if (amount + this.fuel < this.maxfuel) {
            this.fuel = (byte)(this.fuel + amount);
            return 0;
        }
        this.fuel = (byte)(this.fuel + (amount - (amount - (this.maxfuel - this.fuel))));
        return amount - (this.maxfuel - this.fuel);
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return tag.equals(this.aspect) && amount <= this.fuel;
    }

    public boolean doesContainerContain(AspectList ot) {
        return ot.aspects.containsKey(this.aspect) && (Integer)ot.aspects.get(this.aspect) == this.fuel;
    }

    public int containerContains(Aspect tag) {
        return tag == this.aspect ? this.fuel : (byte)0;
    }

    public boolean isConnectable(ForgeDirection face) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return this.aspect;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return this.fuel == this.maxfuel ? 0 : 128;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (amount < this.maxfuel - this.fuel) {
            return amount;
        }
        return this.maxfuel - this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.aspect;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.fuel;
    }

    public int getMinimumSuction() {
        return Integer.MAX_VALUE;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public void inputintoGTnet() {
        if (!this.side) {
            return;
        }
        if (this.isUniversalEnergyStored(this.getOutputVoltage() * this.getOutputAmperage())) {
            long tEU = IEnergyConnected.Util.emitEnergyToNetwork((long)this.getOutputVoltage(), (long)this.getOutputAmperage(), (IEnergyConnected)this);
            this.drainEnergyUnits(ForgeDirection.DOWN, this.getOutputVoltage(), tEU);
        }
    }

    public byte getColorization() {
        return this.color;
    }

    public byte setColorization(byte aColor) {
        this.color = aColor;
        return this.color;
    }

    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return aEnergyAmount < this.energySource.getEnergyStored();
    }

    public long getUniversalEnergyStored() {
        return this.energySource.getEnergyStored();
    }

    public long getUniversalEnergyCapacity() {
        return (long)this.energySource.getCapacity();
    }

    public long getOutputAmperage() {
        if (this.generating / 20.0 / 20.0 <= (double)GT_Values.V[this.energySource.getSourceTier()]) {
            return 1L;
        }
        if (this.generating / 20.0 / 20.0 % (double)GT_Values.V[this.energySource.getSourceTier()] == 0.0) {
            return (long)(this.generating / 20.0 / 20.0 / (double)GT_Values.V[this.energySource.getSourceTier()]);
        }
        return (long)(1.0 + this.generating / 20.0 / 20.0 / (double)GT_Values.V[this.energySource.getSourceTier()]);
    }

    public long getOutputVoltage() {
        return GT_Values.V[this.energySource.getSourceTier()];
    }

    public long getInputAmperage() {
        return 0L;
    }

    public long getInputVoltage() {
        return 0L;
    }

    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.energySource.getEnergyStored() > aEnergy) {
            this.energySource.drawEnergy(aEnergy);
            this.storage = (int)this.energySource.getEnergyStored();
            return true;
        }
        return false;
    }

    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return this.decreaseStoredEnergyUnits(aVoltage * aAmperage, this.energySource.getEnergyStored() > aVoltage * aAmperage);
    }

    public long getAverageElectricInput() {
        return 0L;
    }

    public long getAverageElectricOutput() {
        return 0L;
    }

    public long getStoredEU() {
        return this.energySource.getEnergyStored();
    }

    public long getEUCapacity() {
        return (long)this.energySource.getCapacity();
    }

    public long getStoredSteam() {
        return 0L;
    }

    public long getSteamCapacity() {
        return 0L;
    }

    public boolean increaseStoredSteam(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return 0L;
    }

    public boolean inputEnergyFrom(ForgeDirection side) {
        return false;
    }

    public boolean outputsEnergyTo(ForgeDirection side) {
        return true;
    }

    public boolean energyStateReady() {
        return true;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getXCoord() {
        return this.field_145851_c;
    }

    public short getYCoord() {
        return (short)this.field_145848_d;
    }

    public int getZCoord() {
        return this.field_145849_e;
    }

    public boolean isServerSide() {
        return !this.field_145850_b.field_72995_K;
    }

    public boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    public int getRandomNumber(int aRange) {
        return this.field_145850_b.field_73012_v.nextInt(aRange);
    }

    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    public TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147438_o(aX + this.field_145851_c, aY + this.field_145848_d, aZ + this.field_145849_e);
    }

    public TileEntity getTileEntityAtSide(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return null;
        }
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        return this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
    }

    public TileEntity getTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        if (aDistance == 1) {
            return this.getTileEntityAtSide(side);
        }
        return this.getTileEntity(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public IInventory getIInventory(int aX, int aY, int aZ) {
        return null;
    }

    public IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        return null;
    }

    public IInventory getIInventoryAtSide(ForgeDirection side) {
        return null;
    }

    public IInventory getIInventoryAtSideAndDistance(ForgeDirection side, int aDistance) {
        return null;
    }

    public IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        return null;
    }

    public IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        return null;
    }

    public IFluidHandler getITankContainerAtSide(ForgeDirection side) {
        return null;
    }

    public IFluidHandler getITankContainerAtSideAndDistance(ForgeDirection side, int aDistance) {
        return null;
    }

    public IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    public IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        return this.getIGregTechTileEntity(aX + this.field_145851_c, aY + this.field_145848_d, aZ + this.field_145849_e);
    }

    public IGregTechTileEntity getIGregTechTileEntityAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    public IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    public Block getBlock(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    public Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public Block getBlockAtSide(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return null;
        }
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        return this.field_145850_b.func_147439_a(tX, (int)tY, tZ);
    }

    public Block getBlockAtSideAndDistance(ForgeDirection side, int aDistance) {
        if (aDistance == 1) {
            return this.getBlockAtSide(side);
        }
        return this.getBlock(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public byte getMetaID(int aX, int aY, int aZ) {
        return (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    public byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public byte getMetaIDAtSide(ForgeDirection side) {
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        return (byte)this.field_145850_b.func_72805_g(tX, (int)tY, tZ);
    }

    public byte getMetaIDAtSideAndDistance(ForgeDirection side, int aDistance) {
        if (aDistance == 1) {
            return this.getMetaIDAtSide(side);
        }
        return this.getMetaID(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public byte getLightLevel(int aX, int aY, int aZ) {
        return 0;
    }

    public byte getLightLevelOffset(int aX, int aY, int aZ) {
        return 0;
    }

    public byte getLightLevelAtSide(ForgeDirection side) {
        return 0;
    }

    public byte getLightLevelAtSideAndDistance(ForgeDirection side, int aDistance) {
        return 0;
    }

    public boolean getOpacity(int aX, int aY, int aZ) {
        return false;
    }

    public boolean getOpacityOffset(int aX, int aY, int aZ) {
        return false;
    }

    public boolean getOpacityAtSide(ForgeDirection side) {
        return false;
    }

    public boolean getOpacityAtSideAndDistance(ForgeDirection side, int aDistance) {
        return false;
    }

    public boolean getSky(int aX, int aY, int aZ) {
        boolean sky = true;
        do {
            if (this.field_145850_b.func_147439_a(aX, ++aY, aZ).equals(Blocks.field_150350_a)) continue;
            sky = false;
        } while (sky && aY < 256);
        return sky;
    }

    public boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(aX + this.field_145851_c, aY + this.field_145848_d, aZ + this.field_145849_e);
    }

    public boolean getSkyAtSide(ForgeDirection side) {
        return false;
    }

    public boolean getSkyAtSideAndDistance(ForgeDirection side, int aDistance) {
        return false;
    }

    public boolean getAir(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147439_a(aX, aY, aZ).equals(Blocks.field_150350_a);
    }

    public boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public boolean getAirAtSide(ForgeDirection side) {
        return this.getAirAtSideAndDistance(side, 1);
    }

    public boolean getAirAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getAir(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public BiomeGenBase getBiome() {
        return this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
    }

    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    public int getOffsetX(ForgeDirection side, int aMultiplier) {
        return this.field_145851_c + side.offsetX * aMultiplier;
    }

    public short getOffsetY(ForgeDirection side, int aMultiplier) {
        return (short)(this.field_145848_d + side.offsetY * aMultiplier);
    }

    public int getOffsetZ(ForgeDirection side, int aMultiplier) {
        return this.field_145849_e + side.offsetZ * aMultiplier;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void sendBlockEvent(byte aID, byte aValue) {
        GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, (GT_Packet)new GT_Packet_Block_Event(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    public long getTimer() {
        return this.timer;
    }

    public void setLightValue(byte aLightValue) {
    }

    public boolean isInvalidTileEntity() {
        return this.field_145846_f;
    }

    public boolean outputsEnergyTo(ForgeDirection side, boolean b1) {
        return true;
    }

    public boolean inputEnergyFrom(ForgeDirection side, boolean b1) {
        return false;
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        ModularWindow.Builder builder = ModularWindow.builder((int)176, (int)107);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget(new Text(this.func_145825_b()).color(6618118).shadow()).setPos(9, 9))).widget(new ProgressBar().setTexture(EMT_UITextures.PICTURE_GAUGE_EMPTY_25, EMT_UITextures.PICTURE_GAUGE_GENERATOR, 25).setProgress(() -> Float.valueOf((float)this.storage / (float)this.maxstorage)).setSynced(false, false).setPos(9, 24).setSize(25, 11))).widget(new ProgressBar().setTexture(EMT_UITextures.PICTURE_GAUGE_EMPTY_25, EMT_UITextures.PICTURE_GAUGE_GENERATOR, 25).setProgress(() -> Float.valueOf((float)this.fuel / (float)this.maxfuel)).setSynced(false, false).setPos(9, 43).setSize(25, 11))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"emt.Storage") + " " + numberFormat.formatWithSuffix((long)this.storage) + "/" + numberFormat.formatWithSuffix((long)this.maxstorage) + " EU").setDefaultColor(0).setPos(36, 22))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.storage, val -> {
            this.storage = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"emt.Generating") + " " + numberFormat.formatWithSuffix(this.isActive ? (long)(this.generating / 20.0 / 20.0) : 0L) + " EU/t").setDefaultColor(0).setPos(36, 35))).widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.generating, val -> {
            this.generating = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.isActive, val -> {
            this.isActive = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"emt.Fuel") + ": " + numberFormat.formatWithSuffix((long)this.fuel)).setDefaultColor(0).setPos(36, 48))).widget((Widget)new FakeSyncWidget.ByteSyncer(() -> this.fuel, val -> {
            this.fuel = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"emt.remaining_second") + " " + numberFormat.format((long)((this.fuel * 20 * 20 - this.tick) / 20))).setDefaultColor(0).setPos(36, 63))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.tick, val -> {
            this.tick = val;
        }));
        return builder.build();
    }
}

