/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import java.util.Locale;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.util.StatCollector;

public class SolarSystem {
    protected final String systemName;
    protected String unlocalizedName;
    protected Vector3 mapPosition = null;
    protected Star mainStar = null;
    protected String unlocalizedGalaxyName;

    public SolarSystem(String solarSystem, String parentGalaxy) {
        this.systemName = solarSystem.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = solarSystem;
        this.unlocalizedGalaxyName = parentGalaxy;
    }

    public String getName() {
        return this.systemName;
    }

    public final int getID() {
        return GalaxyRegistry.getSolarSystemID(this.systemName);
    }

    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : StatCollector.func_74838_a((String)s);
    }

    public String getUnlocalizedName() {
        return "solarsystem." + this.unlocalizedName;
    }

    public Vector3 getMapPosition() {
        return this.mapPosition;
    }

    public SolarSystem setMapPosition(Vector3 mapPosition) {
        mapPosition.scale(500.0);
        this.mapPosition = mapPosition;
        return this;
    }

    public Star getMainStar() {
        return this.mainStar;
    }

    public SolarSystem setMainStar(Star star) {
        this.mainStar = star;
        return this;
    }

    public String getLocalizedParentGalaxyName() {
        String s = this.getUnlocalizedParentGalaxyName();
        return s == null ? "" : StatCollector.func_74838_a((String)s);
    }

    public String getUnlocalizedParentGalaxyName() {
        return "galaxy." + this.unlocalizedGalaxyName;
    }
}

