/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockTelemetry
extends BlockAdvancedTile
implements ItemBlockDesc.IBlockShiftDesc {
    private IIcon iconFront;
    private IIcon iconSide;

    protected BlockTelemetry(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d("iron_block");
        this.func_149663_c(assetName);
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconFront = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "cargo_pad");
        this.iconSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "cargo_pad");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == (metadata & 7)) {
            return this.iconSide;
        }
        return this.iconFront;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 4;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 5;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        int facing = metadata & 3;
        int change = 0;
        switch (facing) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 3;
                break;
            }
            case 2: {
                change = 5;
                break;
            }
            case 3: {
                change = 4;
                break;
            }
            case 4: {
                change = 2;
                break;
            }
            case 5: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change += 0xC & metadata, 2);
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTelemetry();
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityTelemetry) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (held != null && held.func_77973_b() == GCItems.basicItem && held.func_77960_j() == 19) {
                NBTTagCompound fmData = held.field_77990_d;
                if (fmData != null && fmData.func_74764_b("linkedUUIDMost") && fmData.func_74764_b("linkedUUIDLeast")) {
                    UUID uuid = new UUID(fmData.func_74763_f("linkedUUIDMost"), fmData.func_74763_f("linkedUUIDLeast"));
                    ((TileEntityTelemetry)tile).addTrackedEntity(uuid);
                    player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetrySucceed.message")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetryFail.message")));
                    if (fmData == null) {
                        fmData = new NBTTagCompound();
                        held.func_77982_d(fmData);
                    }
                }
                fmData.func_74768_a("teCoordX", x);
                fmData.func_74768_a("teCoordY", y);
                fmData.func_74768_a("teCoordZ", z);
                fmData.func_74768_a("teDim", world.field_73011_w.field_76574_g);
                return true;
            }
            ItemStack wearing = GCPlayerStats.get((EntityPlayerMP)((EntityPlayerMP)player)).frequencyModuleInSlot;
            if (wearing != null) {
                if (wearing.func_77942_o() && wearing.func_77978_p().func_74764_b("teDim")) {
                    return false;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetryFailWearingIt.message")));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.telemetryFailNoFrequencyModule.message")));
            }
        }
        return false;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

