/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import java.util.Random;
import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public final class ParticleLogicOrbitEntity
extends ParticleLogic {
    private final Entity target;
    private double distance;
    private final boolean rotateClockwise;
    private double targetY;
    private double curYOffset;
    private double targetDistance;
    private final double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean ignoreYCoordinate = false;

    public ParticleLogicOrbitEntity(Entity orbitTarget, double orbitSpeed) {
        this.target = orbitTarget;
        this.orbitAngle = this.rand.nextInt(360);
        this.rotateClockwise = this.rand.nextBoolean();
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.rand.nextDouble() * 0.5;
        this.orbitSpeed = orbitSpeed;
    }

    public ParticleLogicOrbitEntity setOrbitY(double orbitY) {
        this.orbitY = orbitY;
        return this;
    }

    public ParticleLogicOrbitEntity setTargetDistance(double targetDistance) {
        this.targetDistance = targetDistance;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? new Random().nextDouble() * (double)this.target.field_70131_O : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    @Override
    public void doUpdate() {
        if (this.firstTick) {
            this.curYOffset = this.particle.field_70163_u - (this.target.field_70163_u + (double)this.target.func_70047_e());
        }
        if (this.target == null || this.target.field_70128_L) {
            this.finishLogic();
            return;
        }
        double posY = this.particle.field_70163_u;
        if (Math.abs(this.targetY - this.curYOffset) < 0.1) {
            this.generateNewTargetY();
        }
        double posX = this.target.field_70165_t + Math.cos(this.orbitAngle) * this.targetDistance;
        double posZ = this.target.field_70161_v + Math.sin(this.orbitAngle) * this.targetDistance;
        if (this.targetY < this.curYOffset) {
            this.curYOffset -= this.orbitSpeed / 4.0;
        } else if (this.targetY > this.curYOffset) {
            this.curYOffset += this.orbitSpeed / 4.0;
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (!this.ignoreYCoordinate) {
            if (this.orbitY != -512.0) {
                posY = this.target.field_70163_u + (double)this.target.func_70047_e() + this.orbitY;
            } else {
                int offset = 0;
                if (this.target instanceof EntityPlayer && !(this.target instanceof EntityClientPlayerMP)) {
                    offset = (int)((float)offset + 2.0f * this.target.field_70131_O);
                }
                posY = this.target.field_70163_u - (double)this.target.func_70047_e() + this.curYOffset + (double)offset;
            }
        }
        this.particle.func_70107_b(posX, posY, posZ);
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicOrbitEntity clone = new ParticleLogicOrbitEntity(this.target, this.orbitSpeed).setTargetDistance(this.targetDistance);
        if (this.orbitY != -512.0) {
            clone.setOrbitY(this.orbitY);
        }
        clone.setIgnoreYCoordinate(this.ignoreYCoordinate);
        return clone.setFinal(this.finalLogic).setPriority(this.priority);
    }

    public ParticleLogicOrbitEntity setIgnoreYCoordinate(boolean b) {
        this.ignoreYCoordinate = b;
        return this;
    }
}

