/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.util.StatCollector;

public class GuiHelper {
    protected static DecimalFormat numberFormat = new DecimalFormat("#.##");
    public static final String[] metricHigh = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};
    public static final String[] metricLow = new String[]{"m", "\u00b5", "n", "p", "f", "a", "z", "y"};

    public static String formatMetric(double number) {
        return GuiHelper.formatMetric(number, "");
    }

    public static String formatMetric(double number, String unit) {
        return GuiHelper.formatMetric(number, unit, false);
    }

    public static String formatMetric(double number, String unit, boolean addSpace) {
        if (number < 0.0) {
            return "-" + GuiHelper.formatMetric(number * -1.0, unit);
        }
        if (number == 0.0) {
            if (addSpace) {
                return String.format("%s %s", numberFormat.format(number), unit);
            }
            return String.format("%s%s", numberFormat.format(number), unit);
        }
        String suffix = "";
        int numZeroes = (int)Math.floor(Math.log10(number));
        int numThousands = (int)Math.floor(numZeroes / 3);
        if (numThousands > 0) {
            if (numThousands > metricHigh.length) {
                numThousands = metricHigh.length;
            }
            number /= Math.pow(1000.0, numThousands);
            suffix = metricHigh[numThousands - 1];
        } else if (numThousands < 0) {
            if ((numThousands *= -1) > metricLow.length) {
                numThousands = metricLow.length;
            }
            number /= Math.pow(0.001, numThousands);
            suffix = metricLow[numThousands - 1];
        }
        String result = numberFormat.format(number);
        if (!suffix.isEmpty()) {
            if (addSpace) {
                return String.format("%s %s%s", result, suffix, unit);
            }
            return String.format("%s%s%s", result, suffix, unit);
        }
        if (addSpace) {
            return String.format("%s %s", result, unit);
        }
        return String.format("%s%s", result, unit);
    }

    public static String formatKilogram(double number) {
        return GuiHelper.formatKilogram(number, false);
    }

    public static String formatKilogram(double number, boolean addSpace) {
        if (number < 0.0) {
            return "-" + GuiHelper.formatKilogram(number * -1.0, addSpace);
        }
        if (number < 1000.0) {
            return GuiHelper.formatMetric(number * 1000.0, "g", addSpace);
        }
        return GuiHelper.formatMetric(number / 1000.0, "t", addSpace);
    }

    public static String formatTime(long number) {
        return GuiHelper.formatTime(number, false);
    }

    public static String formatTime(long number, boolean formatDate) {
        double hoursFraction = (double)number / 1000.0;
        int hours = (int)hoursFraction;
        hoursFraction -= (double)hours;
        int minutes = (int)(hoursFraction *= 60.0);
        hoursFraction -= (double)minutes;
        int seconds = (int)(hoursFraction *= 60.0);
        if (hours <= 24 || !formatDate) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        int days = hours / 24;
        hours = (int)((double)hours - (double)days * 24.0);
        if (days <= 9) {
            return String.format("%dd %02d:%02d:%02d", days, hours, minutes, seconds);
        }
        if (days >= 30) {
            int months = days / 30;
            days = (int)((double)days - (double)months * 30.0);
            if (months >= 12) {
                int years = months / 12;
                months = (int)((double)months - (double)years * 12.0);
                if (years >= 10) {
                    return String.format("> %dy", years);
                }
                return String.format("%dy %dm %dd", years, months, days);
            }
            return String.format("%dm %dd", months, days);
        }
        return String.format("%dd", days);
    }

    public static String formatSpeed(double number) {
        return GuiHelper.formatSpeed(number, false);
    }

    public static String formatSpeed(double number, boolean addSpace) {
        return GuiHelper.formatMetric(number * 1000.0, "AU/h", addSpace);
    }

    public static String getGasName(IAtmosphericGas gas) {
        return GCCoreUtil.translate((String)GuiHelper.getGasNameUntranslated(gas));
    }

    public static String getGasNameUntranslated(IAtmosphericGas gas) {
        String string;
        switch (gas) {
            case ARGON: {
                string = "gas.argon.name";
                break;
            }
            case CO2: {
                string = "gas.carbondioxide.name";
                break;
            }
            case HELIUM: {
                string = "gas.helium.name";
                break;
            }
            case HYDROGEN: {
                string = "gas.hydrogen.name";
                break;
            }
            case METHANE: {
                string = "gas.methane.name";
                break;
            }
            case NITROGEN: {
                string = "gas.nitrogen.name";
                break;
            }
            case OXYGEN: {
                string = "gas.oxygen.name";
                break;
            }
            case WATER: {
                string = "tile.water.name";
                break;
            }
            default: {
                string = "item.baseItem.tricorder.message.unknownGas";
            }
        }
        return string;
    }

    public static List<String> translateWithSplitColor(String key, EnumColor color) {
        String translated = StatCollector.func_74838_a((String)key);
        int comment = translated.indexOf(35);
        translated = comment > 0 ? translated.substring(0, comment).trim() : translated;
        String[] parts = translated.split("\\$");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = color.getCode() + parts[i];
        }
        return Arrays.asList(parts);
    }
}

