/*
 * Decompiled with CFR 0.152.
 */
package mantle.world;

public class CoordTuple
implements Comparable {
    public final int x;
    public final int y;
    public final int z;

    public CoordTuple(double posX, double posY, double posZ) {
        this.x = (int)Math.floor(posX);
        this.y = (int)Math.floor(posY);
        this.z = (int)Math.floor(posZ);
    }

    public boolean equalCoords(int posX, int posY, int posZ) {
        return this.x == posX && this.y == posY && this.z == posZ;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CoordTuple)) {
            return false;
        }
        CoordTuple that = (CoordTuple)obj;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "X: " + this.x + ", Y: " + this.y + ", Z: " + this.z;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Object cannot be null");
        }
        CoordTuple coord = (CoordTuple)o;
        if (this.x < coord.x) {
            return -1;
        }
        if (this.x > coord.x) {
            return 1;
        }
        if (this.y < coord.y) {
            return -1;
        }
        if (this.y > coord.y) {
            return 1;
        }
        if (this.z < coord.z) {
            return -1;
        }
        if (this.z > coord.z) {
            return 1;
        }
        return 0;
    }

    public static CoordTuple up(int x, int y, int z) {
        return new CoordTuple(x, y + 1, z);
    }

    public static CoordTuple down(int x, int y, int z) {
        return new CoordTuple(x, y - 1, z);
    }

    public static CoordTuple north(int x, int y, int z) {
        return new CoordTuple(x, y, z - 1);
    }

    public static CoordTuple south(int x, int y, int z) {
        return new CoordTuple(x, y, z + 1);
    }

    public static CoordTuple east(int x, int y, int z) {
        return new CoordTuple(x + 1, y, z);
    }

    public static CoordTuple west(int x, int y, int z) {
        return new CoordTuple(x - 1, y, z);
    }

    public static CoordTuple inFront(int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                return CoordTuple.down(x, y, z);
            }
            case 1: {
                return CoordTuple.up(x, y, z);
            }
            case 2: {
                return CoordTuple.north(x, y, z);
            }
            case 3: {
                return CoordTuple.south(x, y, z);
            }
            case 4: {
                return CoordTuple.west(x, y, z);
            }
            case 5: {
                return CoordTuple.east(x, y, z);
            }
        }
        return new CoordTuple(x, y, z);
    }

    public static CoordTuple behind(int x, int y, int z, int meta) {
        switch (meta) {
            case 1: {
                return CoordTuple.down(x, y, z);
            }
            case 0: {
                return CoordTuple.up(x, y, z);
            }
            case 3: {
                return CoordTuple.north(x, y, z);
            }
            case 2: {
                return CoordTuple.south(x, y, z);
            }
            case 5: {
                return CoordTuple.west(x, y, z);
            }
            case 4: {
                return CoordTuple.east(x, y, z);
            }
        }
        return new CoordTuple(x, y, z);
    }

    public int getDistanceFrom(CoordTuple tuple) {
        return this.getDistanceFrom(tuple.x, tuple.y, tuple.z);
    }

    public int getDistanceFrom(int x1, int y1, int z1) {
        int xPos = this.x - x1;
        int yPos = this.y - y1;
        int zPos = this.z - z1;
        return xPos * xPos + yPos * yPos + zPos * zPos;
    }
}

