/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.renderer;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.api.utils.BlockPosition;
import blockrenderer6343.api.utils.Position;
import blockrenderer6343.api.utils.PositionedRect;
import blockrenderer6343.api.utils.Size;
import blockrenderer6343.client.utils.ProjectionUtils;
import blockrenderer6343.client.world.TrackedDummyWorld;
import codechicken.lib.vec.Vector3;
import com.github.bartimaeusnek.bartworks.common.blocks.BW_GlasBlocks;
import gregtech.common.render.GT_Renderer_Block;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;

public abstract class WorldSceneRenderer {
    public final World world;
    public final Set<BlockPosition> renderedBlocks = new HashSet<BlockPosition>();
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> onRender;
    private Consumer<MovingObjectPosition> onLookingAt;
    private int clearColor;
    private MovingObjectPosition lastTraceResult;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, -10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private boolean renderAllFaces = false;

    public WorldSceneRenderer(World world) {
        this.world = world;
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setOnWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.onRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<BlockPosition> blocks) {
        if (blocks != null) {
            this.renderedBlocks.addAll(blocks);
        }
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<MovingObjectPosition> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public void setRenderAllFaces(boolean renderAllFaces) {
        this.renderAllFaces = renderAllFaces;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public MovingObjectPosition getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void render(int x, int y, int width, int height, int mouseX, int mouseY) {
        Vector3f lookVec;
        MovingObjectPosition result;
        PositionedRect positionedRect = this.getPositionedRect(x, y, width, height);
        PositionedRect mouse = this.getPositionedRect(mouseX, mouseY, 0, 0);
        mouseX = mouse.position.x;
        mouseY = mouse.position.y;
        this.setupCamera(positionedRect);
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && mouseX > positionedRect.position.x && mouseX < positionedRect.position.x + positionedRect.size.width && mouseY > positionedRect.position.y && mouseY < positionedRect.position.y + positionedRect.size.height && (result = this.rayTrace(lookVec = ProjectionUtils.unProject(positionedRect, this.eyePos, this.lookAt, mouseX, mouseY))) != null) {
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        WorldSceneRenderer.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        this.lookAt = lookAt;
        Vector3 vecX = new Vector3(Math.cos(rotationPitch), 0.0, Math.sin(rotationPitch));
        Vector3 vecY = new Vector3(0.0, Math.tan(rotationYaw) * vecX.mag(), 0.0);
        Vector3 pos = vecX.copy().add(vecY).normalize().multiply(radius);
        this.eyePos = pos.add((double)lookAt.x, (double)lookAt.y, (double)lookAt.z).vector3f();
    }

    protected PositionedRect getPositionedRect(int x, int y, int width, int height) {
        return new PositionedRect(new Position(x, y), new Size(width, height));
    }

    public void setupCamera(PositionedRect positionedRect) {
        int x = positionedRect.getPosition().x;
        int y = positionedRect.getPosition().y;
        int width = positionedRect.getSize().width;
        int height = positionedRect.getSize().height;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushClientAttrib((int)-1);
        mc.field_71460_t.func_78483_a(0.0);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
        this.clearView(x, y, width, height);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluLookAt((float)this.eyePos.x, (float)this.eyePos.y, (float)this.eyePos.z, (float)this.lookAt.x, (float)this.lookAt.y, (float)this.lookAt.z, (float)this.worldUp.x, (float)this.worldUp.y, (float)this.worldUp.z);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        GL11.glClearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    protected void clearView(int x, int y, int width, int height) {
        WorldSceneRenderer.setGlClearColorFromInt(this.clearColor, this.clearColor >> 24);
        GL11.glClear((int)16640);
    }

    public static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopClientAttrib();
        GL11.glPopAttrib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)32826);
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_78483_a(0.0);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        int savedAo = mc.field_71474_y.field_74348_k;
        mc.field_71474_y.field_74348_k = 0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        try {
            tessellator.func_78380_c(0xF000F0);
            for (BlockPosition pos : this.renderedBlocks) {
                Block block = this.world.func_147439_a(pos.x, pos.y, pos.z);
                if (block.equals(Blocks.field_150350_a)) continue;
                RenderBlocks bufferBuilder = new RenderBlocks();
                bufferBuilder.field_147845_a = this.world;
                bufferBuilder.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                bufferBuilder.field_147837_f = this.renderAllFaces;
                if (BlockRenderer6343.isBartworksLoaded && block instanceof BW_GlasBlocks) {
                    BW_GlasBlocks bwGlass = (BW_GlasBlocks)block;
                    bufferBuilder.func_147736_d(block, pos.x, pos.y, pos.z, (float)bwGlass.getColor(this.world.func_72805_g(pos.x, pos.y, pos.z))[0] / 255.0f, (float)bwGlass.getColor(this.world.func_72805_g(pos.x, pos.y, pos.z))[1] / 255.0f, (float)bwGlass.getColor(this.world.func_72805_g(pos.x, pos.y, pos.z))[2] / 255.0f);
                    continue;
                }
                if (BlockRenderer6343.isGTLoaded) {
                    if (GT_Renderer_Block.INSTANCE.renderWorldBlock((IBlockAccess)this.world, pos.x, pos.y, pos.z, block, block.func_149645_b(), bufferBuilder)) continue;
                    bufferBuilder.func_147805_b(block, pos.x, pos.y, pos.z);
                    continue;
                }
                bufferBuilder.func_147805_b(block, pos.x, pos.y, pos.z);
            }
            if (this.onRender != null) {
                this.onRender.accept(this);
            }
        }
        finally {
            mc.field_71474_y.field_74348_k = savedAo;
            tessellator.func_78381_a();
            tessellator.func_78373_b(0.0, 0.0, 0.0);
        }
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2896);
        TileEntityRendererDispatcher tesr = TileEntityRendererDispatcher.field_147556_a;
        int pass = 0;
        while (pass < 2) {
            ForgeHooksClient.setRenderPass((int)pass);
            int finalPass = pass++;
            this.renderedBlocks.forEach(blockPosition -> {
                WorldSceneRenderer.setDefaultPassRenderState(finalPass);
                TileEntity tile = this.world.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
                if (tile != null && tesr.func_147545_a(tile) && tile.shouldRenderInPass(finalPass)) {
                    tesr.func_147549_a(tile, (double)blockPosition.x, (double)blockPosition.y, (double)blockPosition.z, 0.0f);
                }
            });
        }
        ForgeHooksClient.setRenderPass((int)-1);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    public static void setDefaultPassRenderState(int pass) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
        }
    }

    public MovingObjectPosition rayTrace(Vector3f lookVec) {
        Vec3 startPos = Vec3.func_72443_a((double)this.eyePos.x, (double)this.eyePos.y, (double)this.eyePos.z);
        lookVec.scale(100.0f);
        Vec3 endPos = Vec3.func_72443_a((double)((double)lookVec.x + startPos.field_72450_a), (double)((double)lookVec.y + startPos.field_72448_b), (double)((double)lookVec.z + startPos.field_72449_c));
        return ((TrackedDummyWorld)this.world).rayTraceBlockswithTargetMap(startPos, endPos, this.renderedBlocks);
    }
}

