/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.api.utils.BlockPosition;
import blockrenderer6343.api.utils.CreativeItemSource;
import blockrenderer6343.api.utils.PositionedIStructureElement;
import blockrenderer6343.client.renderer.ImmediateWorldSceneRenderer;
import blockrenderer6343.client.renderer.WorldSceneRenderer;
import blockrenderer6343.client.utils.GuiText;
import blockrenderer6343.client.utils.TooltipButton;
import blockrenderer6343.client.world.ClientFakePlayer;
import blockrenderer6343.client.world.DummyWorld;
import blockrenderer6343.client.world.TrackedDummyWorld;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketNEIPatternRecipe;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ConstructableUtility;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public abstract class GUI_MultiblockHandler<T> {
    protected static ImmediateWorldSceneRenderer renderer;
    public static final int SLOT_SIZE = 18;
    protected static final int RECIPE_LAYOUT_X = 8;
    protected static final int RECIPE_LAYOUT_Y = 50;
    protected static final int RECIPE_WIDTH = 160;
    protected static final int sceneHeight = 150;
    protected static final int ICON_SIZE_X = 20;
    protected static final int ICON_SIZE_Y = 12;
    protected static final int MOUSE_OFFSET_X = 5;
    protected static final int MOUSE_OFFSET_Y = 43;
    protected static final int LAYER_BUTTON_X = -5;
    protected static final int UNDER_PREVIEW_Y = 135;
    protected static final int TIER_BUTTON_X = -5;
    protected static final int TIER_BUTTON_Y = 123;
    protected static final int PROJECT_BUTTON_X = 145;
    protected static final int OVERLAY_BUTTON_X = 120;
    protected static final float DEFAULT_RANGE_MULTIPLIER = 3.5f;
    public static final int MAX_PLACE_ROUNDS = 2000;
    public static final BlockPosition MB_PLACE_POS;
    protected static int guiMouseX;
    protected static int guiMouseY;
    protected static int lastGuiMouseX;
    protected static int lastGuiMouseY;
    protected static Vector3f center;
    protected static float rotationYaw;
    protected static float rotationPitch;
    protected static float zoom;
    protected static ItemStack tooltipBlockStack;
    protected static BlockPosition selectedBlock;
    protected static int layerIndex;
    protected static int guiColorBg;
    protected static int guiColorFont;
    protected static int buttonColorEnabled;
    protected static int buttonColorDisabled;
    protected static int buttonColorHovered;
    protected static String guiTextLayer;
    protected static String guiLayerButtonTitle;
    protected static String guiTextTier;
    protected static String guiTierButtonTitle;
    protected static int initialTierButtonTitleWidth;
    protected static int initialLayerButtonTitleWidth;
    protected ClearGuiButton previousLayerButton;
    protected ClearGuiButton nextLayerButton;
    protected List<ItemStack> ingredients = new ArrayList<ItemStack>();
    protected Consumer<List<ItemStack>> onIngredientChanged;
    protected final Map<GuiButton, Runnable> buttons = new HashMap<GuiButton, Runnable>();
    protected T renderingController;
    protected ItemStack stackForm;
    protected T lastRenderingController;
    protected final List<List<ItemStack>> candidates = new ArrayList<List<ItemStack>>();
    public static List<PositionedIStructureElement> structureElements;
    protected Consumer<List<List<ItemStack>>> onCandidateChanged;
    protected static int tierIndex;
    protected static EntityPlayer fakeMultiblockBuilder;
    protected int scrolled = 0;
    protected ClearGuiButton previousTierButton;
    protected ClearGuiButton nextTierButton;

    public GUI_MultiblockHandler() {
        this.previousLayerButton = new ClearGuiButton(0, -5, 135, 20, 12, "<");
        this.nextLayerButton = new ClearGuiButton(0, 15, 135, 20, 12, ">");
        this.buttons.put(this.previousLayerButton, this::togglePreviousLayer);
        this.buttons.put(this.nextLayerButton, this::toggleNextLayer);
        this.previousTierButton = new ClearGuiButton(0, -5, 123, 20, 12, "<");
        this.nextTierButton = new ClearGuiButton(0, 15, 123, 20, 12, ">");
        TooltipButton projectMultiblocksButton = new TooltipButton(0, 145, 135, 20, 12, "P", StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.project"));
        TooltipButton overlayMultiblocksButton = new TooltipButton(0, 120, 135, 20, 12, "?", StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.overlay"));
        this.buttons.put(this.previousTierButton, this::togglePreviousTier);
        this.buttons.put(this.nextTierButton, this::toggleNextTier);
        this.buttons.put((GuiButton)projectMultiblocksButton, this::projectMultiblocks);
        this.buttons.put((GuiButton)overlayMultiblocksButton, this::neiOverlay);
    }

    protected abstract void placeMultiblock();

    protected void setLocalizationAndColor() {
        guiTextLayer = GuiText.Layer.getLocal();
        guiColorBg = GuiText.BgColor.getColor();
        guiColorFont = GuiText.FontColor.getColor();
        buttonColorEnabled = GuiText.ButtonEnabledColor.getColor();
        buttonColorDisabled = GuiText.ButtonDisabledColor.getColor();
        buttonColorHovered = GuiText.ButtonHoveredColor.getColor();
        this.previousLayerButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        this.nextLayerButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        guiLayerButtonTitle = this.getLayerButtonTitle();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        initialLayerButtonTitleWidth = fontRenderer.func_78256_a(guiLayerButtonTitle);
        this.nextLayerButton.field_146128_h = 15 + initialLayerButtonTitleWidth - fontRenderer.func_78256_a("<") / 2;
        guiTextTier = GuiText.Tier.getLocal();
        this.previousTierButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        this.nextTierButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        guiTierButtonTitle = this.getTierButtonTitle();
        initialTierButtonTitleWidth = fontRenderer.func_78256_a(guiTierButtonTitle);
        this.nextTierButton.field_146128_h = 15 + initialTierButtonTitleWidth - fontRenderer.func_78256_a("<") / 2;
    }

    public void loadMultiblock(T multiblock, ItemStack stackForm) {
        this.setLocalizationAndColor();
        this.renderingController = multiblock;
        this.stackForm = stackForm;
        if (stackForm.field_77994_a == 0) {
            stackForm.field_77994_a = 1;
        }
        if (this.lastRenderingController != this.renderingController) {
            this.loadNewMultiblock();
        } else {
            this.loadPreviousMultiblockAgain();
        }
        guiTierButtonTitle = this.getTierButtonTitle();
    }

    protected void loadNewMultiblock() {
        layerIndex = -1;
        tierIndex = 1;
        this.initializeSceneRenderer(true);
        this.lastRenderingController = this.renderingController;
    }

    protected void loadPreviousMultiblockAgain() {
        this.initializeSceneRenderer(false);
    }

    public void setOnIngredientChanged(Consumer<List<ItemStack>> callback) {
        this.onIngredientChanged = callback;
    }

    private void toggleNextLayer() {
        int height = (int)((TrackedDummyWorld)GUI_MultiblockHandler.renderer.world).getSize().getY() - 1;
        if (++layerIndex > height) {
            layerIndex = -1;
        }
        this.setNextLayer(layerIndex);
    }

    private void togglePreviousLayer() {
        int height = (int)((TrackedDummyWorld)GUI_MultiblockHandler.renderer.world).getSize().getY() - 1;
        if (layerIndex == -1) {
            layerIndex = height;
        } else if (--layerIndex < 0) {
            layerIndex = -1;
        }
        this.setNextLayer(layerIndex);
    }

    private void setNextLayer(int newLayer) {
        layerIndex = newLayer;
        if (renderer != null) {
            Set<BlockPosition> renderBlocks;
            TrackedDummyWorld world = (TrackedDummyWorld)GUI_MultiblockHandler.renderer.world;
            this.resetCenter();
            GUI_MultiblockHandler.renderer.renderedBlocks.clear();
            int minY = (int)world.getMinPos().getY();
            if (newLayer == -1) {
                renderBlocks = world.placedBlocks;
                renderer.setRenderAllFaces(false);
            } else {
                renderBlocks = world.placedBlocks.stream().filter(pos -> pos.y - minY == newLayer).collect(Collectors.toSet());
                renderer.setRenderAllFaces(true);
            }
            renderer.addRenderedBlocks(renderBlocks);
            this.scanIngredients();
            guiLayerButtonTitle = this.getLayerButtonTitle();
        }
    }

    private void resetCenter() {
        TrackedDummyWorld world = (TrackedDummyWorld)GUI_MultiblockHandler.renderer.world;
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
    }

    public void drawMultiblock() {
        guiMouseX = GuiDraw.getMousePosition().x;
        guiMouseY = GuiDraw.getMousePosition().y;
        int k = (NEIClientUtils.getGuiContainer().field_146294_l - 176) / 2;
        int l = (NEIClientUtils.getGuiContainer().field_146295_m - Math.min(Math.max(NEIClientUtils.getGuiContainer().field_146295_m - 68, 166), 370)) / 2;
        renderer.render(8 + k, 50 + l, 160, 150, lastGuiMouseX, lastGuiMouseY);
        this.drawMultiblockName();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tooltipBlockStack = null;
        MovingObjectPosition rayTraceResult = renderer.getLastTraceResult();
        boolean insideView = guiMouseX >= k + 8 && guiMouseY >= l + 50 && guiMouseX < k + 8 + 160 && guiMouseY < l + 50 + 150;
        boolean leftClickHeld = Mouse.isButtonDown((int)0);
        boolean rightClickHeld = Mouse.isButtonDown((int)1);
        boolean middleClickHeld = Mouse.isButtonDown((int)2);
        if (insideView) {
            int mouseDeltaY;
            if (leftClickHeld) {
                rotationPitch += (float)(guiMouseX - lastGuiMouseX + 360);
                rotationPitch %= 360.0f;
                rotationYaw = (float)MathHelper.clip((double)(rotationYaw + (float)(guiMouseY - lastGuiMouseY)), (double)-89.9, (double)89.9);
            } else if (rightClickHeld && Math.abs(mouseDeltaY = guiMouseY - lastGuiMouseY) > 1) {
                zoom = (float)MathHelper.clip((double)((double)zoom + (mouseDeltaY > 0 ? 0.15 : -0.15)), (double)3.0, (double)999.0);
            }
            if (middleClickHeld) {
                int mouseDeltaX = guiMouseX - lastGuiMouseX;
                int mouseDeltaY2 = guiMouseY - lastGuiMouseY;
                Vector3f lookAt = renderer.getLookAt();
                Vector3f eyePos = renderer.getEyePos();
                Vector3f worldUp = renderer.getWorldUp();
                Vector3f lookDir = Vector3f.sub((Vector3f)lookAt, (Vector3f)eyePos, null);
                Vector3f rightDir = Vector3f.cross((Vector3f)lookDir, (Vector3f)worldUp, null);
                rightDir.normalise();
                Vector3f upDir = Vector3f.cross((Vector3f)rightDir, (Vector3f)lookDir, null);
                upDir.normalise();
                Vector3f offset = new Vector3f((float)(-mouseDeltaX) * rightDir.x + (float)mouseDeltaY2 * upDir.x, (float)(-mouseDeltaX) * rightDir.y + (float)mouseDeltaY2 * upDir.y, (float)(-mouseDeltaX) * rightDir.z + (float)mouseDeltaY2 * upDir.z);
                offset.scale(0.15f);
                Vector3f.add((Vector3f)center, (Vector3f)offset, (Vector3f)center);
            }
            if (this.scrolled != 0) {
                zoom = (float)MathHelper.clip((double)(zoom - (float)(this.scrolled * 5)), (double)3.0, (double)999.0);
                this.scrolled = 0;
            }
            renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        int actualMouseX = guiMouseX - k - 5;
        int actualMouseY = guiMouseY - l - 43;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (GuiButton button : this.buttons.keySet()) {
            button.func_146112_a(Minecraft.func_71410_x(), actualMouseX, actualMouseY);
        }
        this.drawButtonsTitle(fontRenderer);
        for (GuiButton button : this.buttons.keySet()) {
            TooltipButton tooltipButton;
            if (!(button instanceof TooltipButton) || !(tooltipButton = (TooltipButton)button).isMouseOver(actualMouseX, actualMouseY)) continue;
            int textWidth = fontRenderer.func_78256_a(tooltipButton.hoverString);
            tooltipButton.drawTooltipBox(fontRenderer, actualMouseX - 10, actualMouseY - 17, textWidth + 3, tooltipButton.field_146121_g);
        }
        if (!(leftClickHeld || rightClickHeld || rayTraceResult == null || GUI_MultiblockHandler.renderer.world.func_147437_c(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d))) {
            Block block = GUI_MultiblockHandler.renderer.world.func_147439_a(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d);
            tooltipBlockStack = block.getPickBlock(rayTraceResult, GUI_MultiblockHandler.renderer.world, rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        lastGuiMouseX = guiMouseX;
        lastGuiMouseY = guiMouseY;
    }

    protected String getMultiblockName() {
        return I18n.func_135052_a((String)this.stackForm.func_82833_r(), (Object[])new Object[0]);
    }

    private void drawMultiblockName() {
        String localizedName = this.getMultiblockName();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List lines = fontRenderer.func_78271_c(localizedName, 150);
        for (int i = 0; i < lines.size(); ++i) {
            fontRenderer.func_78276_b((String)lines.get(i), (160 - fontRenderer.func_78256_a((String)lines.get(i))) / 2, fontRenderer.field_78288_b * i, guiColorFont);
        }
    }

    protected String getLayerButtonTitle() {
        return guiTextLayer + ": " + (layerIndex == -1 ? "A" : Integer.toString(layerIndex + 1));
    }

    protected void drawButtonsTitle(FontRenderer fontRenderer) {
        fontRenderer.func_78276_b(guiLayerButtonTitle, 15 + (initialLayerButtonTitleWidth - fontRenderer.func_78256_a(guiLayerButtonTitle)) / 2, 137, guiColorFont);
        fontRenderer.func_78276_b(guiTierButtonTitle, 15 + (initialTierButtonTitleWidth - fontRenderer.func_78256_a(guiTierButtonTitle)) / 2, 125, guiColorFont);
    }

    protected void initializeSceneRenderer(boolean resetCamera) {
        Vector3f eyePos = new Vector3f();
        Vector3f lookAt = new Vector3f();
        Vector3f worldUp = new Vector3f();
        if (!resetCamera) {
            try {
                eyePos = renderer.getEyePos();
                lookAt = renderer.getLookAt();
                worldUp = renderer.getWorldUp();
            }
            catch (NullPointerException e) {
                BlockRenderer6343.error("please reset camera on your first renderer call!");
            }
        }
        renderer = new ImmediateWorldSceneRenderer(new TrackedDummyWorld());
        ((DummyWorld)GUI_MultiblockHandler.renderer.world).updateEntitiesForNEI();
        renderer.setClearColor(guiColorBg);
        fakeMultiblockBuilder = this.createFakeBuilder(GUI_MultiblockHandler.renderer.world, "BlockRenderer6343");
        GUI_MultiblockHandler.renderer.world.func_72828_b(Arrays.asList(fakeMultiblockBuilder));
        this.placeMultiblock();
        Vector3f size = ((TrackedDummyWorld)GUI_MultiblockHandler.renderer.world).getSize();
        Vector3f minPos = ((TrackedDummyWorld)GUI_MultiblockHandler.renderer.world).getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        GUI_MultiblockHandler.renderer.renderedBlocks.clear();
        renderer.addRenderedBlocks(((TrackedDummyWorld)GUI_MultiblockHandler.renderer.world).placedBlocks);
        renderer.setOnLookingAt(ray -> {});
        renderer.setOnWorldRender(this::onRendererRender);
        selectedBlock = null;
        this.onBlockSelected();
        this.setNextLayer(layerIndex);
        if (resetCamera) {
            float max = Math.max(Math.max(Math.max(size.x, size.y), size.z), 1.0f);
            if (size.x >= 30.0f || size.y >= 30.0f || size.z >= 30.0f) {
                zoom = (float)(14.0 * Math.sqrt(max));
            }
            zoom = size.x >= 15.0f && size.y >= 15.0f && size.z >= 11.0f ? (float)(7.0 * Math.sqrt(max)) : (float)(3.5 * Math.sqrt(max));
            rotationYaw = 20.0f;
            rotationPitch = 50.0f;
            if (renderer != null) {
                this.resetCenter();
            }
        } else {
            renderer.setCameraLookAt(eyePos, lookAt, worldUp);
        }
    }

    public void handleMouseScrollUp(int scrolled) {
        this.scrolled = scrolled;
    }

    protected void toggleNextTier() {
        ++tierIndex;
        guiTierButtonTitle = this.getTierButtonTitle();
        this.initializeSceneRenderer(false);
    }

    protected void togglePreviousTier() {
        if (tierIndex > 1) {
            --tierIndex;
            guiTierButtonTitle = this.getTierButtonTitle();
            this.initializeSceneRenderer(false);
        }
    }

    protected String getTierButtonTitle() {
        return guiTextTier + ": " + tierIndex;
    }

    public void onRendererRender(WorldSceneRenderer renderer) {
        BlockPosition look;
        BlockPosition blockPosition = look = renderer.getLastTraceResult() == null ? null : new BlockPosition(renderer.getLastTraceResult().field_72311_b, renderer.getLastTraceResult().field_72312_c, renderer.getLastTraceResult().field_72309_d);
        if (look != null && look.equals(selectedBlock)) {
            this.renderBlockOverLay(selectedBlock, Blocks.field_150359_w.func_149691_a(0, 6));
            return;
        }
        this.renderBlockOverLay(look, Blocks.field_150399_cn.func_149691_a(0, 7));
        this.renderBlockOverLay(selectedBlock, Blocks.field_150399_cn.func_149691_a(0, 14));
    }

    protected void projectMultiblocks() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient baseWorld = Minecraft.func_71410_x().field_71441_e;
        MovingObjectPosition lookingPos = player.func_70614_a(10.0, 1.0f);
        if (lookingPos.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return;
        }
        int playerDir = MathHelper.floor_double((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ItemStack itemStack = this.stackForm.func_77946_l();
        if (!baseWorld.func_147437_c(lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_space")));
            return;
        }
        itemStack.func_77973_b().func_77648_a(itemStack, (EntityPlayer)player, (World)baseWorld, lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d, 0, (float)lookingPos.field_72311_b, (float)lookingPos.field_72312_c, (float)lookingPos.field_72309_d);
        ConstructableUtility.handle((ItemStack)GUI_MultiblockHandler.getTriggerStack(), (EntityPlayer)player, (World)baseWorld, (int)lookingPos.field_72311_b, (int)(lookingPos.field_72312_c + 1), (int)lookingPos.field_72309_d, (int)playerDir);
        baseWorld.func_147468_f(lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d);
        baseWorld.func_147475_p(lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d);
    }

    protected void neiOverlay() {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        GuiRecipe currentScreen = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)currentScreen.firstGui);
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = this.ingredients.get(i);
            if (itemStack == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStack.func_77955_b(itemStackNBT);
            itemStackNBT.func_74768_a("Count", itemStack.field_77994_a);
            recipeInputs.func_74782_a("#" + i, (NBTBase)itemStackNBT);
        }
        NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketNEIPatternRecipe(recipeInputs, new NBTTagCompound()));
    }

    private void scanIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (BlockPosition renderedBlock : GUI_MultiblockHandler.renderer.renderedBlocks) {
            Block block = GUI_MultiblockHandler.renderer.world.func_147439_a(renderedBlock.x, renderedBlock.y, renderedBlock.z);
            if (block.equals(Blocks.field_150350_a)) continue;
            int meta = GUI_MultiblockHandler.renderer.world.func_72805_g(renderedBlock.x, renderedBlock.y, renderedBlock.z);
            int qty = block.func_149745_a(GUI_MultiblockHandler.renderer.world.field_73012_v);
            ArrayList itemstacks = new ArrayList();
            if (qty != 1) {
                itemstacks.add(new ItemStack(block));
            } else {
                itemstacks = block.getDrops(GUI_MultiblockHandler.renderer.world, renderedBlock.x, renderedBlock.y, renderedBlock.z, meta, 0);
            }
            boolean added = false;
            for (ItemStack ingredient : ingredients) {
                if (!NEIClientUtils.areStacksSameTypeWithNBT((ItemStack)ingredient, (ItemStack)((ItemStack)itemstacks.get(0)))) continue;
                ++ingredient.field_77994_a;
                added = true;
                break;
            }
            if (added) continue;
            ingredients.add((ItemStack)itemstacks.get(0));
        }
        this.ingredients = ingredients;
        if (this.onIngredientChanged != null) {
            this.onIngredientChanged.accept(ingredients);
        }
    }

    private void renderBlockOverLay(BlockPosition pos, IIcon icon) {
        if (pos == null) {
            return;
        }
        RenderBlocks bufferBuilder = new RenderBlocks();
        bufferBuilder.field_147845_a = GUI_MultiblockHandler.renderer.world;
        bufferBuilder.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        bufferBuilder.field_147837_f = true;
        Block block = GUI_MultiblockHandler.renderer.world.func_147439_a(pos.x, pos.y, pos.z);
        bufferBuilder.func_147792_a(block, pos.x, pos.y, pos.z, icon);
    }

    public boolean mouseClicked(int button) {
        for (Map.Entry<GuiButton, Runnable> buttons : this.buttons.entrySet()) {
            int k = (NEIClientUtils.getGuiContainer().field_146294_l - 176) / 2;
            int l = (NEIClientUtils.getGuiContainer().field_146295_m - Math.min(Math.max(NEIClientUtils.getGuiContainer().field_146295_m - 68, 166), 370)) / 2;
            if (!buttons.getKey().func_146116_c(Minecraft.func_71410_x(), guiMouseX - k - 5, guiMouseY - l - 43)) continue;
            buttons.getValue().run();
            selectedBlock = null;
            this.onBlockSelected();
            return true;
        }
        if (button == 1 && renderer != null) {
            if (renderer.getLastTraceResult() == null) {
                if (selectedBlock != null) {
                    selectedBlock = null;
                    this.onBlockSelected();
                    return true;
                }
                return false;
            }
            selectedBlock = new BlockPosition(GUI_MultiblockHandler.renderer.getLastTraceResult().field_72311_b, GUI_MultiblockHandler.renderer.getLastTraceResult().field_72312_c, GUI_MultiblockHandler.renderer.getLastTraceResult().field_72309_d);
            this.onBlockSelected();
        }
        return false;
    }

    @NotNull
    protected static ItemStack getTriggerStack() {
        return new ItemStack(StructureLibAPI.getDefaultHologramItem(), tierIndex);
    }

    protected EntityPlayer createFakeBuilder(World world, String name) {
        return new ClientFakePlayer(world, new GameProfile(UUID.nameUUIDFromBytes(name.getBytes()), name));
    }

    protected void scanCandidates() {
        this.candidates.clear();
        if (selectedBlock != null) {
            for (PositionedIStructureElement structureElement : structureElements) {
                if (structureElement.x != GUI_MultiblockHandler.selectedBlock.x || structureElement.y != GUI_MultiblockHandler.selectedBlock.y || structureElement.z != GUI_MultiblockHandler.selectedBlock.z) continue;
                IStructureElement.BlocksToPlace blocksToPlace = structureElement.element.getBlocksToPlace((Object)((IConstructable)this.renderingController), GUI_MultiblockHandler.renderer.world, GUI_MultiblockHandler.selectedBlock.x, GUI_MultiblockHandler.selectedBlock.y, GUI_MultiblockHandler.selectedBlock.z, GUI_MultiblockHandler.getTriggerStack(), AutoPlaceEnvironment.fromLegacy((IItemSource)CreativeItemSource.instance, (EntityPlayer)fakeMultiblockBuilder, iChatComponent -> {}));
                if (blocksToPlace != null) {
                    Predicate predicate = blocksToPlace.getPredicate();
                    Set<ItemStack> rawCandidates = CreativeItemSource.instance.takeEverythingMatches(predicate, false, 0).keySet();
                    ArrayList stackedCandidates = new ArrayList();
                    for (ItemStack rawCandidate : rawCandidates) {
                        boolean added = false;
                        for (List list : stackedCandidates) {
                            List firstCandidateTooltip = ((ItemStack)list.get(0)).func_82840_a(fakeMultiblockBuilder, false);
                            List rawCandidateTooltip = rawCandidate.func_82840_a(fakeMultiblockBuilder, false);
                            if (firstCandidateTooltip.size() <= 1 || rawCandidateTooltip.size() <= 1 || !((String)firstCandidateTooltip.get(1)).equals(rawCandidateTooltip.get(1))) continue;
                            list.add(rawCandidate);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        ArrayList<ItemStack> newStackedCandidate = new ArrayList<ItemStack>();
                        newStackedCandidate.add(rawCandidate);
                        stackedCandidates.add(newStackedCandidate);
                    }
                    this.candidates.addAll(stackedCandidates);
                    if (this.onCandidateChanged != null) {
                        this.onCandidateChanged.accept(this.candidates);
                    }
                }
                return;
            }
        }
        if (this.onCandidateChanged != null) {
            this.onCandidateChanged.accept(this.candidates);
        }
    }

    protected void onBlockSelected() {
        this.scanCandidates();
    }

    public void setOnCandidateChanged(Consumer<List<List<ItemStack>>> callback) {
        this.onCandidateChanged = callback;
    }

    public List<String> handleTooltip() {
        if (tooltipBlockStack != null) {
            return tooltipBlockStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        return null;
    }

    static {
        MB_PLACE_POS = new BlockPosition(0, 64, 0);
        layerIndex = -1;
        structureElements = new ArrayList<PositionedIStructureElement>();
        tierIndex = 1;
    }

    protected static class ClearGuiButton
    extends GuiButton {
        private int colorEnabled;
        private int colorDisabled;
        private int colorHovered;

        public ClearGuiButton(int id, int x, int y, int width, int height, String displayString) {
            super(id, x, y, width, height, displayString);
        }

        public void setColors(int clrEnabled, int clrDisabled, int clrHovered) {
            this.colorEnabled = clrEnabled;
            this.colorDisabled = clrDisabled;
            this.colorHovered = clrHovered;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int l = this.colorEnabled;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = this.colorDisabled;
                } else if (this.field_146123_n) {
                    l = this.colorHovered;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

