/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.version;

import com.google.common.io.CharStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.version.Version;

public class VersionCheck {
    private static volatile ExecutorService executorService;
    private static volatile Boolean updateCheckEnabled;
    private static volatile Boolean versionIsCurrent;
    private static volatile Boolean versionIsChecked;
    private static volatile String versionAvailable;
    private static volatile String downloadUrl;

    public static Boolean getVersionIsCurrent() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsCurrent;
    }

    public static Boolean getVersionIsChecked() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsChecked;
    }

    public static String getVersionAvailable() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionAvailable;
    }

    public static String getDownloadUrl() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return downloadUrl;
    }

    private static synchronized void checkVersion() {
        versionIsChecked = false;
        versionIsCurrent = true;
        versionAvailable = "0";
        if (!updateCheckEnabled.booleanValue()) {
            Journeymap.getLogger().info("Update check disabled in properties file.");
        } else {
            executorService = Executors.newSingleThreadExecutor(new JMThreadFactory("VersionCheck"));
            executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStreamReader in = null;
                    HttpURLConnection connection = null;
                    String rawResponse = null;
                    try {
                        URL uri2 = URI.create("https://api.cfwidget.com/minecraft/mc-mods/journeymap").toURL();
                        connection = (HttpURLConnection)uri2.openConnection();
                        connection.setConnectTimeout(6000);
                        connection.setReadTimeout(6000);
                        connection.setRequestMethod("GET");
                        connection.setRequestProperty("User-Agent", "JourneyMap 5.2.3");
                        in = new InputStreamReader(connection.getInputStream());
                        rawResponse = CharStreams.toString((Readable)in);
                        String currentVersion = Journeymap.JM_VERSION.toString();
                        boolean currentIsRelease = Journeymap.JM_VERSION.isRelease();
                        JsonObject project = new JsonParser().parse(rawResponse).getAsJsonObject();
                        JsonElement version = project.get("versions").getAsJsonObject().get("1.7.10");
                        if (version == null) {
                            Journeymap.getLogger().warn("No versions found online for 1.7.10");
                        } else {
                            Iterator files = version.getAsJsonArray().iterator();
                            while (files.hasNext()) {
                                JsonObject file = ((JsonElement)files.next()).getAsJsonObject();
                                try {
                                    String name;
                                    JsonElement type = file.get("type");
                                    if (currentIsRelease && !"release".equals(type.getAsString()) || !(name = file.get("name").getAsString().split("1.7.10")[1]).contains("-")) continue;
                                    String fileVersion = name.split("-")[1];
                                    String url2 = "https://www.curseforge.com/minecraft/mc-mods/journeymap/files/all?page=1&pageSize=20&version=1.7.10" + file.get("id").getAsString();
                                    if (VersionCheck.isCurrent(currentVersion, fileVersion)) continue;
                                    downloadUrl = url2;
                                    versionAvailable = fileVersion;
                                    versionIsCurrent = false;
                                    versionIsChecked = true;
                                    Journeymap.getLogger().info(String.format("Newer version online: JourneyMap %s for Minecraft %s on %s", versionAvailable, "1.7.10", downloadUrl));
                                    break;
                                }
                                catch (Exception e) {
                                    Journeymap.getLogger().error("Could not parse download info: " + file, (Throwable)e);
                                }
                            }
                        }
                        if (!versionIsChecked.booleanValue()) {
                            versionAvailable = currentVersion;
                            versionIsCurrent = true;
                            versionIsChecked = true;
                            downloadUrl = "https://www.curseforge.com/minecraft/mc-mods/journeymap/files/all?page=1&pageSize=20&version=1.7.10";
                        }
                    }
                    catch (Throwable e) {
                        Journeymap.getLogger().error("Could not check version URL", e);
                        updateCheckEnabled = false;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                                executorService.shutdown();
                                executorService = null;
                            }
                            catch (IOException uri2) {}
                        }
                    }
                    if (!versionIsCurrent.booleanValue()) {
                        // empty if block
                    }
                }
            });
        }
    }

    private static boolean isCurrent(String thisVersionStr, String availableVersionStr) {
        if (thisVersionStr.equals(availableVersionStr)) {
            return true;
        }
        Version thisVersion = Version.from(thisVersionStr, null);
        Version availableVersion = Version.from(availableVersionStr, null);
        return !availableVersion.isNewerThan(thisVersion);
    }

    static {
        updateCheckEnabled = Journeymap.proxy.isUpdateCheckEnabled();
        versionIsCurrent = true;
    }
}

