/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.client.lib.UtilsFX;

public class CrucibleRecipeHandler
extends TemplateRecipeHandler {
    protected ArrayList<AspectList> aspectsAmount = new ArrayList();
    String username;

    public CrucibleRecipeHandler() {
        this.username = Minecraft.func_71410_x().field_71439_g.getDisplayName();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(26, -14, 110, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.type.crucible");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getOverlayIdentifier() {
        return "cruciblerecipe";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                CrucibleRecipe tcRecipe;
                CrucibleCachedRecipe recipe;
                if (o == null || !(o instanceof CrucibleRecipe) || (recipe = new CrucibleCachedRecipe(tcRecipe = (CrucibleRecipe)o)) == null || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.key) || !recipe.isValid()) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(recipe.aspects);
            }
        } else if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            CrucibleCachedRecipe recipe;
            CrucibleRecipe tcRecipe;
            if (o == null || !(o instanceof CrucibleRecipe) || !ItemStack.func_77989_b((ItemStack)result, (ItemStack)(tcRecipe = (CrucibleRecipe)o).getRecipeOutput()) || (recipe = new CrucibleCachedRecipe(tcRecipe)) == null || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.key) || !recipe.isValid()) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            CrucibleRecipe tcRecipe;
            CrucibleCachedRecipe recipe;
            if (o == null || !(o instanceof CrucibleRecipe) || (recipe = new CrucibleCachedRecipe(tcRecipe = (CrucibleRecipe)o)) == null || recipe.ingredient == null || recipe.ingredient.item == null || !ItemStack.func_77989_b((ItemStack)recipe.ingredient.item, (ItemStack)ingredient) || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.key) || !recipe.isValid()) continue;
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredient, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public String getGuiTexture() {
        return null;
    }

    public void drawBackground(int recipe) {
        int x = 30;
        int y = 3;
        GL11.glPushMatrix();
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.75f, (float)1.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)3, (int)56, (int)17);
        GL11.glTranslatef((float)0.0f, (float)26.0f, (float)0.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)20, (int)56, (int)48);
        GL11.glTranslatef((float)21.0f, (float)-8.0f, (float)0.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)100, (int)84, (int)11, (int)13);
        GL11.glPopMatrix();
        this.drawAspects(recipe, x - 7, y - 24);
    }

    public void drawForeground(int recipe) {
        this.drawExtras(recipe);
    }

    public void drawAspects(int recipe, int x, int y) {
        AspectList aspects = this.aspectsAmount.get(recipe);
        int total = 0;
        int rows = (aspects.aspects.size() - 1) / 3;
        int shift = (3 - aspects.aspects.size() % 3) * 10;
        int sx = x + 28;
        int sy = y + 68 + 32 - 10 * rows;
        for (Aspect tag : aspects.getAspectsSortedAmount()) {
            int m = 0;
            if (total / 3 >= rows && (rows > 1 || aspects.aspects.size() < 3)) {
                m = 1;
            }
            int vx = sx + total % 3 * 20 + shift * m;
            int vy = sy + total / 3 * 20;
            UtilsFX.drawTag((int)vx, (int)vy, (Aspect)tag, (float)aspects.getAmount(tag), (int)0, (double)GuiDraw.gui.getZLevel());
            ++total;
        }
    }

    protected class CrucibleCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack ingredient;
        public PositionedStack result;
        private AspectList aspects;

        public CrucibleCachedRecipe(CrucibleRecipe recipe) {
            super((TemplateRecipeHandler)CrucibleRecipeHandler.this);
            this.setIngredient(recipe.catalyst);
            this.setResult(recipe.getRecipeOutput());
            this.setAspectList(recipe.aspects);
        }

        protected void setIngredient(Object in) {
            if (in != null && NEIServerUtils.extractRecipeItems((Object)in).length > 0) {
                PositionedStack stack = new PositionedStack(in, 51, 30, false);
                stack.setMaxSize(1);
                this.ingredient = stack;
            }
        }

        public void setIngredientPermutation(PositionedStack stack, ItemStack ingredient) {
            for (int i = 0; i < stack.items.length; ++i) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)stack.items[i])) continue;
                stack.item = stack.items[i];
                stack.item.func_77964_b(ingredient.func_77960_j());
                stack.items = new ItemStack[]{stack.item};
                stack.setPermutationToRender(0);
                break;
            }
        }

        protected void setResult(ItemStack out) {
            if (out != null) {
                this.result = new PositionedStack((Object)out, 71, 8, false);
            }
        }

        protected void setAspectList(AspectList aspects) {
            this.aspects = aspects;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.add(this.getIngredient());
            NEIHelper.addAspectsToIngredients(this.aspects, list, 2);
            return list;
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public void computeVisuals() {
            this.ingredient.generatePermutations();
        }

        public boolean isValid() {
            return this.ingredient != null && this.ingredient.items != null && this.ingredient.items.length > 0;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }
    }
}

