/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFCinderFurnace;

public class BlockTFCinderFurnace
extends BlockContainer {
    private static boolean isUpdating;
    private Boolean isLit;
    private IIcon topIcon;
    private Random furnaceRandom = new Random();

    protected BlockTFCinderFurnace(Boolean isLit) {
        super(Material.field_151575_d);
        this.isLit = isLit;
        this.func_149711_c(7.0f);
        this.func_149715_a(isLit != false ? 1.0f : 0.0f);
        if (!isLit.booleanValue()) {
            this.func_149647_a(TFItems.creativeTab);
        }
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityTFCinderFurnace();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : (side == 0 ? this.topIcon : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(this.isLit != false ? "furnace_front_on" : "furnace_front_off");
        this.topIcon = p_149651_1_.func_94245_a("furnace_top");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityTFCinderFurnace tileentityfurnace = (TileEntityTFCinderFurnace)world.func_147438_o(x, y, z);
        if (tileentityfurnace != null) {
            player.openGui((Object)TwilightForestMod.instance, 2, world, x, y, z);
            return true;
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase p_149689_5_, ItemStack itemStack) {
        if (itemStack.func_82837_s()) {
            ((TileEntityFurnace)world.func_147438_o(x, y, z)).func_145951_a(itemStack.func_82833_r());
        }
    }

    public static void updateFurnaceBlockState(boolean isBurning, World world, int x, int y, int z) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        isUpdating = true;
        if (isBurning) {
            world.func_147449_b(x, y, z, TFBlocks.cinderFurnaceLit);
        } else {
            world.func_147449_b(x, y, z, TFBlocks.cinderFurnace);
        }
        isUpdating = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.isLit.booleanValue()) {
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            int l = random.nextInt(4) + 2;
            if (l == 4) {
                world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 5) {
                world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        TileEntityTFCinderFurnace tileEntity;
        if (!isUpdating && (tileEntity = (TileEntityTFCinderFurnace)world.func_147438_o(x, y, z)) != null) {
            for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileEntity.func_70301_a(i);
                if (itemstack == null) continue;
                float dx = this.furnaceRandom.nextFloat() * 0.8f + 0.1f;
                float dy = this.furnaceRandom.nextFloat() * 0.8f + 0.1f;
                float dz = this.furnaceRandom.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.furnaceRandom.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + dx), (double)((float)y + dy), (double)((float)z + dz), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float pointFive = 0.05f;
                    entityitem.field_70159_w = (float)this.furnaceRandom.nextGaussian() * pointFive;
                    entityitem.field_70181_x = (float)this.furnaceRandom.nextGaussian() * pointFive + 0.2f;
                    entityitem.field_70179_y = (float)this.furnaceRandom.nextGaussian() * pointFive;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)TFBlocks.cinderFurnace);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)TFBlocks.cinderFurnace);
    }
}

