/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.block.material.MapColor;
import twilightforest.item.TFItems;

public class BlockTFCompressed
extends BlockCompressed {
    private BlockType type;

    protected BlockTFCompressed(BlockType blockType) {
        super(BlockTFCompressed.typeToMapColor(blockType));
        this.type = blockType;
        float hardness = 0.0f;
        float resistance = 0.0f;
        Block.SoundType stepSound = null;
        String textureName = "";
        switch (this.type) {
            case ARCTIC_FUR: {
                hardness = 0.8f;
                stepSound = field_149775_l;
                textureName = "arctic_fur_block";
                break;
            }
            case CARMINITE: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149777_j;
                textureName = "carminite_block";
                break;
            }
            case FIERY_METAL: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149777_j;
                textureName = "fiery_block";
                break;
            }
            default: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149777_j;
                textureName = "ironwood_block";
                break;
            }
            case STEELEAF: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149779_h;
                textureName = "steeleaf_block";
            }
        }
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(stepSound);
        this.func_149658_d("TwilightForest:" + textureName);
        this.func_149647_a(TFItems.creativeTab);
    }

    private static MapColor typeToMapColor(BlockType blockType) {
        MapColor mapColor = null;
        switch (blockType) {
            case ARCTIC_FUR: {
                mapColor = MapColor.field_151659_e;
                break;
            }
            case CARMINITE: {
                mapColor = MapColor.field_151656_f;
                break;
            }
            case FIERY_METAL: {
                mapColor = MapColor.field_151655_K;
                break;
            }
            case IRONWOOD: {
                mapColor = MapColor.field_151668_h;
                break;
            }
            case STEELEAF: {
                mapColor = MapColor.field_151669_i;
            }
        }
        return mapColor;
    }

    public static enum BlockType {
        ARCTIC_FUR,
        CARMINITE,
        FIERY_METAL,
        IRONWOOD,
        STEELEAF;

    }
}

