/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.skeleton;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.MobHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.skeleton.Entity_SpecialSkeleton;

public class EntityThiefSkeleton
extends Entity_SpecialSkeleton {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "skeleton/thief.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "skeleton/thief_wither.png")};

    public EntityThiefSkeleton(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
    }

    @Override
    protected void initTypeAI() {
        this.setRangedAI(1.1, 20, 30, 9.0f);
        this.setMeleeAI(1.2);
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.3);
        this.func_70062_b(0, null);
        this.func_98053_h(true);
    }

    @Override
    protected void onTypeAttack(Entity target) {
        ItemStack stolen;
        if (target instanceof EntityPlayer && (stolen = MobHelper.removeHeldItem((EntityPlayer)target)) != null) {
            this.func_70099_a(stolen, 0.0f);
        }
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151074_bl, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        String name;
        ItemStack itemStack;
        if (this.field_70146_Z.nextBoolean()) {
            Item[] armor = new Item[]{Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T};
            String[] armorNames = new String[]{"Cap", "Tunic", "Pants", "Boots"};
            int choice = this.field_70146_Z.nextInt(armor.length);
            itemStack = new ItemStack(armor[choice]);
            name = armorNames[choice];
            EffectHelper.addItemText(itemStack, "\u00a77\u00a7oGuaranteed 22% sneakier than");
            EffectHelper.addItemText(itemStack, "\u00a77\u00a7othe next leading brand!");
            EffectHelper.dye(itemStack, 660511);
            EffectHelper.enchantItem(this.field_70146_Z, itemStack, 30);
        } else {
            Item[] tools = new Item[]{Items.field_151010_B, Items.field_151031_f, Items.field_151112_aM, Items.field_151005_D, Items.field_151006_E, Items.field_151011_C};
            String[] toolNames = new String[]{"Knife", "Bow", "Fishing Rod", "Pickaxe", "Axe", "Shovel"};
            int choice = this.field_70146_Z.nextInt(tools.length);
            itemStack = new ItemStack(tools[choice]);
            name = toolNames[choice];
            EffectHelper.addItemText(itemStack, "\u00a77\u00a7o\"Finders keepers\"");
            if (tools[choice] instanceof ItemFishingRod) {
                EffectHelper.enchantItem(itemStack, Enchantment.field_151370_z, 5);
            } else {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77335_o, 5);
                if (!(tools[choice] instanceof ItemBow)) {
                    EffectHelper.enchantItem(itemStack, Enchantment.field_77346_s, 5);
                }
            }
        }
        EffectHelper.setItemName(itemStack, "Thief's " + name, 14);
        EffectHelper.overrideEnchantment(itemStack, Enchantment.field_77347_r, 3);
        this.func_70099_a(itemStack, 0.0f);
    }
}

