/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.thaumcraft;

import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.ArrayUtils;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class TCHelper {
    private static Field tags = null;
    private static Field displayColumnField = null;
    private static Field displayRowField = null;
    private static Field category = null;
    private static Field infusionRecipeResearchField = null;

    public static IRecipe findCraftingRecipe(ItemStack stack) {
        for (Object craft : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(craft instanceof IRecipe) || ((IRecipe)craft).func_77571_b() == null || !GT_Utility.areStacksEqual((ItemStack)((IRecipe)craft).func_77571_b(), (ItemStack)stack, (boolean)true)) continue;
            return (IRecipe)craft;
        }
        return null;
    }

    public static IArcaneRecipe findArcaneRecipe(ItemStack stack) {
        for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craft instanceof IArcaneRecipe) || ((IArcaneRecipe)craft).getRecipeOutput() == null || !GT_Utility.areStacksEqual((ItemStack)((IArcaneRecipe)craft).getRecipeOutput(), (ItemStack)stack, (boolean)true)) continue;
            return (IArcaneRecipe)craft;
        }
        return null;
    }

    public static IArcaneRecipe findArcaneRecipe(ItemStack stack, boolean ignoreNBT) {
        for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craft instanceof IArcaneRecipe) || ((IArcaneRecipe)craft).getRecipeOutput() == null || !GT_Utility.areStacksEqual((ItemStack)((IArcaneRecipe)craft).getRecipeOutput(), (ItemStack)stack, (boolean)ignoreNBT)) continue;
            return (IArcaneRecipe)craft;
        }
        return null;
    }

    public static CrucibleRecipe findCrucibleRecipe(ItemStack stack) {
        for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craft instanceof CrucibleRecipe) || ((CrucibleRecipe)craft).getRecipeOutput() == null || !GT_Utility.areStacksEqual((ItemStack)((CrucibleRecipe)craft).getRecipeOutput(), (ItemStack)stack, (boolean)true)) continue;
            return (CrucibleRecipe)craft;
        }
        return null;
    }

    public static InfusionRecipe findInfusionRecipe(ItemStack stack) {
        for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craft instanceof InfusionRecipe) || !(((InfusionRecipe)craft).getRecipeOutput() instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)((ItemStack)((InfusionRecipe)craft).getRecipeOutput()), (ItemStack)stack, (boolean)true)) continue;
            return (InfusionRecipe)craft;
        }
        return null;
    }

    public static InfusionEnchantmentRecipe findInfusionEnchantRecipe(int effectID) {
        for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craft instanceof InfusionEnchantmentRecipe) || ((InfusionEnchantmentRecipe)craft).getEnchantment() == null || ((InfusionEnchantmentRecipe)craft).getEnchantment().field_77352_x != effectID) continue;
            return (InfusionEnchantmentRecipe)craft;
        }
        return null;
    }

    public static void clearPages(String research) {
        ResearchCategories.getResearch((String)research).setPages(new ResearchPage[0]);
    }

    public static void addResearchPage(String research, ResearchPage page) {
        ResearchItem ri = ResearchCategories.getResearch((String)research);
        ri.setPages((ResearchPage[])ArrayUtils.add((Object[])ri.getPages(), (Object)page));
    }

    public static void clearPrereq(String research) {
        ResearchCategories.getResearch((String)research).setParents(new String[0]).setParentsHidden(new String[0]);
    }

    public static void addResearchPrereq(String research, String prereq, boolean hidden) {
        ResearchItem ri = ResearchCategories.getResearch((String)research);
        if (hidden) {
            ri.setParentsHidden((String[])ArrayUtils.add((Object[])ri.parentsHidden, (Object)prereq));
        } else {
            ri.setParents((String[])ArrayUtils.add((Object[])ri.parents, (Object)prereq));
        }
    }

    public static void clearSiblings(String research) {
        ResearchCategories.getResearch((String)research).setSiblings(new String[0]);
    }

    public static void addResearchSibling(String research, String sibling) {
        ResearchItem ri = ResearchCategories.getResearch((String)research);
        ri.setSiblings((String[])ArrayUtils.add((Object[])ri.siblings, (Object)sibling));
    }

    public static void setResearchAspects(String research, AspectList aspects) {
        try {
            if (tags == null) {
                tags = ResearchItem.class.getField("tags");
                tags.setAccessible(true);
            }
            tags.set(ResearchCategories.getResearch((String)research), aspects);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setResearchComplexity(String research, int complexity) {
        ResearchCategories.getResearch((String)research).setComplexity(complexity);
    }

    public static void refreshResearchPages(String research) {
        ResearchItem target = ResearchCategories.getResearch((String)research);
        ResearchPage[] pages = target.getPages();
        block0: for (int x = 0; x < pages.length; ++x) {
            IRecipe theCraft;
            IRecipe recipe;
            if (pages[x].recipe == null) continue;
            if (pages[x].recipe instanceof IRecipe) {
                recipe = (IRecipe)pages[x].recipe;
                for (Object craft : CraftingManager.func_77594_a().func_77592_b()) {
                    if (!(craft instanceof IRecipe) || (theCraft = (IRecipe)craft).func_77571_b() == null || !GT_Utility.areStacksEqual((ItemStack)theCraft.func_77571_b(), (ItemStack)recipe.func_77571_b())) continue;
                    pages[x] = new ResearchPage(theCraft);
                    continue block0;
                }
                continue;
            }
            if (pages[x].recipe instanceof IArcaneRecipe) {
                recipe = (IArcaneRecipe)pages[x].recipe;
                for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                    if (!(craft instanceof IArcaneRecipe) || (theCraft = (IArcaneRecipe)craft).getRecipeOutput() == null || !GT_Utility.areStacksEqual((ItemStack)theCraft.getRecipeOutput(), (ItemStack)recipe.getRecipeOutput())) continue;
                    pages[x] = new ResearchPage((IArcaneRecipe)theCraft);
                    continue block0;
                }
                continue;
            }
            if (pages[x].recipe instanceof CrucibleRecipe) {
                recipe = (CrucibleRecipe)pages[x].recipe;
                for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                    if (!(craft instanceof CrucibleRecipe) || (theCraft = (CrucibleRecipe)craft).getRecipeOutput() == null || !GT_Utility.areStacksEqual((ItemStack)theCraft.getRecipeOutput(), (ItemStack)recipe.getRecipeOutput())) continue;
                    pages[x] = new ResearchPage((CrucibleRecipe)theCraft);
                    continue block0;
                }
                continue;
            }
            if (!(pages[x].recipe instanceof InfusionRecipe) || !((recipe = (InfusionRecipe)pages[x].recipe).getRecipeOutput() instanceof ItemStack)) continue;
            for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                if (!(craft instanceof InfusionRecipe) || !((theCraft = (InfusionRecipe)craft).getRecipeOutput() instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)((ItemStack)theCraft.getRecipeOutput()), (ItemStack)((ItemStack)recipe.getRecipeOutput()))) continue;
                pages[x] = new ResearchPage((InfusionRecipe)theCraft);
                continue block0;
            }
        }
    }

    public static void moveResearch(String research, String destination, int x, int y) {
        ResearchItem ri = ResearchCategories.getResearch((String)research);
        try {
            if (displayColumnField == null) {
                Class<ResearchItem> RIClass = ResearchItem.class;
                displayColumnField = RIClass.getField("displayColumn");
                displayRowField = RIClass.getField("displayRow");
                category = RIClass.getField("category");
                displayColumnField.setAccessible(true);
                displayRowField.setAccessible(true);
                category.setAccessible(true);
            }
            TCHelper.removeResearch(research);
            displayColumnField.set(ri, x);
            displayRowField.set(ri, y);
            category.set(ri, destination);
            ri.registerResearchItem();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void orphanResearch(String research) {
        BiConsumer<String[], Consumer> removeHelper = (list, setter) -> {
            if (list == null) {
                return;
            }
            for (int i = 0; i < ((String[])list).length; ++i) {
                if (list[i] == null || !list[i].equals(research)) continue;
                list = (String[])ArrayUtils.remove((Object[])list, (int)i);
                setter.accept(list);
                --i;
            }
        };
        for (ResearchCategoryList categoryList : ResearchCategories.researchCategories.values()) {
            for (Map.Entry entry : categoryList.research.entrySet()) {
                ResearchItem researchItem = (ResearchItem)entry.getValue();
                removeHelper.accept(researchItem.parents, arg_0 -> ((ResearchItem)researchItem).setParents(arg_0));
                removeHelper.accept(researchItem.parentsHidden, arg_0 -> ((ResearchItem)researchItem).setParentsHidden(arg_0));
                removeHelper.accept(researchItem.siblings, arg_0 -> ((ResearchItem)researchItem).setSiblings(arg_0));
            }
        }
    }

    public static void removeResearch(String research) {
        ResearchItem ri = ResearchCategories.getResearch((String)research);
        ResearchCategoryList rcl = ResearchCategories.getResearchList((String)ri.category);
        rcl.research.remove(research);
    }

    public static void removeArcaneRecipe(ItemStack output) {
        ThaumcraftApi.getCraftingRecipes().removeIf(recipe -> {
            if (recipe instanceof IArcaneRecipe) {
                return ((IArcaneRecipe)recipe).getRecipeOutput() != null && GT_Utility.areStacksEqual((ItemStack)((IArcaneRecipe)recipe).getRecipeOutput(), (ItemStack)output);
            }
            return false;
        });
    }

    public static void removeCrucibleRecipe(ItemStack output) {
        ThaumcraftApi.getCraftingRecipes().removeIf(recipe -> {
            if (recipe instanceof CrucibleRecipe) {
                return ((CrucibleRecipe)recipe).getRecipeOutput() != null && GT_Utility.areStacksEqual((ItemStack)((CrucibleRecipe)recipe).getRecipeOutput(), (ItemStack)output);
            }
            return false;
        });
    }

    public static void removeInfusionRecipe(ItemStack output) {
        ThaumcraftApi.getCraftingRecipes().removeIf(recipe -> {
            if (recipe instanceof InfusionRecipe) {
                return ((InfusionRecipe)recipe).getRecipeOutput() instanceof ItemStack && GT_Utility.areStacksEqual((ItemStack)((ItemStack)((InfusionRecipe)recipe).getRecipeOutput()), (ItemStack)output);
            }
            return false;
        });
    }

    public static void removeInfusionEnchantmentRecipe(int effectID) {
        ThaumcraftApi.getCraftingRecipes().removeIf(recipe -> {
            if (recipe instanceof InfusionEnchantmentRecipe) {
                return ((InfusionEnchantmentRecipe)recipe).getEnchantment() != null && ((InfusionEnchantmentRecipe)recipe).getEnchantment().field_77352_x == effectID;
            }
            return false;
        });
    }

    public static void setRecipeResearch(InfusionRecipe recipe, String researchName) {
        try {
            if (infusionRecipeResearchField == null) {
                infusionRecipeResearchField = InfusionRecipe.class.getDeclaredField("research");
                infusionRecipeResearchField.setAccessible(true);
            }
            infusionRecipeResearchField.set(recipe, researchName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

