/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import java.util.Locale;
import magicbees.bees.BeeManager;
import magicbees.bees.HiveDescription;
import magicbees.main.Config;
import magicbees.main.utils.BlockInterface;
import magicbees.main.utils.ItemInterface;
import magicbees.main.utils.compat.IModHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ForestryHelper
implements IModHelper {
    public static final String Name = "Forestry";
    public static Block hiveBlock;
    public static Block alvearyBlock;
    public static Block apicultureBlock;
    public static Item beeComb;
    public static Item honeydew;
    public static Item honeyDrop;
    public static Item propolis;
    public static Item pollen;
    public static Item craftingResource;
    public static ItemStack itemHoneycomb;

    @Override
    public void preInit() {
        IHiveRegistry hiveRegistry = HiveManager.hiveRegistry;
        ForestryHelper.registerHive(hiveRegistry, HiveDescription.CURIOUS);
        ForestryHelper.registerHive(hiveRegistry, HiveDescription.UNUSUAL);
        ForestryHelper.registerHive(hiveRegistry, HiveDescription.RESONANT);
        ForestryHelper.registerHive(hiveRegistry, HiveDescription.DEEP);
        ForestryHelper.registerHive(hiveRegistry, HiveDescription.INFERNAL);
        ForestryHelper.registerHive(hiveRegistry, HiveDescription.OBLIVION);
        if (Config.doSpecialHiveGen) {
            ForestryHelper.registerHive(hiveRegistry, HiveDescription.INFERNAL_OVERWORLD);
            ForestryHelper.registerHive(hiveRegistry, HiveDescription.OBLIVION_OVERWORLD);
        }
    }

    @Override
    public void init() {
        ForestryHelper.getBlocks();
        ForestryHelper.getItems();
    }

    @Override
    public void postInit() {
    }

    private static void registerHive(IHiveRegistry hiveRegistry, HiveDescription hiveDescription) {
        String hiveName = "MagicBees:" + hiveDescription.toString().toLowerCase(Locale.ENGLISH);
        hiveRegistry.registerHive(hiveName, (IHiveDescription)hiveDescription);
    }

    private static void getBlocks() {
        alvearyBlock = BlockInterface.getBlock("alveary");
        hiveBlock = BlockInterface.getBlock("beehives");
        apicultureBlock = BlockInterface.getBlock("apiculture");
    }

    private static void getItems() {
        beeComb = ItemInterface.getItem("beeCombs");
        pollen = ItemInterface.getItem("pollen");
        craftingResource = ItemInterface.getItem("craftingMaterial");
        honeyDrop = ItemInterface.getItem("honeyDrop");
        propolis = ItemInterface.getItem("propolis");
        honeydew = ItemInterface.getItem("honeydew");
        itemHoneycomb = new ItemStack(beeComb, 1, Comb.HONEY.ordinal());
    }

    public static IAllele[] getTemplateForestryForSpecies(String speciesName) {
        return BeeManager.beeRoot.getTemplate("forestry.species" + speciesName);
    }

    public static EnumTemperature getEnumTemperatureFromValue(float rawTemp) {
        return EnumTemperature.getFromValue((float)rawTemp);
    }

    public static EnumHumidity getEnumHumidityFromValue(float rawHumidity) {
        return EnumHumidity.getFromValue((float)rawHumidity);
    }

    public static ItemStack replaceSpecies(ItemStack stack, IAlleleBeeSpecies outputSpecies) {
        ItemStack copyStack = stack.func_77946_l();
        NBTTagCompound compound = copyStack.func_77978_p();
        NBTTagCompound genomeCompound = compound.func_74775_l("Genome");
        NBTTagList chromosomeCompoundList = (NBTTagList)genomeCompound.func_74781_a("Chromosomes");
        NBTTagCompound speciesCompound = chromosomeCompoundList.func_150305_b(0);
        speciesCompound.func_74778_a("UID0", outputSpecies.getUID());
        speciesCompound.func_74778_a("UID1", outputSpecies.getUID());
        return copyStack;
    }

    public static enum ApicultureBlock {
        APIARY;

    }

    public static enum Tube {
        COPPER,
        TIN,
        BRONZE,
        IRON,
        GOLD,
        DIAMOND,
        OBSIDIAN,
        BLAZE,
        RUBBER,
        EMERALD,
        APATITE,
        LAPIS;

    }

    public static enum CircuitBoard {
        BASIC,
        ENHANCED,
        REFINED,
        INTRICATE;

    }

    public static enum Pollen {
        NORMAL,
        CRYSTALLINE;

    }

    public static enum Propolis {
        NORMAL,
        STICKY,
        PULSATING,
        SILKY;

    }

    public static enum Comb {
        HONEY,
        COCOA,
        SIMMERING,
        STRINGY,
        FROZEN,
        DRIPPING,
        SILKY,
        PARCHED,
        MYSTERIOUS,
        IRRADIATED,
        POWDERY,
        REDDENED,
        DARKENED,
        OMEGA,
        WHEATEN,
        MOSSY;

    }

    public static enum CraftingMaterial {
        PULSATING_DUST,
        PULSATING_MESH,
        SILK_WISP,
        WOVEN_SILK,
        DISSIPATION_CHARGE,
        ICE_SHARD,
        SCENTED_PANELING;

    }

    public static enum BlockResource {
        APATITE,
        COPPER,
        TIN;

    }
}

