/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.client.core;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.embeddedt.archaicfix.ArchaicFix;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.helpers.NEISearchHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiContainerCreative.class})
public abstract class MixinGuiContainerCreative
extends InventoryEffectRenderer {
    private static List<ItemStack> initialCreativeItems = null;
    private static final ForkJoinPool creativeSearchPool = new ForkJoinPool();
    private static final Function<ItemStack, String> VANILLA_SUPPLIER = stack -> String.join((CharSequence)"", stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x)).toLowerCase();
    @Shadow
    private static int field_147058_w;
    @Shadow
    private GuiTextField field_147062_A;
    @Shadow
    private float field_147067_x;
    private int debounceTicks = 0;
    private boolean needSearchUpdate = false;
    private boolean firstSearch = true;

    public MixinGuiContainerCreative(Container p_i1089_1_) {
        super(p_i1089_1_);
    }

    @Inject(method={"updateCreativeSearch"}, at={@At(value="HEAD")}, cancellable=true)
    private void asyncSearch(CallbackInfo ci) {
        if (ArchaicConfig.asyncCreativeSearch) {
            ci.cancel();
            this.needSearchUpdate = true;
            if (this.firstSearch) {
                this.debounceTicks = 0;
                this.firstSearch = false;
            } else {
                this.debounceTicks = 5;
            }
        }
    }

    @Inject(method={"updateScreen"}, at={@At(value="TAIL")})
    private void performRealSearch(CallbackInfo ci) {
        if (ArchaicConfig.asyncCreativeSearch && this.needSearchUpdate) {
            String search = this.field_147062_A.func_146179_b().toLowerCase();
            if (search.length() == 0) {
                this.debounceTicks = 0;
            }
            --this.debounceTicks;
            if (this.debounceTicks <= 0) {
                this.needSearchUpdate = false;
                GuiContainerCreative.ContainerCreative containercreative = (GuiContainerCreative.ContainerCreative)this.field_147002_h;
                CreativeTabs tab = CreativeTabs.field_78032_a[field_147058_w];
                if (tab.hasSearchBar() && tab != CreativeTabs.field_78027_g) {
                    tab.func_78018_a(containercreative.field_148330_a);
                } else {
                    Object filteredItems;
                    if (initialCreativeItems == null) {
                        initialCreativeItems = new ArrayList<ItemStack>();
                        for (Object o : Item.field_150901_e) {
                            Item item = (Item)o;
                            if (item == null || item.func_77640_w() == null) continue;
                            try {
                                item.func_150895_a(item, null, initialCreativeItems);
                            }
                            catch (Exception e) {
                                ArchaicLogger.LOGGER.error("Item " + item + " threw an error while populating the creative item list!", (Throwable)e);
                            }
                        }
                        for (Enchantment enchantment : Enchantment.field_77331_b) {
                            if (enchantment == null || enchantment.field_77351_y == null) continue;
                            Items.field_151134_bR.func_92113_a(enchantment, initialCreativeItems);
                        }
                    }
                    if (search.length() > 0) {
                        try {
                            NEISearchHelper nameSupplier = ArchaicFix.NEI_INSTALLED ? new NEISearchHelper() : VANILLA_SUPPLIER;
                            filteredItems = (List)((ForkJoinTask)creativeSearchPool.submit(() -> initialCreativeItems.parallelStream().filter(stack -> {
                                String s = (String)nameSupplier.apply(stack);
                                if (s != null) {
                                    return s.contains(search);
                                }
                                return false;
                            }).collect(Collectors.toList()))).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                            filteredItems = ImmutableList.of();
                        }
                    } else {
                        filteredItems = initialCreativeItems;
                    }
                    containercreative.field_148330_a.clear();
                    containercreative.field_148330_a.addAll(filteredItems);
                    containercreative.func_148329_a(0.0f);
                    this.field_147067_x = 0.0f;
                }
            }
        }
    }
}

