/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.collections;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import speiger.src.collections.ints.collections.IntCollection;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.collections.IntSplititerator;
import speiger.src.collections.ints.functions.IntComparator;
import speiger.src.collections.ints.functions.IntConsumer;
import speiger.src.collections.ints.functions.consumer.IntIntConsumer;
import speiger.src.collections.ints.functions.function.IntFunction;
import speiger.src.collections.ints.functions.function.IntIntUnaryOperator;
import speiger.src.collections.ints.utils.IntArrays;
import speiger.src.collections.ints.utils.IntIterables;
import speiger.src.collections.ints.utils.IntIterators;
import speiger.src.collections.ints.utils.IntSplititerators;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.functions.consumer.ObjectIntConsumer;
import speiger.src.collections.utils.ISizeProvider;

public interface IntIterable
extends Iterable<Integer> {
    public IntIterator iterator();

    default public void forEach(IntConsumer action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    @Override
    @Deprecated
    default public void forEach(Consumer<? super Integer> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    default public void forEachIndexed(IntIntConsumer action) {
        Objects.requireNonNull(action);
        int index = 0;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            action.accept(index++, iter.nextInt());
        }
    }

    default public <E> void forEach(E input, ObjectIntConsumer<E> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(input, action);
    }

    default public IntSplititerator spliterator() {
        return IntSplititerators.createUnknownSplititerator(this.iterator(), 0);
    }

    default public <E> ObjectIterable<E> map(IntFunction<E> mapper) {
        return IntIterables.map(this, mapper);
    }

    default public <E, V extends Iterable<E>> ObjectIterable<E> flatMap(IntFunction<V> mapper) {
        return IntIterables.flatMap(this, mapper);
    }

    default public <E> ObjectIterable<E> arrayflatMap(IntFunction<E[]> mapper) {
        return IntIterables.arrayFlatMap(this, mapper);
    }

    default public IntIterable filter(IntPredicate filter) {
        return IntIterables.filter(this, filter);
    }

    default public IntIterable distinct() {
        return IntIterables.distinct(this);
    }

    default public IntIterable repeat(int repeats) {
        return IntIterables.repeat(this, repeats);
    }

    default public IntIterable limit(long limit) {
        return IntIterables.limit(this, limit);
    }

    default public IntIterable sorted(IntComparator sorter) {
        return IntIterables.sorted(this, sorter);
    }

    default public IntIterable peek(IntConsumer action) {
        return IntIterables.peek(this, action);
    }

    default public <E extends IntCollection> E pour(E collection) {
        IntIterators.pour(this.iterator(), collection);
        return collection;
    }

    default public int[] toIntArray() {
        int size;
        ISizeProvider prov = ISizeProvider.of(this);
        if (prov != null && (size = prov.size()) >= 0) {
            int[] array = new int[size];
            IntIterators.unwrap(array, this.iterator());
            return array;
        }
        return IntArrays.pour(this.iterator());
    }

    default public boolean matchesAny(IntPredicate filter) {
        Objects.requireNonNull(filter);
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextInt())) continue;
            return true;
        }
        return false;
    }

    default public boolean matchesNone(IntPredicate filter) {
        Objects.requireNonNull(filter);
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextInt())) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesAll(IntPredicate filter) {
        Objects.requireNonNull(filter);
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (filter.test(iter.nextInt())) continue;
            return false;
        }
        return true;
    }

    default public int findFirst(IntPredicate filter) {
        Objects.requireNonNull(filter);
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            int entry = iter.nextInt();
            if (!filter.test(entry)) continue;
            return entry;
        }
        return 0;
    }

    default public int reduce(int identity, IntIntUnaryOperator operator) {
        Objects.requireNonNull(operator);
        int state = identity;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            state = operator.applyAsInt(state, iter.nextInt());
        }
        return state;
    }

    default public int reduce(IntIntUnaryOperator operator) {
        Objects.requireNonNull(operator);
        int state = 0;
        boolean empty = true;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (empty) {
                empty = false;
                state = iter.nextInt();
                continue;
            }
            state = operator.applyAsInt(state, iter.nextInt());
        }
        return state;
    }

    default public int count(IntPredicate filter) {
        Objects.requireNonNull(filter);
        int result = 0;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextInt())) continue;
            ++result;
        }
        return result;
    }
}

