/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.sets;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongPredicate;
import speiger.src.collections.ints.functions.consumer.IntLongConsumer;
import speiger.src.collections.longs.collections.LongCollection;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.longs.functions.function.LongLongUnaryOperator;
import speiger.src.collections.longs.sets.AbstractLongSet;
import speiger.src.collections.longs.utils.LongIterators;
import speiger.src.collections.objects.functions.consumer.ObjectLongConsumer;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.ITrimmable;
import speiger.src.collections.utils.SanityChecks;

public class LongOpenHashSet
extends AbstractLongSet
implements ITrimmable {
    protected transient long[] keys;
    protected transient boolean containsNull;
    protected transient int minCapacity;
    protected transient int nullIndex;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected final float loadFactor;

    public LongOpenHashSet() {
        this(16, 0.75f);
    }

    public LongOpenHashSet(int minCapacity) {
        this(minCapacity, 0.75f);
    }

    public LongOpenHashSet(int minCapacity, float loadFactor) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalStateException("Load Factor is not between 0 and 1");
        }
        this.loadFactor = loadFactor;
        this.minCapacity = this.nullIndex = HashUtil.arraySize(minCapacity, loadFactor);
        this.mask = this.nullIndex - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * loadFactor), this.nullIndex - 1);
        this.keys = new long[this.nullIndex + 1];
    }

    public LongOpenHashSet(long[] array) {
        this(array, 0, array.length, 0.75f);
    }

    public LongOpenHashSet(long[] array, float loadFactor) {
        this(array, 0, array.length, loadFactor);
    }

    public LongOpenHashSet(long[] array, int offset, int length) {
        this(array, offset, length, 0.75f);
    }

    public LongOpenHashSet(long[] array, int offset, int length, float loadFactor) {
        this(length < 0 ? 0 : length);
        SanityChecks.checkArrayCapacity(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(array[offset + i]);
        }
    }

    @Deprecated
    public LongOpenHashSet(Collection<? extends Long> collection) {
        this(collection, 0.75f);
    }

    @Deprecated
    public LongOpenHashSet(Collection<? extends Long> collection, float loadFactor) {
        this(collection.size(), loadFactor);
        this.addAll(collection);
    }

    public LongOpenHashSet(LongCollection collection) {
        this(collection, 0.75f);
    }

    public LongOpenHashSet(LongCollection collection, float loadFactor) {
        this(collection.size());
        this.addAll(collection);
    }

    public LongOpenHashSet(Iterator<Long> iterator) {
        this(iterator, 0.75f);
    }

    public LongOpenHashSet(Iterator<Long> iterator, float loadFactor) {
        this(LongIterators.wrap(iterator), loadFactor);
    }

    public LongOpenHashSet(LongIterator iterator) {
        this(iterator, 0.75f);
    }

    public LongOpenHashSet(LongIterator iterator, float loadFactor) {
        this(16, loadFactor);
        while (iterator.hasNext()) {
            this.add(iterator.nextLong());
        }
    }

    @Override
    public boolean add(long o) {
        if (o == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
        } else {
            int pos;
            block7: {
                pos = HashUtil.mix(Long.hashCode(o)) & this.mask;
                long current = this.keys[pos];
                if (current != 0L) {
                    if (current == o) {
                        return false;
                    }
                    do {
                        ++pos;
                        current = this.keys[pos &= this.mask];
                        if (current == 0L) break block7;
                    } while (current != o);
                    return false;
                }
            }
            this.keys[pos] = o;
            this.onNodeAdded(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Long> c) {
        if (this.loadFactor <= 0.5f) {
            this.ensureCapacity(c.size());
        } else {
            this.ensureCapacity(c.size() + this.size());
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(LongCollection c) {
        if (this.loadFactor <= 0.5f) {
            this.ensureCapacity(c.size());
        } else {
            this.ensureCapacity(c.size() + this.size());
        }
        return super.addAll(c);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Long && (Long)o == 0L) {
            return this.containsNull;
        }
        int pos = HashUtil.mix(o.hashCode()) & this.mask;
        long current = this.keys[pos];
        if (current == 0L) {
            return false;
        }
        if (Objects.equals(o, current)) {
            return true;
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != 0L) continue;
            return false;
        } while (!Objects.equals(o, current));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Long && (Long)o == 0L) {
            return this.containsNull ? this.removeNullIndex() : false;
        }
        int pos = HashUtil.mix(o.hashCode()) & this.mask;
        long current = this.keys[pos];
        if (current == 0L) {
            return false;
        }
        if (Objects.equals(o, current)) {
            return this.removeIndex(pos);
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != 0L) continue;
            return false;
        } while (!Objects.equals(o, current));
        return this.removeIndex(pos);
    }

    @Override
    public boolean contains(long o) {
        if (o == 0L) {
            return this.containsNull;
        }
        int pos = HashUtil.mix(Long.hashCode(o)) & this.mask;
        long current = this.keys[pos];
        if (current == 0L) {
            return false;
        }
        if (current == o) {
            return true;
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != 0L) continue;
            return false;
        } while (current != o);
        return true;
    }

    @Override
    public boolean remove(long o) {
        if (o == 0L) {
            return this.containsNull ? this.removeNullIndex() : false;
        }
        int pos = HashUtil.mix(Long.hashCode(o)) & this.mask;
        long current = this.keys[pos];
        if (current == 0L) {
            return false;
        }
        if (current == o) {
            return this.removeIndex(pos);
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != 0L) continue;
            return false;
        } while (current != o);
        return this.removeIndex(pos);
    }

    @Override
    public boolean trim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex || this.size >= Math.min((int)Math.ceil((float)request * this.loadFactor), request - 1)) {
            return false;
        }
        try {
            this.rehash(request);
        }
        catch (OutOfMemoryError e) {
            return false;
        }
        return true;
    }

    @Override
    public void clearAndTrim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex) {
            this.clear();
            return;
        }
        this.nullIndex = request;
        this.mask = request - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = new long[request + 1];
        this.size = 0;
        this.containsNull = false;
    }

    @Override
    public void forEach(LongConsumer action) {
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(this.keys[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L) continue;
            action.accept(this.keys[i]);
        }
    }

    @Override
    public void forEachIndexed(IntLongConsumer action) {
        int index;
        Objects.requireNonNull(action);
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(0, this.keys[this.nullIndex]);
        }
        int n = index = this.containsNull ? 1 : 0;
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L) continue;
            action.accept(index++, this.keys[i]);
        }
    }

    @Override
    public <E> void forEach(E input, ObjectLongConsumer<E> action) {
        Objects.requireNonNull(action);
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(input, this.keys[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L) continue;
            action.accept(input, this.keys[i]);
        }
    }

    @Override
    public boolean matchesAny(LongPredicate filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return false;
        }
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            return true;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L || !filter.test(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesNone(LongPredicate filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return true;
        }
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            return false;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L || !filter.test(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesAll(LongPredicate filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return true;
        }
        if (this.containsNull && !filter.test(this.keys[this.nullIndex])) {
            return false;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L || filter.test(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long reduce(long identity, LongLongUnaryOperator operator) {
        Objects.requireNonNull(operator);
        long state = identity;
        if (this.containsNull) {
            state = operator.applyAsLong(state, this.keys[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L) continue;
            state = operator.applyAsLong(state, this.keys[i]);
        }
        return state;
    }

    @Override
    public long reduce(LongLongUnaryOperator operator) {
        Objects.requireNonNull(operator);
        long state = 0L;
        boolean empty = true;
        if (this.containsNull) {
            state = this.keys[this.nullIndex];
            empty = false;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L) continue;
            if (empty) {
                empty = false;
                state = this.keys[i];
                continue;
            }
            state = operator.applyAsLong(state, this.keys[i]);
        }
        return state;
    }

    @Override
    public long findFirst(LongPredicate filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return 0L;
        }
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            return this.keys[this.nullIndex];
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L || !filter.test(this.keys[i])) continue;
            return this.keys[i];
        }
        return 0L;
    }

    @Override
    public int count(LongPredicate filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return 0;
        }
        int result = 0;
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            ++result;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == 0L || !filter.test(this.keys[i])) continue;
            ++result;
        }
        return result;
    }

    private void ensureCapacity(int newCapacity) {
        int size = HashUtil.arraySize(newCapacity, this.loadFactor);
        if (size > this.nullIndex) {
            this.rehash(size);
        }
    }

    protected boolean removeIndex(int pos) {
        if (pos == this.nullIndex) {
            return this.containsNull ? this.removeNullIndex() : false;
        }
        this.keys[pos] = 0L;
        --this.size;
        this.onNodeRemoved(pos);
        this.shiftKeys(pos);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return true;
    }

    protected boolean removeNullIndex() {
        this.containsNull = false;
        this.keys[this.nullIndex] = 0L;
        --this.size;
        this.onNodeRemoved(this.nullIndex);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return true;
    }

    protected void onNodeAdded(int pos) {
    }

    protected void onNodeRemoved(int pos) {
    }

    protected void onNodeMoved(int from, int to) {
    }

    protected void shiftKeys(int startPos) {
        while (true) {
            long current;
            int last = startPos;
            startPos = last + 1 & this.mask;
            while (true) {
                if ((current = this.keys[startPos]) == 0L) {
                    this.keys[last] = 0L;
                    return;
                }
                int slot = HashUtil.mix(Long.hashCode(current)) & this.mask;
                if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                ++startPos;
                startPos &= this.mask;
            }
            this.keys[last] = current;
            this.onNodeMoved(startPos, last);
        }
    }

    protected void rehash(int newSize) {
        int newMask = newSize - 1;
        long[] newKeys = new long[newSize + 1];
        int i = this.nullIndex;
        int pos = 0;
        int j = this.size - (this.containsNull ? 1 : 0);
        while (j-- != 0) {
            do {
                if (--i >= 0) continue;
                throw new ConcurrentModificationException("Set was modified during rehash");
            } while (this.keys[i] == 0L);
            pos = HashUtil.mix(Long.hashCode(this.keys[i])) & newMask;
            if (newKeys[pos] != 0L) {
                do {
                    ++pos;
                } while (newKeys[pos &= newMask] != 0L);
            }
            newKeys[pos] = this.keys[i];
        }
        this.nullIndex = newSize;
        this.mask = newMask;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = newKeys;
    }

    @Override
    public LongIterator iterator() {
        return new SetIterator();
    }

    @Override
    public LongOpenHashSet copy() {
        LongOpenHashSet set = new LongOpenHashSet(0, this.loadFactor);
        set.minCapacity = this.minCapacity;
        set.mask = this.mask;
        set.maxFill = this.maxFill;
        set.nullIndex = this.nullIndex;
        set.containsNull = this.containsNull;
        set.size = this.size;
        set.keys = Arrays.copyOf(this.keys, this.keys.length);
        return set;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.keys, 0L);
    }

    @Override
    public int size() {
        return this.size;
    }

    private class SetIterator
    implements LongIterator {
        int pos;
        int returnedPos;
        int lastReturned;
        int nextIndex;
        boolean returnNull;
        long[] wrapped;
        int wrappedIndex;

        private SetIterator() {
            this.pos = LongOpenHashSet.this.nullIndex;
            this.returnedPos = -1;
            this.lastReturned = -1;
            this.nextIndex = Integer.MIN_VALUE;
            this.returnNull = LongOpenHashSet.this.containsNull;
            this.wrapped = null;
            this.wrappedIndex = 0;
        }

        @Override
        public boolean hasNext() {
            block5: {
                if (this.nextIndex == Integer.MIN_VALUE) {
                    if (this.returnNull) {
                        this.returnNull = false;
                        this.nextIndex = LongOpenHashSet.this.nullIndex;
                    } else {
                        do {
                            if (--this.pos >= 0) continue;
                            if (this.wrapped != null && this.wrappedIndex > -this.pos - 1) {
                                this.nextIndex = -this.pos - 1;
                            }
                            break block5;
                        } while (LongOpenHashSet.this.keys[this.pos] == 0L);
                        this.nextIndex = this.pos;
                    }
                }
            }
            return this.nextIndex != Integer.MIN_VALUE;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.returnedPos = this.pos;
            if (this.nextIndex < 0) {
                this.lastReturned = Integer.MAX_VALUE;
                long value = this.wrapped[this.nextIndex];
                this.nextIndex = Integer.MIN_VALUE;
                return value;
            }
            this.lastReturned = this.nextIndex;
            long value = LongOpenHashSet.this.keys[this.lastReturned];
            this.nextIndex = Integer.MIN_VALUE;
            return value;
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == LongOpenHashSet.this.nullIndex) {
                LongOpenHashSet.this.containsNull = false;
                LongOpenHashSet.this.keys[LongOpenHashSet.this.nullIndex] = 0L;
            } else if (this.returnedPos >= 0) {
                this.shiftKeys(this.returnedPos);
            } else {
                LongOpenHashSet.this.remove(this.wrapped[-this.returnedPos - 1]);
                this.lastReturned = -1;
                return;
            }
            --LongOpenHashSet.this.size;
            this.lastReturned = -1;
        }

        private void shiftKeys(int startPos) {
            while (true) {
                long current;
                int last = startPos;
                startPos = last + 1 & LongOpenHashSet.this.mask;
                while (true) {
                    if ((current = LongOpenHashSet.this.keys[startPos]) == 0L) {
                        LongOpenHashSet.this.keys[last] = 0L;
                        return;
                    }
                    int slot = HashUtil.mix(Long.hashCode(current)) & LongOpenHashSet.this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= LongOpenHashSet.this.mask;
                }
                if (startPos < last) {
                    this.addWrapper(LongOpenHashSet.this.keys[startPos]);
                }
                LongOpenHashSet.this.keys[last] = current;
            }
        }

        private void addWrapper(long value) {
            if (this.wrapped == null) {
                this.wrapped = new long[2];
            } else if (this.wrappedIndex >= this.wrapped.length) {
                long[] newArray = new long[this.wrapped.length * 2];
                System.arraycopy(this.wrapped, 0, newArray, 0, this.wrapped.length);
                this.wrapped = newArray;
            }
            this.wrapped[this.wrappedIndex++] = value;
        }
    }
}

