/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import speiger.src.collections.longs.collections.LongBidirectionalIterator;
import speiger.src.collections.longs.collections.LongCollection;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.functions.LongComparator;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.longs.functions.function.LongFunction;
import speiger.src.collections.longs.lists.LongListIterator;
import speiger.src.collections.longs.utils.LongCollections;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.utils.ObjectIterators;

public class LongIterators {
    private static final EmptyIterator EMPTY = new EmptyIterator();

    public static EmptyIterator empty() {
        return EMPTY;
    }

    public static LongBidirectionalIterator invert(LongBidirectionalIterator it) {
        return it instanceof ReverseBiIterator ? ((ReverseBiIterator)it).it : new ReverseBiIterator(it);
    }

    public static LongListIterator invert(LongListIterator it) {
        return it instanceof ReverseListIterator ? ((ReverseListIterator)it).it : new ReverseListIterator(it);
    }

    public static LongIterator unmodifiable(LongIterator iterator) {
        return iterator instanceof UnmodifiableIterator ? iterator : new UnmodifiableIterator(iterator);
    }

    public static LongBidirectionalIterator unmodifiable(LongBidirectionalIterator iterator) {
        return iterator instanceof UnmodifiableBiIterator ? iterator : new UnmodifiableBiIterator(iterator);
    }

    public static LongListIterator unmodifiable(LongListIterator iterator) {
        return iterator instanceof UnmodifiableListIterator ? iterator : new UnmodifiableListIterator(iterator);
    }

    public static <E> ObjectIterator<E> map(Iterator<? extends Long> iterator, LongFunction<E> mapper) {
        return new MappedIterator<E>(LongIterators.wrap(iterator), mapper);
    }

    public static <E> ObjectIterator<E> map(LongIterator iterator, LongFunction<E> mapper) {
        return new MappedIterator<E>(iterator, mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterator<E> flatMap(Iterator<? extends Long> iterator, LongFunction<V> mapper) {
        return new FlatMappedIterator(LongIterators.wrap(iterator), mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterator<E> flatMap(LongIterator iterator, LongFunction<V> mapper) {
        return new FlatMappedIterator(iterator, mapper);
    }

    public static <E> ObjectIterator<E> arrayFlatMap(Iterator<? extends Long> iterator, LongFunction<E[]> mapper) {
        return new FlatMappedArrayIterator(LongIterators.wrap(iterator), mapper);
    }

    public static <E> ObjectIterator<E> arrayFlatMap(LongIterator iterator, LongFunction<E[]> mapper) {
        return new FlatMappedArrayIterator(iterator, mapper);
    }

    public static LongIterator filter(Iterator<? extends Long> iterator, LongPredicate filter) {
        return new FilteredIterator(LongIterators.wrap(iterator), filter);
    }

    public static LongIterator filter(LongIterator iterator, LongPredicate filter) {
        return new FilteredIterator(iterator, filter);
    }

    public static LongIterator distinct(LongIterator iterator) {
        return new DistinctIterator(iterator);
    }

    public static LongIterator distinct(Iterator<? extends Long> iterator) {
        return new DistinctIterator(LongIterators.wrap(iterator));
    }

    public static LongIterator repeat(LongIterator iterator, int repeats) {
        return new RepeatingIterator(iterator, repeats);
    }

    public static LongIterator repeat(Iterator<? extends Long> iterator, int repeats) {
        return new RepeatingIterator(LongIterators.wrap(iterator), repeats);
    }

    public static LongIterator limit(LongIterator iterator, long limit) {
        return new LimitedIterator(iterator, limit);
    }

    public static LongIterator limit(Iterator<? extends Long> iterator, long limit) {
        return new LimitedIterator(LongIterators.wrap(iterator), limit);
    }

    public static LongIterator sorted(LongIterator iterator, LongComparator sorter) {
        return new SortedIterator(iterator, sorter);
    }

    public static LongIterator sorted(Iterator<? extends Long> iterator, LongComparator sorter) {
        return new SortedIterator(LongIterators.wrap(iterator), sorter);
    }

    public static LongIterator peek(LongIterator iterator, LongConsumer action) {
        return new PeekIterator(iterator, action);
    }

    public static LongIterator peek(Iterator<? extends Long> iterator, LongConsumer action) {
        return new PeekIterator(LongIterators.wrap(iterator), action);
    }

    public static LongIterator wrap(Iterator<? extends Long> iterator) {
        return iterator instanceof LongIterator ? (LongIterator)iterator : new IteratorWrapper(iterator);
    }

    public static ArrayIterator wrap(long ... a) {
        return LongIterators.wrap(a, 0, a.length);
    }

    public static ArrayIterator wrap(long[] a, int start, int end) {
        return new ArrayIterator(a, start, end);
    }

    public static int unwrap(long[] a, Iterator<? extends Long> i) {
        return LongIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(long[] a, Iterator<? extends Long> i, int offset) {
        return LongIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(long[] a, Iterator<? extends Long> i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.next();
        }
        return index;
    }

    public static int unwrap(long[] a, LongIterator i) {
        return LongIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(long[] a, LongIterator i, int offset) {
        return LongIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(long[] a, LongIterator i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.nextLong();
        }
        return index;
    }

    public static int unwrap(Long[] a, LongIterator i) {
        return LongIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(Long[] a, LongIterator i, int offset) {
        return LongIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(Long[] a, LongIterator i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.nextLong();
        }
        return index;
    }

    public static int pour(LongIterator iter, LongCollection c) {
        return LongIterators.pour(iter, c, Integer.MAX_VALUE);
    }

    public static int pour(LongIterator iter, LongCollection c, int max) {
        int done;
        if (max < 0) {
            throw new IllegalStateException("Max is negative");
        }
        for (done = 0; done < max && iter.hasNext(); ++done) {
            c.add(iter.nextLong());
        }
        return done;
    }

    public static LongIterator concat(LongIterator ... array) {
        return LongIterators.concat(array, 0, array.length);
    }

    public static LongIterator concat(LongIterator[] array, int offset, int length) {
        return new ConcatIterator(array, offset, length);
    }

    private static class PeekIterator
    implements LongIterator {
        LongIterator iterator;
        LongConsumer action;

        public PeekIterator(LongIterator iterator, LongConsumer action) {
            this.iterator = iterator;
            this.action = action;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long result = this.iterator.nextLong();
            this.action.accept(result);
            return result;
        }
    }

    private static class LimitedIterator
    implements LongIterator {
        LongIterator iterator;
        long limit;

        public LimitedIterator(LongIterator iterator, long limit) {
            this.iterator = iterator;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.limit > 0L && this.iterator.hasNext();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.limit;
            return this.iterator.nextLong();
        }
    }

    private static class FilteredIterator
    implements LongIterator {
        LongIterator iterator;
        LongPredicate filter;
        long lastFound;
        boolean foundNext = false;

        public FilteredIterator(LongIterator iterator, LongPredicate filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.nextLong();
                if (!this.filter.test(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class DistinctIterator
    implements LongIterator {
        LongIterator iterator;
        LongCollection filtered = LongCollections.distinctWrapper();
        long lastFound;
        boolean foundNext = false;

        public DistinctIterator(LongIterator iterator) {
            this.iterator = iterator;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.nextLong();
                if (!this.filtered.add(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class SortedIterator
    implements LongIterator {
        LongIterator iterator;
        LongComparator sorter;
        LongCollections.CollectionWrapper sortedElements = null;
        int index = 0;

        public SortedIterator(LongIterator iterator, LongComparator sorter) {
            this.iterator = iterator;
            this.sorter = sorter;
        }

        @Override
        public boolean hasNext() {
            if (this.sortedElements == null) {
                boolean hasNext = this.iterator.hasNext();
                if (hasNext) {
                    this.sortedElements = LongCollections.wrapper();
                    LongIterators.pour(this.iterator, this.sortedElements);
                } else {
                    this.sortedElements = LongCollections.wrapper();
                }
                if (hasNext) {
                    this.sortedElements.unstableSort(this.sorter);
                }
            }
            return this.index < this.sortedElements.size();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.sortedElements.getLong(this.index++);
        }
    }

    private static class RepeatingIterator
    implements LongIterator {
        final int repeats;
        int index = 0;
        LongIterator iter;
        LongCollection repeater = LongCollections.wrapper();

        public RepeatingIterator(LongIterator iter, int repeat) {
            this.iter = iter;
            this.repeats = repeat;
        }

        @Override
        public boolean hasNext() {
            if (this.iter.hasNext()) {
                return true;
            }
            if (this.index < this.repeats) {
                ++this.index;
                this.iter = this.repeater.iterator();
                return this.iter.hasNext();
            }
            return false;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long value = this.iter.nextLong();
            if (this.index == 0) {
                this.repeater.add(value);
            }
            return value;
        }
    }

    private static class FlatMappedArrayIterator<T>
    implements ObjectIterator<T> {
        LongIterator iterator;
        Iterator<T> last = null;
        LongFunction<T[]> mapper;
        boolean foundNext = false;

        FlatMappedArrayIterator(LongIterator iterator, LongFunction<T[]> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ObjectIterators.wrap(this.mapper.apply(this.iterator.nextLong()));
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class FlatMappedIterator<T, V extends Iterable<T>>
    implements ObjectIterator<T> {
        LongIterator iterator;
        Iterator<T> last = null;
        LongFunction<V> mapper;
        boolean foundNext = false;

        FlatMappedIterator(LongIterator iterator, LongFunction<V> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ((Iterable)this.mapper.apply(this.iterator.nextLong())).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class MappedIterator<T>
    implements ObjectIterator<T> {
        LongIterator iterator;
        LongFunction<T> mapper;

        MappedIterator(LongIterator iterator, LongFunction<T> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.mapper.apply(this.iterator.nextLong());
        }

        @Override
        public int skip(int amount) {
            return this.iterator.skip(amount);
        }
    }

    private static class ArrayIterator
    implements LongIterator {
        long[] a;
        int from;
        int to;

        ArrayIterator(long[] a, int from, int to) {
            this.a = a;
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.from < this.to;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.a[this.from++];
        }

        @Override
        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int left = Math.min(amount, this.to - this.from);
            this.from += left;
            return amount - left;
        }
    }

    private static class EmptyIterator
    implements LongListIterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public long previousLong() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(long e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator
    implements LongIterator {
        LongIterator iterator;

        UnmodifiableIterator(LongIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public long nextLong() {
            return this.iterator.nextLong();
        }
    }

    private static class UnmodifiableBiIterator
    implements LongBidirectionalIterator {
        LongBidirectionalIterator iter;

        UnmodifiableBiIterator(LongBidirectionalIterator iter) {
            this.iter = iter;
        }

        @Override
        public long nextLong() {
            return this.iter.nextLong();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public long previousLong() {
            return this.iter.previousLong();
        }
    }

    private static class UnmodifiableListIterator
    implements LongListIterator {
        LongListIterator iter;

        UnmodifiableListIterator(LongListIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long previousLong() {
            return this.iter.previousLong();
        }

        @Override
        public long nextLong() {
            return this.iter.nextLong();
        }

        @Override
        public void set(long e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReverseListIterator
    implements LongListIterator {
        LongListIterator it;

        ReverseListIterator(LongListIterator it) {
            this.it = it;
        }

        @Override
        public long nextLong() {
            return this.it.previousLong();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public long previousLong() {
            return this.it.nextLong();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void set(long e) {
            this.it.set(e);
        }

        @Override
        public void add(long e) {
            this.it.add(e);
        }
    }

    private static class ReverseBiIterator
    implements LongBidirectionalIterator {
        LongBidirectionalIterator it;

        ReverseBiIterator(LongBidirectionalIterator it) {
            this.it = it;
        }

        @Override
        public long nextLong() {
            return this.it.previousLong();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public long previousLong() {
            return this.it.nextLong();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private static class ConcatIterator
    implements LongIterator {
        LongIterator[] iters;
        int offset;
        int lastOffset = -1;
        int length;

        public ConcatIterator(LongIterator[] iters, int offset, int length) {
            this.iters = iters;
            this.offset = offset;
            this.length = length;
            this.find();
        }

        private void find() {
            while (this.length != 0 && !this.iters[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            long result = this.iters[this.lastOffset].nextLong();
            this.find();
            return result;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.iters[this.lastOffset].remove();
            this.lastOffset = -1;
        }
    }

    private static class IteratorWrapper
    implements LongIterator {
        Iterator<? extends Long> iter;

        public IteratorWrapper(Iterator<? extends Long> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public long nextLong() {
            return this.iter.next();
        }

        @Override
        @Deprecated
        public Long next() {
            return this.iter.next();
        }
    }
}

