/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;

public abstract class AbstractObjectCollection<T>
extends AbstractCollection<T>
implements ObjectCollection<T> {
    @Override
    public abstract ObjectIterator<T> iterator();

    @Override
    public boolean addAll(ObjectCollection<T> c) {
        boolean modified = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    @Override
    public ObjectCollection<T> copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(ObjectCollection<T> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return true;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c instanceof ObjectCollection ? this.containsAll((ObjectCollection)c) : super.containsAll(c);
    }

    @Override
    public boolean containsAny(Collection<?> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        for (Object e : c) {
            if (!this.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(ObjectCollection<T> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(ObjectCollection<T> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(ObjectCollection<T> c, Consumer<T> r) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(r);
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(ObjectCollection<T> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(ObjectCollection<T> c, Consumer<T> r) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(r);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.forEach(r);
            this.clear();
            return modified;
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }
}

