/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.collections;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.collections.ObjectSplititerator;
import speiger.src.collections.objects.utils.ObjectCollections;
import speiger.src.collections.objects.utils.ObjectSplititerators;
import speiger.src.collections.utils.ISizeProvider;
import speiger.src.collections.utils.SanityChecks;

public interface ObjectCollection<T>
extends Collection<T>,
ObjectIterable<T>,
ISizeProvider {
    @Override
    public boolean addAll(ObjectCollection<T> var1);

    default public boolean addAll(T ... e) {
        return this.addAll(e, 0, e.length);
    }

    default public boolean addAll(T[] e, int length) {
        return this.addAll(e, 0, length);
    }

    default public boolean addAll(T[] e, int offset, int length) {
        if (length <= 0) {
            return false;
        }
        SanityChecks.checkArrayCapacity(e.length, offset, length);
        boolean added = false;
        for (int i = 0; i < length; ++i) {
            if (!this.add(e[offset + i])) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean containsAll(ObjectCollection<T> var1);

    public boolean containsAny(ObjectCollection<T> var1);

    public boolean containsAny(Collection<?> var1);

    @Override
    public boolean removeAll(ObjectCollection<T> var1);

    public boolean removeAll(ObjectCollection<T> var1, Consumer<T> var2);

    @Override
    public boolean retainAll(ObjectCollection<T> var1);

    public boolean retainAll(ObjectCollection<T> var1, Consumer<T> var2);

    @Override
    default public <E extends ObjectCollection<T>> E pour(E collection) {
        collection.addAll(this);
        return collection;
    }

    public ObjectCollection<T> copy();

    @Override
    default public <E> E[] toArray(IntFunction<E[]> action) {
        return this.toArray(action.apply(this.size()));
    }

    @Override
    public ObjectIterator<T> iterator();

    default public ObjectCollection<T> synchronize() {
        return ObjectCollections.synchronize(this);
    }

    default public ObjectCollection<T> synchronize(Object mutex) {
        return ObjectCollections.synchronize(this, mutex);
    }

    default public ObjectCollection<T> unmodifiable() {
        return ObjectCollections.unmodifiable(this);
    }

    @Override
    default public ObjectSplititerator<T> spliterator() {
        return ObjectSplititerators.createSplititerator(this, 0);
    }
}

