/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.sets;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.ITrimmable;
import speiger.src.collections.utils.SanityChecks;

public class ObjectOpenHashSet<T>
extends AbstractObjectSet<T>
implements ITrimmable {
    protected transient T[] keys;
    protected transient boolean containsNull;
    protected transient int minCapacity;
    protected transient int nullIndex;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected final float loadFactor;

    public ObjectOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectOpenHashSet(int minCapacity) {
        this(minCapacity, 0.75f);
    }

    public ObjectOpenHashSet(int minCapacity, float loadFactor) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalStateException("Load Factor is not between 0 and 1");
        }
        this.loadFactor = loadFactor;
        this.minCapacity = this.nullIndex = HashUtil.arraySize(minCapacity, loadFactor);
        this.mask = this.nullIndex - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * loadFactor), this.nullIndex - 1);
        this.keys = new Object[this.nullIndex + 1];
    }

    public ObjectOpenHashSet(T[] array) {
        this(array, 0, array.length, 0.75f);
    }

    public ObjectOpenHashSet(T[] array, float loadFactor) {
        this(array, 0, array.length, loadFactor);
    }

    public ObjectOpenHashSet(T[] array, int offset, int length) {
        this(array, offset, length, 0.75f);
    }

    public ObjectOpenHashSet(T[] array, int offset, int length, float loadFactor) {
        this(length < 0 ? 0 : length);
        SanityChecks.checkArrayCapacity(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(array[offset + i]);
        }
    }

    public ObjectOpenHashSet(Collection<? extends T> collection) {
        this(collection, 0.75f);
    }

    public ObjectOpenHashSet(Collection<? extends T> collection, float loadFactor) {
        this(collection.size(), loadFactor);
        this.addAll(collection);
    }

    public ObjectOpenHashSet(ObjectCollection<T> collection) {
        this(collection, 0.75f);
    }

    public ObjectOpenHashSet(ObjectCollection<T> collection, float loadFactor) {
        this(collection.size());
        this.addAll(collection);
    }

    public ObjectOpenHashSet(Iterator<T> iterator) {
        this(iterator, 0.75f);
    }

    public ObjectOpenHashSet(Iterator<T> iterator, float loadFactor) {
        this(16, loadFactor);
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
        } else {
            int pos;
            block7: {
                pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
                T current = this.keys[pos];
                if (current != null) {
                    if (Objects.equals(current, o)) {
                        return false;
                    }
                    do {
                        ++pos;
                        current = this.keys[pos &= this.mask];
                        if (current == null) break block7;
                    } while (!Objects.equals(current, o));
                    return false;
                }
            }
            this.keys[pos] = o;
            this.onNodeAdded(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return true;
    }

    @Override
    public T addOrGet(T o) {
        if (o == null) {
            if (this.containsNull) {
                return null;
            }
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
        } else {
            int pos;
            block7: {
                pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
                T current = this.keys[pos];
                if (current != null) {
                    if (Objects.equals(current, o)) {
                        return current;
                    }
                    do {
                        ++pos;
                        current = this.keys[pos &= this.mask];
                        if (current == null) break block7;
                    } while (!Objects.equals(current, o));
                    return current;
                }
            }
            this.keys[pos] = o;
            this.onNodeAdded(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return o;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.loadFactor <= 0.5f) {
            this.ensureCapacity(c.size());
        } else {
            this.ensureCapacity(c.size() + this.size());
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(ObjectCollection<T> c) {
        if (this.loadFactor <= 0.5f) {
            this.ensureCapacity(c.size());
        } else {
            this.ensureCapacity(c.size() + this.size());
        }
        return super.addAll(c);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return this.containsNull;
        }
        int pos = HashUtil.mix(o.hashCode()) & this.mask;
        T current = this.keys[pos];
        if (current == null) {
            return false;
        }
        if (Objects.equals(o, current)) {
            return true;
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != null) continue;
            return false;
        } while (!Objects.equals(o, current));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return this.containsNull ? this.removeNullIndex() : false;
        }
        int pos = HashUtil.mix(o.hashCode()) & this.mask;
        T current = this.keys[pos];
        if (current == null) {
            return false;
        }
        if (Objects.equals(o, current)) {
            return this.removeIndex(pos);
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != null) continue;
            return false;
        } while (!Objects.equals(o, current));
        return this.removeIndex(pos);
    }

    @Override
    public boolean trim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex || this.size >= Math.min((int)Math.ceil((float)request * this.loadFactor), request - 1)) {
            return false;
        }
        try {
            this.rehash(request);
        }
        catch (OutOfMemoryError e) {
            return false;
        }
        return true;
    }

    @Override
    public void clearAndTrim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex) {
            this.clear();
            return;
        }
        this.nullIndex = request;
        this.mask = request - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = new Object[request + 1];
        this.size = 0;
        this.containsNull = false;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(this.keys[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            action.accept(this.keys[i]);
        }
    }

    @Override
    public void forEachIndexed(IntObjectConsumer<T> action) {
        int index;
        Objects.requireNonNull(action);
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(0, this.keys[this.nullIndex]);
        }
        int n = index = this.containsNull ? 1 : 0;
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            action.accept(index++, this.keys[i]);
        }
    }

    @Override
    public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
        Objects.requireNonNull(action);
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(input, (E)this.keys[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            action.accept(input, (E)this.keys[i]);
        }
    }

    @Override
    public boolean matchesAny(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return false;
        }
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            return true;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null || !filter.test(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesNone(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return true;
        }
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            return false;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null || !filter.test(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesAll(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return true;
        }
        if (this.containsNull && !filter.test(this.keys[this.nullIndex])) {
            return false;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null || filter.test(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
        Objects.requireNonNull(operator);
        E state = identity;
        if (this.containsNull) {
            state = operator.apply(state, this.keys[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            state = operator.apply(state, this.keys[i]);
        }
        return state;
    }

    @Override
    public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
        Objects.requireNonNull(operator);
        Object state = null;
        boolean empty = true;
        if (this.containsNull) {
            state = this.keys[this.nullIndex];
            empty = false;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            if (empty) {
                empty = false;
                state = this.keys[i];
                continue;
            }
            state = operator.apply(state, this.keys[i]);
        }
        return state;
    }

    @Override
    public T findFirst(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return null;
        }
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            return this.keys[this.nullIndex];
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null || !filter.test(this.keys[i])) continue;
            return this.keys[i];
        }
        return null;
    }

    @Override
    public int count(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        if (this.size() <= 0) {
            return 0;
        }
        int result = 0;
        if (this.containsNull && filter.test(this.keys[this.nullIndex])) {
            ++result;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == null || !filter.test(this.keys[i])) continue;
            ++result;
        }
        return result;
    }

    private void ensureCapacity(int newCapacity) {
        int size = HashUtil.arraySize(newCapacity, this.loadFactor);
        if (size > this.nullIndex) {
            this.rehash(size);
        }
    }

    protected boolean removeIndex(int pos) {
        if (pos == this.nullIndex) {
            return this.containsNull ? this.removeNullIndex() : false;
        }
        this.keys[pos] = null;
        --this.size;
        this.onNodeRemoved(pos);
        this.shiftKeys(pos);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return true;
    }

    protected boolean removeNullIndex() {
        this.containsNull = false;
        this.keys[this.nullIndex] = null;
        --this.size;
        this.onNodeRemoved(this.nullIndex);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return true;
    }

    protected void onNodeAdded(int pos) {
    }

    protected void onNodeRemoved(int pos) {
    }

    protected void onNodeMoved(int from, int to) {
    }

    protected void shiftKeys(int startPos) {
        while (true) {
            T current;
            int last = startPos;
            startPos = last + 1 & this.mask;
            while (true) {
                if ((current = this.keys[startPos]) == null) {
                    this.keys[last] = null;
                    return;
                }
                int slot = HashUtil.mix(Objects.hashCode(current)) & this.mask;
                if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                ++startPos;
                startPos &= this.mask;
            }
            this.keys[last] = current;
            this.onNodeMoved(startPos, last);
        }
    }

    protected void rehash(int newSize) {
        int newMask = newSize - 1;
        Object[] newKeys = new Object[newSize + 1];
        int i = this.nullIndex;
        int pos = 0;
        int j = this.size - (this.containsNull ? 1 : 0);
        while (j-- != 0) {
            do {
                if (--i >= 0) continue;
                throw new ConcurrentModificationException("Set was modified during rehash");
            } while (this.keys[i] == null);
            pos = HashUtil.mix(Objects.hashCode(this.keys[i])) & newMask;
            if (newKeys[pos] != null) {
                do {
                    ++pos;
                } while (newKeys[pos &= newMask] != null);
            }
            newKeys[pos] = this.keys[i];
        }
        this.nullIndex = newSize;
        this.mask = newMask;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = newKeys;
    }

    @Override
    public ObjectIterator<T> iterator() {
        return new SetIterator();
    }

    @Override
    public ObjectOpenHashSet<T> copy() {
        ObjectOpenHashSet<T> set = new ObjectOpenHashSet<T>(0, this.loadFactor);
        set.minCapacity = this.minCapacity;
        set.mask = this.mask;
        set.maxFill = this.maxFill;
        set.nullIndex = this.nullIndex;
        set.containsNull = this.containsNull;
        set.size = this.size;
        set.keys = Arrays.copyOf(this.keys, this.keys.length);
        return set;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.keys, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    private class SetIterator
    implements ObjectIterator<T> {
        int pos;
        int returnedPos;
        int lastReturned;
        int nextIndex;
        boolean returnNull;
        T[] wrapped;
        int wrappedIndex;

        private SetIterator() {
            this.pos = ObjectOpenHashSet.this.nullIndex;
            this.returnedPos = -1;
            this.lastReturned = -1;
            this.nextIndex = Integer.MIN_VALUE;
            this.returnNull = ObjectOpenHashSet.this.containsNull;
            this.wrapped = null;
            this.wrappedIndex = 0;
        }

        @Override
        public boolean hasNext() {
            block5: {
                if (this.nextIndex == Integer.MIN_VALUE) {
                    if (this.returnNull) {
                        this.returnNull = false;
                        this.nextIndex = ObjectOpenHashSet.this.nullIndex;
                    } else {
                        do {
                            if (--this.pos >= 0) continue;
                            if (this.wrapped != null && this.wrappedIndex > -this.pos - 1) {
                                this.nextIndex = -this.pos - 1;
                            }
                            break block5;
                        } while (ObjectOpenHashSet.this.keys[this.pos] == null);
                        this.nextIndex = this.pos;
                    }
                }
            }
            return this.nextIndex != Integer.MIN_VALUE;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.returnedPos = this.pos;
            if (this.nextIndex < 0) {
                this.lastReturned = Integer.MAX_VALUE;
                Object value = this.wrapped[this.nextIndex];
                this.nextIndex = Integer.MIN_VALUE;
                return value;
            }
            this.lastReturned = this.nextIndex;
            Object value = ObjectOpenHashSet.this.keys[this.lastReturned];
            this.nextIndex = Integer.MIN_VALUE;
            return value;
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == ObjectOpenHashSet.this.nullIndex) {
                ObjectOpenHashSet.this.containsNull = false;
                ObjectOpenHashSet.this.keys[ObjectOpenHashSet.this.nullIndex] = null;
            } else if (this.returnedPos >= 0) {
                this.shiftKeys(this.returnedPos);
            } else {
                ObjectOpenHashSet.this.remove(this.wrapped[-this.returnedPos - 1]);
                this.lastReturned = -1;
                return;
            }
            --ObjectOpenHashSet.this.size;
            this.lastReturned = -1;
        }

        private void shiftKeys(int startPos) {
            while (true) {
                Object current;
                int last = startPos;
                startPos = last + 1 & ObjectOpenHashSet.this.mask;
                while (true) {
                    if ((current = ObjectOpenHashSet.this.keys[startPos]) == null) {
                        ObjectOpenHashSet.this.keys[last] = null;
                        return;
                    }
                    int slot = HashUtil.mix(Objects.hashCode(current)) & ObjectOpenHashSet.this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= ObjectOpenHashSet.this.mask;
                }
                if (startPos < last) {
                    this.addWrapper(ObjectOpenHashSet.this.keys[startPos]);
                }
                ObjectOpenHashSet.this.keys[last] = current;
            }
        }

        private void addWrapper(T value) {
            if (this.wrapped == null) {
                this.wrapped = new Object[2];
            } else if (this.wrappedIndex >= this.wrapped.length) {
                Object[] newArray = new Object[this.wrapped.length * 2];
                System.arraycopy(this.wrapped, 0, newArray, 0, this.wrapped.length);
                this.wrapped = newArray;
            }
            this.wrapped[this.wrappedIndex++] = value;
        }
    }
}

