/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.RecursiveAction;
import java.util.function.IntFunction;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.utils.ObjectCollections;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.utils.SanityChecks;

public class ObjectArrays {
    public static final int BASE_THRESHOLD = 16;
    public static final int PARALLEL_THRESHOLD = 8192;
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> T[] newArray(Class<T> clz, int length) {
        if (clz == Object.class) {
            return new Object[length];
        }
        return (Object[])Array.newInstance(clz, length);
    }

    public static <T> T[] pour(ObjectIterator<T> iter) {
        return ObjectArrays.pour(iter, Integer.MAX_VALUE);
    }

    public static <T> T[] pour(ObjectIterator<T> iter, int max) {
        ObjectCollections.CollectionWrapper list = ObjectCollections.wrapper();
        ObjectIterators.pour(iter, list, max);
        return list.toArray((E[])new Object[list.size()]);
    }

    public static <T, E> E[] pour(ObjectIterator<T> iter, IntFunction<E[]> action) {
        return ObjectArrays.pour(iter, Integer.MAX_VALUE, action);
    }

    public static <T, E> E[] pour(ObjectIterator<T> iter, int max, IntFunction<E[]> action) {
        ObjectCollections.CollectionWrapper list = ObjectCollections.wrapper();
        ObjectIterators.pour(iter, list, max);
        return list.toArray(action.apply(list.size()));
    }

    public static <T> int shiftDown(T[] data, int size, int index, Comparator<? super T> comp) {
        int half = size >>> 1;
        T value = data[index];
        if (comp != null) {
            while (index < half) {
                int child = (index << 1) + 1;
                T childValue = data[child];
                int right = child + 1;
                if (right < size && comp.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (comp.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        } else {
            while (index < half) {
                int child = (index << 1) + 1;
                T childValue = data[child];
                int right = child + 1;
                if (right < size && ((Comparable)data[right]).compareTo(childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (((Comparable)value).compareTo(childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        }
        data[index] = value;
        return index;
    }

    public static <T> int shiftUp(T[] data, int index, Comparator<? super T> comp) {
        T value = data[index];
        if (comp != null) {
            int parent;
            T parentValue;
            while (index > 0 && comp.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        } else {
            int parent;
            T parentValue;
            while (index > 0 && ((Comparable)value).compareTo(parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        }
        data[index] = value;
        return index;
    }

    public static <T> T[] heapify(T[] data, int size, Comparator<? super T> comp) {
        int i = (size >>> 1) - 1;
        while (i >= 0) {
            ObjectArrays.shiftDown(data, size, i--, comp);
        }
        return data;
    }

    public static <T> T[] shuffle(T[] array) {
        return ObjectArrays.shuffle(array, SanityChecks.getRandom());
    }

    public static <T> T[] shuffle(T[] array, int length) {
        return ObjectArrays.shuffle(array, 0, length, SanityChecks.getRandom());
    }

    public static <T> T[] shuffle(T[] array, int offset, int length) {
        return ObjectArrays.shuffle(array, offset, length, SanityChecks.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        for (int i = array.length - 1; i >= 0; --i) {
            int p = random.nextInt(i + 1);
            T t = array[i];
            array[i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static <T> T[] shuffle(T[] array, int length, Random random) {
        return ObjectArrays.shuffle(array, 0, length, random);
    }

    public static <T> T[] shuffle(T[] array, int offset, int length, Random random) {
        for (int i = length - 1; i >= 0; --i) {
            int p = offset + random.nextInt(i + 1);
            T t = array[offset + i];
            array[offset + i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ObjectArrays.reverse(array, 0, array.length);
    }

    public static <T> T[] reverse(T[] array, int length) {
        return ObjectArrays.reverse(array, 0, length);
    }

    public static <T> T[] reverse(T[] array, int offset, int length) {
        int i = offset;
        int mid = offset + length >> 1;
        int j = offset + length - 1;
        while (i < mid) {
            T temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
            --j;
        }
        return array;
    }

    public static <T> T[] stableSort(T[] array, Comparator<T> comp) {
        ObjectArrays.stableSort(array, 0, array.length, comp);
        return array;
    }

    public static <T> void stableSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.stableSort(array, 0, length, comp);
    }

    public static <T> void stableSort(T[] array, int from, int to, Comparator<T> comp) {
        ObjectArrays.mergeSort(array, null, from, to, comp);
    }

    public static <T> T[] stableSort(T[] array) {
        ObjectArrays.stableSort(array, 0, array.length);
        return array;
    }

    public static <T> void stableSort(T[] array, int length) {
        ObjectArrays.stableSort(array, 0, length);
    }

    public static <T> void stableSort(T[] array, int from, int to) {
        ObjectArrays.mergeSort(array, null, from, to);
    }

    public static <T> T[] unstableSort(T[] array, Comparator<T> comp) {
        ObjectArrays.unstableSort(array, 0, array.length, comp);
        return array;
    }

    public static <T> void unstableSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.unstableSort(array, 0, length, comp);
    }

    public static <T> void unstableSort(T[] array, int from, int to, Comparator<T> comp) {
        ObjectArrays.quickSort(array, from, to, comp);
    }

    public static <T> T[] unstableSort(T[] array) {
        ObjectArrays.unstableSort(array, 0, array.length);
        return array;
    }

    public static <T> void unstableSort(T[] array, int length) {
        ObjectArrays.unstableSort(array, 0, length);
    }

    public static <T> void unstableSort(T[] array, int from, int to) {
        ObjectArrays.quickSort(array, from, to);
    }

    public static <T> T[] insertionSort(T[] array, Comparator<T> comp) {
        ObjectArrays.insertionSort(array, 0, array.length, comp);
        return array;
    }

    public static <T> void insertionSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.insertionSort(array, 0, length, comp);
    }

    public static <T> void insertionSort(T[] array, int from, int to, Comparator<T> comp) {
        for (int i = from + 1; i < to; ++i) {
            T current = array[i];
            int j = i - 1;
            while (j >= from && comp.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static <T> T[] insertionSort(T[] array) {
        ObjectArrays.insertionSort(array, 0, array.length);
        return array;
    }

    public static <T> void insertionSort(T[] array, int length) {
        ObjectArrays.insertionSort(array, 0, length);
    }

    public static <T> void insertionSort(T[] array, int from, int to) {
        for (int i = from + 1; i < to; ++i) {
            T current = array[i];
            int j = i - 1;
            while (j >= from && ((Comparable)current).compareTo(array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static <T> T[] selectionSort(T[] array, Comparator<T> comp) {
        ObjectArrays.selectionSort(array, 0, array.length, comp);
        return array;
    }

    public static <T> void selectionSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.selectionSort(array, 0, length, comp);
    }

    public static <T> void selectionSort(T[] array, int from, int to, Comparator<T> comp) {
        for (int i = from; i < to; ++i) {
            T min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            T temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static <T> T[] selectionSort(T[] array) {
        ObjectArrays.selectionSort(array, 0, array.length);
        return array;
    }

    public static <T> void selectionSort(T[] array, int length) {
        ObjectArrays.selectionSort(array, 0, length);
    }

    public static <T> void selectionSort(T[] array, int from, int to) {
        for (int i = from; i < to; ++i) {
            T min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (((Comparable)array[j]).compareTo(min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            T temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static <T> T[] mergeSort(T[] array, Comparator<T> comp) {
        ObjectArrays.mergeSort(array, null, 0, array.length, comp);
        return array;
    }

    public static <T> void mergeSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.mergeSort(array, null, 0, length, comp);
    }

    public static <T> void mergeSort(T[] array, T[] supp, int from, int to, Comparator<T> comp) {
        if (to - from < 16) {
            ObjectArrays.insertionSort(array, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        ObjectArrays.mergeSort(supp, array, from, mid, comp);
        ObjectArrays.mergeSort(supp, array, mid, to, comp);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && comp.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static <T> T[] mergeSort(T[] array) {
        ObjectArrays.mergeSort(array, null, 0, array.length);
        return array;
    }

    public static <T> void mergeSort(T[] array, int length) {
        ObjectArrays.mergeSort(array, null, 0, length);
    }

    public static <T> void mergeSort(T[] array, T[] supp, int from, int to) {
        if (to - from < 16) {
            ObjectArrays.insertionSort(array, from, to);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        ObjectArrays.mergeSort(supp, array, from, mid);
        ObjectArrays.mergeSort(supp, array, mid, to);
        if (((Comparable)supp[mid - 1]).compareTo(supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && ((Comparable)supp[p]).compareTo(supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static <T> void parallelMergeSort(T[] array, Comparator<T> comp) {
        ObjectArrays.parallelMergeSort(array, null, 0, array.length, comp);
    }

    public static <T> void parallelMergeSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.parallelMergeSort(array, null, 0, length, comp);
    }

    public static <T> void parallelMergeSort(T[] array, T[] supp, int from, int to, Comparator<T> comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortActionComp<T>(array, supp, from, to, comp));
            return;
        }
        ObjectArrays.mergeSort(array, supp, from, to, comp);
    }

    public static <T> void parallelMergeSort(T[] array) {
        ObjectArrays.parallelMergeSort(array, null, 0, array.length);
    }

    public static <T> void parallelMergeSort(T[] array, int length) {
        ObjectArrays.parallelMergeSort(array, null, 0, length);
    }

    public static <T> void parallelMergeSort(T[] array, T[] supp, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortAction<T>(array, supp, from, to));
            return;
        }
        ObjectArrays.mergeSort(array, supp, from, to);
    }

    public static <T> void memFreeMergeSort(T[] array, Comparator<T> comp) {
        ObjectArrays.memFreeMergeSort(array, 0, array.length, comp);
    }

    public static <T> void memFreeMergeSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.memFreeMergeSort(array, 0, length, comp);
    }

    public static <T> void memFreeMergeSort(T[] array, int from, int to, Comparator<T> comp) {
        if (to - from < 16) {
            ObjectArrays.insertionSort(array, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        ObjectArrays.memFreeMergeSort(array, from, mid, comp);
        ObjectArrays.memFreeMergeSort(array, mid, to, comp);
        if (comp.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int compare = comp.compare(array[i], array[j]);
            if (compare < 0) {
                ++i;
                continue;
            }
            if (compare == 0) {
                ObjectArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && comp.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                ObjectArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                T value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            Object[] data = new Object[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static <T> T[] memFreeMergeSort(T[] array) {
        ObjectArrays.memFreeMergeSort(array, 0, array.length);
        return array;
    }

    public static <T> void memFreeMergeSort(T[] array, int length) {
        ObjectArrays.memFreeMergeSort(array, 0, length);
    }

    public static <T> void memFreeMergeSort(T[] array, int from, int to) {
        if (to - from < 16) {
            ObjectArrays.insertionSort(array, from, to);
            return;
        }
        int mid = from + to >>> 1;
        ObjectArrays.memFreeMergeSort(array, from, mid);
        ObjectArrays.memFreeMergeSort(array, mid, to);
        if (((Comparable)array[mid - 1]).compareTo(array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int comp = ((Comparable)array[i]).compareTo(array[j]);
            if (comp < 0) {
                ++i;
                continue;
            }
            if (comp == 0) {
                ObjectArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && ((Comparable)array[i]).compareTo(array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                ObjectArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                T value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            Object[] data = new Object[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static <T> void parallelMemFreeMergeSort(T[] array, Comparator<T> comp) {
        ObjectArrays.parallelMemFreeMergeSort(array, 0, array.length, comp);
    }

    public static <T> void parallelMemFreeMergeSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.parallelMemFreeMergeSort(array, 0, length, comp);
    }

    public static <T> void parallelMemFreeMergeSort(T[] array, int from, int to, Comparator<T> comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortActionComp<T>(array, from, to, comp));
            return;
        }
        ObjectArrays.memFreeMergeSort(array, from, to, comp);
    }

    public static <T> void parallelMemFreeMergeSort(T[] array) {
        ObjectArrays.parallelMemFreeMergeSort(array, 0, array.length);
    }

    public static <T> void parallelMemFreeMergeSort(T[] array, int length) {
        ObjectArrays.parallelMemFreeMergeSort(array, 0, length);
    }

    public static <T> void parallelMemFreeMergeSort(T[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortAction<T>(array, from, to));
            return;
        }
        ObjectArrays.memFreeMergeSort(array, from, to);
    }

    public static <T> T[] quickSort(T[] array, Comparator<T> comp) {
        ObjectArrays.quickSort(array, 0, array.length, comp);
        return array;
    }

    public static <T> void quickSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.quickSort(array, 0, length, comp);
    }

    public static <T> void quickSort(T[] array, int from, int to, Comparator<T> comp) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            ObjectArrays.selectionSort(array, from, to, comp);
            return;
        }
        T pivot = array[length > 128 ? ObjectArrays.subMedium(array, from, from + length / 2, to - 1, length / 8, comp) : ObjectArrays.medium(array, from, from + length / 2, to - 1, comp)];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int compare;
            if (b <= c && (compare = comp.compare(array[b], pivot)) <= 0) {
                if (compare == 0) {
                    ObjectArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (compare = comp.compare(array[c], pivot)) >= 0) {
                if (compare == 0) {
                    ObjectArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ObjectArrays.swap(array, b++, c--);
        }
        ObjectArrays.swap(array, from, b, Math.min(a - from, b - a));
        ObjectArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            ObjectArrays.quickSort(array, from, from + length, comp);
        }
        if ((length = d - c) > 1) {
            ObjectArrays.quickSort(array, to - length, to, comp);
        }
    }

    public static <T> T[] quickSort(T[] array) {
        ObjectArrays.quickSort(array, 0, array.length);
        return array;
    }

    public static <T> void quickSort(T[] array, int length) {
        ObjectArrays.quickSort(array, 0, length);
    }

    public static <T> void quickSort(T[] array, int from, int to) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            ObjectArrays.selectionSort(array, from, to);
            return;
        }
        T pivot = array[length > 128 ? ObjectArrays.subMedium(array, from, from + length / 2, to - 1, length / 8) : ObjectArrays.medium(array, from, from + length / 2, to - 1)];
        int b = a = from;
        int d = c = to - 1;
        int comp = 0;
        while (true) {
            if (b <= c && (comp = ((Comparable)array[b]).compareTo(pivot)) <= 0) {
                if (comp == 0) {
                    ObjectArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = ((Comparable)array[c]).compareTo(pivot)) >= 0) {
                if (comp == 0) {
                    ObjectArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ObjectArrays.swap(array, b++, c--);
        }
        ObjectArrays.swap(array, from, b, Math.min(a - from, b - a));
        ObjectArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            ObjectArrays.quickSort(array, from, from + length);
        }
        if ((length = d - c) > 1) {
            ObjectArrays.quickSort(array, to - length, to);
        }
    }

    public static <T> void parallelQuickSort(T[] array, Comparator<T> comp) {
        ObjectArrays.parallelQuickSort(array, 0, array.length, comp);
    }

    public static <T> void parallelQuickSort(T[] array, int length, Comparator<T> comp) {
        ObjectArrays.parallelQuickSort(array, 0, length, comp);
    }

    public static <T> void parallelQuickSort(T[] array, int from, int to, Comparator<T> comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortActionComp<T>(array, from, to, comp));
            return;
        }
        ObjectArrays.quickSort(array, from, to, comp);
    }

    public static <T> void parallelQuickSort(T[] array) {
        ObjectArrays.parallelQuickSort(array, 0, array.length);
    }

    public static <T> void parallelQuickSort(T[] array, int length) {
        ObjectArrays.parallelQuickSort(array, 0, length);
    }

    public static <T> void parallelQuickSort(T[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortAction<T>(array, from, to));
            return;
        }
        ObjectArrays.quickSort(array, from, to);
    }

    static <T> void swap(T[] a, int from, int to) {
        T t = a[from];
        a[from] = a[to];
        a[to] = t;
    }

    static <T> void swap(T[] a, int from, int to, int length) {
        to -= length;
        for (int i = 0; i < length; ++i) {
            ObjectArrays.swap(a, from++, to++);
        }
    }

    static <T> int subMedium(T[] data, int a, int b, int c, int length, Comparator<T> comp) {
        return ObjectArrays.medium(data, ObjectArrays.medium(data, a, a + length, a + length * 2, comp), ObjectArrays.medium(data, b - length, b, b + length, comp), ObjectArrays.medium(data, c - length * 2, c - length, c, comp), comp);
    }

    static <T> int medium(T[] data, int a, int b, int c, Comparator<T> comp) {
        return comp.compare(data[a], data[b]) < 0 ? (comp.compare(data[b], data[c]) < 0 ? b : (comp.compare(data[a], data[c]) < 0 ? c : a)) : (comp.compare(data[b], data[c]) > 0 ? b : (comp.compare(data[a], data[c]) > 0 ? c : a));
    }

    static <T> int subMedium(T[] data, int a, int b, int c, int length) {
        return ObjectArrays.medium(data, ObjectArrays.medium(data, a, a + length, a + length * 2), ObjectArrays.medium(data, b - length, b, b + length), ObjectArrays.medium(data, c - length * 2, c - length, c));
    }

    static <T> int medium(T[] data, int a, int b, int c) {
        return ((Comparable)data[a]).compareTo(data[b]) < 0 ? (((Comparable)data[b]).compareTo(data[c]) < 0 ? b : (((Comparable)data[a]).compareTo(data[c]) < 0 ? c : a)) : (((Comparable)data[b]).compareTo(data[c]) > 0 ? b : (((Comparable)data[a]).compareTo(data[c]) > 0 ? c : a));
    }

    static class MemFreeMergeSortActionComp<T>
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        T[] array;
        int from;
        int to;
        Comparator<T> comp;

        MemFreeMergeSortActionComp(T[] array, int from, int to, Comparator<T> comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                ObjectArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortActionComp.invokeAll(new MemFreeMergeSortActionComp<T>(this.array, this.from, mid, this.comp), new MemFreeMergeSortActionComp<T>(this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int compare = this.comp.compare(this.array[i], this.array[j]);
                if (compare < 0) {
                    ++i;
                    continue;
                }
                if (compare == 0) {
                    ObjectArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && this.comp.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    ObjectArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    T value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                Object[] data = new Object[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MemFreeMergeSortAction<T>
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        T[] array;
        int from;
        int to;

        MemFreeMergeSortAction(T[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                ObjectArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortAction.invokeAll(new MemFreeMergeSortAction<T>(this.array, this.from, mid), new MemFreeMergeSortAction<T>(this.array, mid, this.to));
            if (((Comparable)this.array[mid - 1]).compareTo(this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int comp = ((Comparable)this.array[i]).compareTo(this.array[j]);
                if (comp < 0) {
                    ++i;
                    continue;
                }
                if (comp == 0) {
                    ObjectArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && ((Comparable)this.array[i]).compareTo(this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    ObjectArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    T value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                Object[] data = new Object[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MergeSortActionComp<T>
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        T[] array;
        T[] supp;
        int from;
        int to;
        Comparator<T> comp;

        MergeSortActionComp(T[] array, T[] supp, int from, int to, Comparator<T> comp) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                ObjectArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortActionComp.invokeAll(new MergeSortActionComp<T>(this.supp, this.array, this.from, mid, this.comp), new MergeSortActionComp<T>(this.supp, this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && this.comp.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class MergeSortAction<T>
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        T[] array;
        T[] supp;
        int from;
        int to;

        MergeSortAction(T[] array, T[] supp, int from, int to) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                ObjectArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortAction.invokeAll(new MergeSortAction<T>(this.supp, this.array, this.from, mid), new MergeSortAction<T>(this.supp, this.array, mid, this.to));
            if (((Comparable)this.supp[mid - 1]).compareTo(this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && ((Comparable)this.supp[p]).compareTo(this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class QuickSortActionComp<T>
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        T[] array;
        int from;
        int to;
        Comparator<T> comp;

        QuickSortActionComp(T[] array, int from, int to, Comparator<T> comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                ObjectArrays.selectionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            T pivot = this.array[length > 128 ? ObjectArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8, this.comp) : ObjectArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1, this.comp)];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int compare;
                if (b <= c && (compare = this.comp.compare(this.array[b], pivot)) <= 0) {
                    if (compare == 0) {
                        ObjectArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (compare = this.comp.compare(this.array[c], pivot)) >= 0) {
                    if (compare == 0) {
                        ObjectArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                ObjectArrays.swap(this.array, b++, c--);
            }
            ObjectArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            ObjectArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortActionComp.invokeAll(new QuickSortActionComp<T>(this.array, this.from, this.from + (b - a), this.comp), new QuickSortActionComp<T>(this.array, this.to - (d - c), this.to, this.comp));
            } else if (b - a > 1) {
                new QuickSortActionComp<T>(this.array, this.from, this.from + (b - a), this.comp).invoke();
            } else if (d - c > 1) {
                new QuickSortActionComp<T>(this.array, this.to - (d - c), this.to, this.comp).invoke();
            }
        }
    }

    static class QuickSortAction<T>
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        T[] array;
        int from;
        int to;

        QuickSortAction(T[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                ObjectArrays.selectionSort(this.array, this.from, this.to);
                return;
            }
            T pivot = this.array[length > 128 ? ObjectArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8) : ObjectArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1)];
            int b = a = this.from;
            int d = c = this.to - 1;
            int comp = 0;
            while (true) {
                if (b <= c && (comp = ((Comparable)this.array[b]).compareTo(pivot)) <= 0) {
                    if (comp == 0) {
                        ObjectArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comp = ((Comparable)this.array[c]).compareTo(pivot)) >= 0) {
                    if (comp == 0) {
                        ObjectArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                ObjectArrays.swap(this.array, b++, c--);
            }
            ObjectArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            ObjectArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortAction.invokeAll(new QuickSortAction<T>(this.array, this.from, this.from + (b - a)), new QuickSortAction<T>(this.array, this.to - (d - c), this.to));
            } else if (b - a > 1) {
                new QuickSortAction<T>(this.array, this.from, this.from + (b - a)).invoke();
            } else if (d - c > 1) {
                new QuickSortAction<T>(this.array, this.to - (d - c), this.to).invoke();
            }
        }
    }
}

