/*
 * Decompiled with CFR 0.152.
 */
package openmods.shapes;

import openmods.shapes.DefaultShapeGenerator;
import openmods.shapes.IShapeable;
import openmods.utils.render.GeometryUtils;

public class ShapeCuboidGenerator
extends DefaultShapeGenerator {
    private final boolean corners;
    private final boolean edges;
    private final boolean walls;

    public ShapeCuboidGenerator(boolean corners, boolean edges, boolean walls) {
        this.corners = corners;
        this.edges = edges;
        this.walls = walls;
    }

    public ShapeCuboidGenerator(Elements elements) {
        this(elements.corners, elements.edges, elements.walls);
    }

    public ShapeCuboidGenerator() {
        this(Elements.WALLS);
    }

    @Override
    public void generateShape(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IShapeable shapeable) {
        int dx = maxX - minX - 2;
        int dy = maxY - minY - 2;
        int dz = maxZ - minZ - 2;
        if (this.corners) {
            shapeable.setBlock(maxX, maxY, maxZ);
            shapeable.setBlock(maxX, maxY, minZ);
            shapeable.setBlock(maxX, minY, maxZ);
            shapeable.setBlock(maxX, minY, minZ);
            shapeable.setBlock(minX, maxY, maxZ);
            shapeable.setBlock(minX, maxY, minZ);
            shapeable.setBlock(minX, minY, maxZ);
            shapeable.setBlock(minX, minY, minZ);
        }
        if (this.edges) {
            GeometryUtils.makeLine(minX, minY + 1, minZ, GeometryUtils.Axis.Y, dy, shapeable);
            GeometryUtils.makeLine(minX, minY + 1, maxZ, GeometryUtils.Axis.Y, dy, shapeable);
            GeometryUtils.makeLine(maxX, minY + 1, maxZ, GeometryUtils.Axis.Y, dy, shapeable);
            GeometryUtils.makeLine(maxX, minY + 1, minZ, GeometryUtils.Axis.Y, dy, shapeable);
            GeometryUtils.makeLine(minX + 1, minY, minZ, GeometryUtils.Axis.X, dx, shapeable);
            GeometryUtils.makeLine(minX + 1, minY, maxZ, GeometryUtils.Axis.X, dx, shapeable);
            GeometryUtils.makeLine(minX + 1, maxY, maxZ, GeometryUtils.Axis.X, dx, shapeable);
            GeometryUtils.makeLine(minX + 1, maxY, minZ, GeometryUtils.Axis.X, dx, shapeable);
            GeometryUtils.makeLine(minX, minY, minZ + 1, GeometryUtils.Axis.Z, dz, shapeable);
            GeometryUtils.makeLine(minX, maxY, minZ + 1, GeometryUtils.Axis.Z, dz, shapeable);
            GeometryUtils.makeLine(maxX, maxY, minZ + 1, GeometryUtils.Axis.Z, dz, shapeable);
            GeometryUtils.makeLine(maxX, minY, minZ + 1, GeometryUtils.Axis.Z, dz, shapeable);
        }
        if (this.walls) {
            GeometryUtils.makePlane(minX + 1, minY + 1, minZ, dx, dy, GeometryUtils.Axis.X, GeometryUtils.Axis.Y, shapeable);
            GeometryUtils.makePlane(minX + 1, minY + 1, maxZ, dx, dy, GeometryUtils.Axis.X, GeometryUtils.Axis.Y, shapeable);
            GeometryUtils.makePlane(minX + 1, minY, minZ + 1, dx, dz, GeometryUtils.Axis.X, GeometryUtils.Axis.Z, shapeable);
            GeometryUtils.makePlane(minX + 1, maxY, minZ + 1, dx, dz, GeometryUtils.Axis.X, GeometryUtils.Axis.Z, shapeable);
            GeometryUtils.makePlane(minX, minY + 1, minZ + 1, dy, dz, GeometryUtils.Axis.Y, GeometryUtils.Axis.Z, shapeable);
            GeometryUtils.makePlane(maxX, minY + 1, minZ + 1, dy, dz, GeometryUtils.Axis.Y, GeometryUtils.Axis.Z, shapeable);
        }
    }

    public static enum Elements {
        CORNERS(true, false, false),
        EDGES(true, true, false),
        WALLS(true, true, true);

        private final boolean corners;
        private final boolean edges;
        private final boolean walls;

        private Elements(boolean corners, boolean edges, boolean walls) {
            this.corners = corners;
            this.edges = edges;
            this.walls = walls;
        }
    }
}

