/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadSafeBitSet {
    public static final int DEFAULT_LOG2_SEGMENT_SIZE_IN_BITS = 14;
    private final int numLongsPerSegment;
    private final int log2SegmentSize;
    private final int segmentMask;
    private final AtomicReference<ThreadSafeBitSetSegments> segments;

    public ThreadSafeBitSet() {
        this(14);
    }

    public ThreadSafeBitSet(int log2SegmentSizeInBits) {
        this(log2SegmentSizeInBits, 0);
    }

    public ThreadSafeBitSet(int log2SegmentSizeInBits, int numBitsToPreallocate) {
        if (log2SegmentSizeInBits < 6) {
            throw new IllegalArgumentException("Cannot specify fewer than 64 bits in each segment!");
        }
        this.log2SegmentSize = log2SegmentSizeInBits;
        this.numLongsPerSegment = 1 << log2SegmentSizeInBits - 6;
        this.segmentMask = this.numLongsPerSegment - 1;
        long numBitsPerSegment = this.numLongsPerSegment * 64;
        int numSegmentsToPreallocate = numBitsToPreallocate == 0 ? 1 : (int)((long)(numBitsToPreallocate - 1) / numBitsPerSegment + 1L);
        this.segments = new AtomicReference();
        this.segments.set(new ThreadSafeBitSetSegments(numSegmentsToPreallocate, this.numLongsPerSegment));
    }

    public void set(int position) {
        long newLongValue;
        long currentLongValue;
        int segmentPosition = position >>> this.log2SegmentSize;
        int longPosition = position >>> 6 & this.segmentMask;
        int bitPosition = position & 0x3F;
        AtomicLongArray segment = this.getSegment(segmentPosition);
        long mask = 1L << bitPosition;
        while (!segment.compareAndSet(longPosition, currentLongValue = segment.get(longPosition), newLongValue = currentLongValue | mask)) {
        }
    }

    public void clear(int position) {
        long newLongValue;
        long currentLongValue;
        int segmentPosition = position >>> this.log2SegmentSize;
        int longPosition = position >>> 6 & this.segmentMask;
        int bitPosition = position & 0x3F;
        AtomicLongArray segment = this.getSegment(segmentPosition);
        long mask = 1L << bitPosition ^ 0xFFFFFFFFFFFFFFFFL;
        while (!segment.compareAndSet(longPosition, currentLongValue = segment.get(longPosition), newLongValue = currentLongValue & mask)) {
        }
    }

    public boolean get(int position) {
        int segmentPosition = position >>> this.log2SegmentSize;
        int longPosition = position >>> 6 & this.segmentMask;
        int bitPosition = position & 0x3F;
        AtomicLongArray segment = this.getSegment(segmentPosition);
        long mask = 1L << bitPosition;
        return (segment.get(longPosition) & mask) != 0L;
    }

    public long maxSetBit() {
        ThreadSafeBitSetSegments segments = this.segments.get();
        for (int segmentIdx = segments.numSegments() - 1; segmentIdx >= 0; --segmentIdx) {
            AtomicLongArray segment = segments.getSegment(segmentIdx);
            for (int longIdx = segment.length() - 1; longIdx >= 0; --longIdx) {
                long l = segment.get(longIdx);
                if (l == 0L) continue;
                return (segmentIdx << this.log2SegmentSize) + longIdx * 64 + (63 - Long.numberOfLeadingZeros(l));
            }
        }
        return -1L;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int segmentPosition = fromIndex >>> this.log2SegmentSize;
        ThreadSafeBitSetSegments segments = this.segments.get();
        if (segmentPosition >= segments.numSegments()) {
            return -1;
        }
        int longPosition = fromIndex >>> 6 & this.segmentMask;
        int bitPosition = fromIndex & 0x3F;
        AtomicLongArray segment = segments.getSegment(segmentPosition);
        long word = segment.get(longPosition) & -1L << bitPosition;
        while (word == 0L) {
            if (++longPosition > this.segmentMask) {
                if (++segmentPosition >= segments.numSegments()) {
                    return -1;
                }
                segment = segments.getSegment(segmentPosition);
                longPosition = 0;
            }
            word = segment.get(longPosition);
        }
        return (segmentPosition << this.log2SegmentSize) + (longPosition << 6) + Long.numberOfTrailingZeros(word);
    }

    public int cardinality() {
        ThreadSafeBitSetSegments segments = this.segments.get();
        int numSetBits = 0;
        for (int i = 0; i < segments.numSegments(); ++i) {
            AtomicLongArray segment = segments.getSegment(i);
            for (int j = 0; j < segment.length(); ++j) {
                numSetBits += Long.bitCount(segment.get(j));
            }
        }
        return numSetBits;
    }

    public int currentCapacity() {
        return this.segments.get().numSegments() * (1 << this.log2SegmentSize);
    }

    public void clearAll() {
        ThreadSafeBitSetSegments segments = this.segments.get();
        for (int i = 0; i < segments.numSegments(); ++i) {
            AtomicLongArray segment = segments.getSegment(i);
            for (int j = 0; j < segment.length(); ++j) {
                segment.set(j, 0L);
            }
        }
    }

    public ThreadSafeBitSet andNot(ThreadSafeBitSet other) {
        if (other.log2SegmentSize != this.log2SegmentSize) {
            throw new IllegalArgumentException("Segment sizes must be the same");
        }
        ThreadSafeBitSetSegments thisSegments = this.segments.get();
        ThreadSafeBitSetSegments otherSegments = other.segments.get();
        ThreadSafeBitSetSegments newSegments = new ThreadSafeBitSetSegments(thisSegments.numSegments(), this.numLongsPerSegment);
        for (int i = 0; i < thisSegments.numSegments(); ++i) {
            AtomicLongArray thisArray = thisSegments.getSegment(i);
            AtomicLongArray otherArray = i < otherSegments.numSegments() ? otherSegments.getSegment(i) : null;
            AtomicLongArray newArray = newSegments.getSegment(i);
            for (int j = 0; j < thisArray.length(); ++j) {
                long thisLong = thisArray.get(j);
                long otherLong = otherArray == null ? 0L : otherArray.get(j);
                newArray.set(j, thisLong & (otherLong ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        ThreadSafeBitSet andNot = new ThreadSafeBitSet(this.log2SegmentSize);
        andNot.segments.set(newSegments);
        return andNot;
    }

    public static ThreadSafeBitSet orAll(ThreadSafeBitSet ... bitSets) {
        if (bitSets.length == 0) {
            return new ThreadSafeBitSet();
        }
        int log2SegmentSize = bitSets[0].log2SegmentSize;
        int numLongsPerSegment = bitSets[0].numLongsPerSegment;
        ThreadSafeBitSetSegments[] segments = new ThreadSafeBitSetSegments[bitSets.length];
        int maxNumSegments = 0;
        for (int i = 0; i < bitSets.length; ++i) {
            if (bitSets[i].log2SegmentSize != log2SegmentSize) {
                throw new IllegalArgumentException("Segment sizes must be the same");
            }
            segments[i] = bitSets[i].segments.get();
            if (segments[i].numSegments() <= maxNumSegments) continue;
            maxNumSegments = segments[i].numSegments();
        }
        ThreadSafeBitSetSegments newSegments = new ThreadSafeBitSetSegments(maxNumSegments, numLongsPerSegment);
        AtomicLongArray[] segment = new AtomicLongArray[segments.length];
        for (int i = 0; i < maxNumSegments; ++i) {
            for (int j = 0; j < segments.length; ++j) {
                segment[j] = i < segments[j].numSegments() ? segments[j].getSegment(i) : null;
            }
            AtomicLongArray newSegment = newSegments.getSegment(i);
            for (int j = 0; j < numLongsPerSegment; ++j) {
                long value = 0L;
                for (int k = 0; k < segments.length; ++k) {
                    if (segment[k] == null) continue;
                    value |= segment[k].get(j);
                }
                newSegment.set(j, value);
            }
        }
        ThreadSafeBitSet or = new ThreadSafeBitSet(log2SegmentSize);
        or.segments.set(newSegments);
        return or;
    }

    private AtomicLongArray getSegment(int segmentIndex) {
        ThreadSafeBitSetSegments visibleSegments = this.segments.get();
        while (visibleSegments.numSegments() <= segmentIndex) {
            ThreadSafeBitSetSegments newVisibleSegments = new ThreadSafeBitSetSegments(visibleSegments, segmentIndex + 1, this.numLongsPerSegment);
            if (this.segments.compareAndSet(visibleSegments, newVisibleSegments)) {
                visibleSegments = newVisibleSegments;
                continue;
            }
            visibleSegments = this.segments.get();
        }
        return visibleSegments.getSegment(segmentIndex);
    }

    public void serializeBitsTo(DataOutputStream os) throws IOException {
        ThreadSafeBitSetSegments segments = this.segments.get();
        os.writeInt(segments.numSegments() * this.numLongsPerSegment);
        for (int i = 0; i < segments.numSegments(); ++i) {
            AtomicLongArray arr = segments.getSegment(i);
            for (int j = 0; j < arr.length(); ++j) {
                os.writeLong(arr.get(j));
            }
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof ThreadSafeBitSet)) {
            return false;
        }
        ThreadSafeBitSet other = (ThreadSafeBitSet)obj;
        if (other.log2SegmentSize != this.log2SegmentSize) {
            throw new IllegalArgumentException("Segment sizes must be the same");
        }
        ThreadSafeBitSetSegments thisSegments = this.segments.get();
        ThreadSafeBitSetSegments otherSegments = other.segments.get();
        for (i = 0; i < thisSegments.numSegments(); ++i) {
            AtomicLongArray thisArray = thisSegments.getSegment(i);
            AtomicLongArray otherArray = i < otherSegments.numSegments() ? otherSegments.getSegment(i) : null;
            for (int j = 0; j < thisArray.length(); ++j) {
                long otherLong;
                long thisLong = thisArray.get(j);
                long l = otherLong = otherArray == null ? 0L : otherArray.get(j);
                if (thisLong == otherLong) continue;
                return false;
            }
        }
        for (i = thisSegments.numSegments(); i < otherSegments.numSegments(); ++i) {
            AtomicLongArray otherArray = otherSegments.getSegment(i);
            for (int j = 0; j < otherArray.length(); ++j) {
                long l = otherArray.get(j);
                if (l == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.log2SegmentSize;
        result = 31 * result + Arrays.hashCode(this.segments.get().segments);
        return result;
    }

    public BitSet toBitSet() {
        BitSet resultSet = new BitSet();
        int ordinal = this.nextSetBit(0);
        while (ordinal != -1) {
            resultSet.set(ordinal);
            ordinal = this.nextSetBit(ordinal + 1);
        }
        return resultSet;
    }

    public String toString() {
        return this.toBitSet().toString();
    }

    private static class ThreadSafeBitSetSegments {
        private final AtomicLongArray[] segments;

        private ThreadSafeBitSetSegments(int numSegments, int segmentLength) {
            AtomicLongArray[] segments = new AtomicLongArray[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                segments[i] = new AtomicLongArray(segmentLength);
            }
            this.segments = segments;
        }

        private ThreadSafeBitSetSegments(ThreadSafeBitSetSegments copyFrom, int numSegments, int segmentLength) {
            AtomicLongArray[] segments = new AtomicLongArray[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                segments[i] = i < copyFrom.numSegments() ? copyFrom.getSegment(i) : new AtomicLongArray(segmentLength);
            }
            this.segments = segments;
        }

        public int numSegments() {
            return this.segments.length;
        }

        public AtomicLongArray getSegment(int index) {
            return this.segments[index];
        }
    }
}

