/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.Widget;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.StackInfo;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemHistoryPanel
extends Widget {
    protected int mouseDownSlot = -1;
    protected ItemsGrid grid = new ItemsGrid();

    @Override
    public void draw(int mousex, int mousey) {
        if (NEIClientConfig.getIntSetting("inventory.history.splittingMode") == 0) {
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)NEIClientConfig.getSetting("inventory.history.historyColor").getHexValue());
        } else {
            this.drawSplittingArea(this.x, this.y, this.w, this.h, NEIClientConfig.getSetting("inventory.history.historyColor").getHexValue());
        }
        this.grid.draw(mousex, mousey);
    }

    @Override
    public void update() {
        this.grid.update();
    }

    public void addItem(ItemStack stack) {
        if (stack != null) {
            ItemStack is = StackInfo.loadFromNBT(StackInfo.itemStackToNBT(stack), 0L);
            this.grid.realItems.removeIf(historyStack -> StackInfo.equalItemAndNBT(historyStack, stack, true));
            this.grid.realItems.add(0, is);
            if (this.grid.realItems.size() > this.grid.rows * this.grid.columns) {
                this.grid.realItems.remove(this.grid.rows * this.grid.columns);
            }
            this.grid.onItemsChanged();
        }
    }

    public void resize(GuiContainer gui) {
        this.grid.setGridSize(this.x, this.y, this.w, this.h);
        this.grid.refresh(gui);
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.item;
    }

    public ItemPanel.ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        return this.grid.getSlotMouseOver(mousex, mousey);
    }

    private void drawSplittingArea(int x, int y, int width, int height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2852);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glLineWidth((float)2.0f);
        GL11.glLineStipple((int)2, (short)255);
        GL11.glBegin((int)2);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
        GL11.glLineStipple((int)1, (short)-1);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)2852);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        ItemPanel.ItemPanelSlot mouseOverSlot;
        if (this.mouseDownSlot >= 0 && ItemPanels.itemPanel.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && ((mouseOverSlot = this.getSlotMouseOver(mousex, mousey)) == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
            ItemPanels.itemPanel.draggedStack = this.getDraggedStackWithQuantity(this.mouseDownSlot);
            this.mouseDownSlot = -1;
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleClickExt(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            if (!this.grid.contains(mousex, mousey)) {
                return false;
            }
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanel.ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                if (hoverSlot.item != null) {
                    ItemPanels.itemPanel.draggedStack = this.getDraggedStackWithQuantity(hoverSlot.slotIndex);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanel.ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && ItemPanels.itemPanel.draggedStack == null) {
            ItemStack item = hoverSlot.item.func_77946_l();
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canCheatItem(item)) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(this.getDraggedStackWithQuantity(hoverSlot.slotIndex), button, -1);
        }
        this.mouseDownSlot = -1;
    }

    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack != null) {
            int amount;
            int n = amount = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
            return NEIServerUtils.copyStack(stack, amount);
        }
        return null;
    }
}

