/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.OffsetPositioner;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.BrewingOverlayHandler;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.FireworkRecipeHandler;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.ItemsHistoryHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import com.google.common.base.Objects;
import java.util.HashMap;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiInventory;

public class RecipeInfo {
    static final HashMap<OverlayKey, IOverlayHandler> overlayMap = new HashMap();
    static final HashMap<OverlayKey, IStackPositioner> positionerMap = new HashMap();
    static final HashMap<Class<? extends GuiContainer>, int[]> offsets = new HashMap();

    public static void registerOverlayHandler(Class<? extends GuiContainer> classz, IOverlayHandler handler, String ident) {
        overlayMap.put(new OverlayKey(classz, ident), handler);
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident, IStackPositioner positioner) {
        positionerMap.put(new OverlayKey(classz, ident), positioner);
        if (positioner instanceof OffsetPositioner && !offsets.containsKey(classz)) {
            OffsetPositioner p = (OffsetPositioner)positioner;
            RecipeInfo.setGuiOffset(classz, p.offsetx, p.offsety);
        }
    }

    public static void setGuiOffset(Class<? extends GuiContainer> classz, int x, int y) {
        offsets.put(classz, new int[]{x, y});
    }

    public static boolean hasDefaultOverlay(GuiContainer gui, String ident) {
        return positionerMap.containsKey(new OverlayKey(gui.getClass(), ident));
    }

    public static boolean hasOverlayHandler(GuiContainer gui, String ident) {
        return overlayMap.containsKey(new OverlayKey(gui.getClass(), ident));
    }

    public static boolean hasOverlayHandler(Class<? extends GuiContainer> classz, String ident) {
        return overlayMap.containsKey(new OverlayKey(classz, ident));
    }

    public static IOverlayHandler getOverlayHandler(GuiContainer gui, String ident) {
        return overlayMap.get(new OverlayKey(gui.getClass(), ident));
    }

    public static IStackPositioner getStackPositioner(GuiContainer gui, String ident) {
        return positionerMap.get(new OverlayKey(gui.getClass(), ident));
    }

    public static int[] getGuiOffset(GuiContainer gui) {
        int[] nArray;
        int[] offset = offsets.get(gui.getClass());
        if (offset == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = 5;
            nArray = nArray2;
            nArray2[1] = 11;
        } else {
            nArray = offset;
        }
        return nArray;
    }

    public static void load() {
        API.registerRecipeHandler(new ShapedRecipeHandler());
        API.registerUsageHandler(new ShapedRecipeHandler());
        API.registerRecipeHandler(new ShapelessRecipeHandler());
        API.registerUsageHandler(new ShapelessRecipeHandler());
        API.registerRecipeHandler(new FireworkRecipeHandler());
        API.registerUsageHandler(new FireworkRecipeHandler());
        API.registerRecipeHandler(new FurnaceRecipeHandler());
        API.registerUsageHandler(new FurnaceRecipeHandler());
        API.registerRecipeHandler(new BrewingRecipeHandler());
        API.registerUsageHandler(new BrewingRecipeHandler());
        API.registerRecipeHandler(new FuelRecipeHandler());
        API.registerUsageHandler(new FuelRecipeHandler());
        API.registerGuiOverlay(GuiCrafting.class, "crafting");
        API.registerGuiOverlay(GuiInventory.class, "crafting2x2", 63, 20);
        API.registerGuiOverlay(GuiFurnace.class, "smelting");
        API.registerGuiOverlay(GuiFurnace.class, "fuel");
        API.registerGuiOverlay(GuiBrewingStand.class, "brewing");
        API.registerGuiOverlayHandler(GuiCrafting.class, new DefaultOverlayHandler(), "crafting");
        API.registerGuiOverlayHandler(GuiInventory.class, new DefaultOverlayHandler(63, 20), "crafting2x2");
        API.registerGuiOverlayHandler(GuiBrewingStand.class, new BrewingOverlayHandler(), "brewing");
        API.registerRecipeHandler(new ProfilerRecipeHandler(true));
        API.registerUsageHandler(new ProfilerRecipeHandler(false));
        API.registerRecipeHandler(new ItemsHistoryHandler());
        API.registerUsageHandler(new ItemsHistoryHandler());
    }

    private static class OverlayKey {
        final String ident;
        final Class<? extends GuiContainer> guiClass;

        public OverlayKey(Class<? extends GuiContainer> classz, String ident) {
            this.guiClass = classz;
            this.ident = ident;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverlayKey)) {
                return false;
            }
            OverlayKey key = (OverlayKey)obj;
            return Objects.equal((Object)this.ident, (Object)key.ident) && this.guiClass == key.guiClass;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ident, this.guiClass});
        }
    }
}

