/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.info.IC2Classic;
import ic2.api.item.IC2Items;
import ic2.api.util.Keys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.handlers.ClassicInfoLoader;
import speiger.src.crops.handlers.ExpInfoLoader;
import speiger.src.crops.inventory.BreedingContainer;
import speiger.src.crops.inventory.CropList;
import speiger.src.crops.inventory.GuiBreeding;
import speiger.src.crops.prediction.Breeder;
import speiger.src.crops.prediction.NEIPlugin;

@Mod(modid="Ic2Nei", name="IC2 Crop Plugin", version="1.2.1", dependencies="required-after:IC2")
public class IC2NeiPlugin {
    @Mod.Instance(value="Ic2Nei")
    public static IC2NeiPlugin INSTANCE;
    public static final CropList CROP_LIST;
    public static final CropList RESULT_LIST;
    public boolean loaded = false;
    public static Map<CropCard, ItemStack> DISPLAY_ITEMS;
    public static List<CropCard> ALL_CROPS;
    public static ItemStack ANALYZER;
    public static int CROP_STICKS;

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void load(FMLPreInitializationEvent event) {
        try {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            config.load();
            CROP_STICKS = MathHelper.func_76125_a((int)config.get("general", "simulationlevel", 4, "Decides how many crops are being used in the simulation. 2-4 (default=4)").getInt(), (int)2, (int)4);
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IC2Classic.IC2Type type = IC2Classic.getLoadedIC2Type();
        if (type == IC2Classic.IC2Type.Experimental) {
            CropPluginAPI.instance.registerCropInfo(new ExpInfoLoader());
            this.loaded = true;
        }
        if (type == IC2Classic.IC2Type.SpeigersClassic) {
            CropPluginAPI.instance.registerCropInfo(new ClassicInfoLoader());
            this.loaded = true;
        }
        if (type == IC2Classic.IC2Type.None) {
            event.getModLog().info("Plugin does not load because you have IC2 Not installed or the Version is Invalid");
        }
        ANALYZER = IC2Items.getItem((String)"cropnalyzer");
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void modsLoaded(FMLLoadCompleteEvent event) {
        if (this.loaded) {
            this.load();
            MinecraftForge.EVENT_BUS.register((Object)this);
            FMLCommonHandler.instance().bus().register((Object)this);
            Breeder.INSTANCE.load();
            NEIPlugin plugin = new NEIPlugin();
            API.registerRecipeHandler((ICraftingHandler)plugin);
            API.registerUsageHandler((IUsageHandler)plugin);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void load() {
        ItemStack item = IC2Items.getItem((String)"cropSeed");
        if (item != null) {
            ArrayList items = new ArrayList();
            item.func_77973_b().func_150895_a(item.func_77973_b(), CreativeTabs.field_78027_g, items);
            for (ItemStack stack : items) {
                stack = stack.func_77946_l();
                CropCard card = Crops.instance.getCropCard(stack);
                CropPluginAPI.storeCrop(stack, card);
                DISPLAY_ITEMS.put(card, stack);
            }
        }
        ArrayList<CropCard> crops = new ArrayList<CropCard>(Crops.instance.getCrops());
        crops.remove(Crops.weed);
        ArrayList<CropCard> fixedCrops = new ArrayList<CropCard>();
        for (int i = 0; i < crops.size(); ++i) {
            if (crops.get(i) == null) continue;
            fixedCrops.add((CropCard)crops.get(i));
        }
        ALL_CROPS = new ArrayList<CropCard>(fixedCrops);
        CropPluginAPI.instance.load(DISPLAY_ITEMS, IC2Classic.getLoadedIC2Type());
        CROP_LIST.setCropList(fixedCrops);
    }

    public boolean isItem(ItemStack toCheck) {
        if (ANALYZER == null || toCheck == null) {
            return false;
        }
        return toCheck.func_77973_b() == ANALYZER.func_77973_b();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        if (!Keys.instance.isSideinventoryKeyDown(player)) {
            return;
        }
        if (!this.isItem(player.func_71045_bC())) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiBreeding) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBreeding(new BreedingContainer()));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemToolTip(ItemTooltipEvent event) {
        CropCard card;
        if (this.isItem(event.itemStack)) {
            event.toolTip.add("Press Side Inventory (" + this.getBinding() + ") to view Breeding Calculator");
        }
        if ((card = CropPluginAPI.getCrop(event.itemStack)) != null) {
            List<String> infos = CropPluginAPI.instance.getExtraInfos(card);
            if (infos.isEmpty()) {
                return;
            }
            if (GuiScreen.func_146271_m()) {
                event.toolTip.add(StatCollector.func_74838_a((String)"info.extraCropInfo.name"));
                event.toolTip.add("");
                event.toolTip.addAll(infos);
            } else {
                event.toolTip.add(StatCollector.func_74838_a((String)"info.extraCropInfoKey.name"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String getBinding() {
        ArrayList bindings = new ArrayList();
        try {
            bindings.addAll((List)ReflectionHelper.getPrivateValue(KeyBinding.class, null, (int)0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (KeyBinding bind : bindings) {
            if (!bind.func_151464_g().equalsIgnoreCase("Side Inventory Key")) continue;
            return GameSettings.func_74298_c((int)bind.func_151463_i());
        }
        return "Unknown";
    }

    static {
        CROP_LIST = new CropList();
        RESULT_LIST = new CropList();
        DISPLAY_ITEMS = new HashMap<CropCard, ItemStack>();
        ALL_CROPS = new ArrayList<CropCard>();
        CROP_STICKS = 4;
    }
}

