/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.util;

import com.gtnh.findit.service.blockfinder.BlockFoundResponse;
import com.gtnh.findit.util.AxisUtils;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;

public class ClientFinderHelperUtils {
    public static void lookAtTarget(EntityClientPlayerMP player, BlockFoundResponse response) {
        ClientFinderHelperUtils.rotateViewHelper(player, response.getPositions());
    }

    public static void rotateViewHelper(EntityClientPlayerMP player, List<ChunkPosition> targets) {
        Vec3 playerVec = player.func_70666_h(1.0f);
        Vec3 first = ClientFinderHelperUtils.center(ClientFinderHelperUtils.getNearBlock(playerVec, targets));
        AxisUtils.AxisPair pair = AxisUtils.calculateAxisPair(playerVec, first);
        player.field_70177_z = pair.yaw();
        player.field_70125_A = pair.pitch();
    }

    public static Vec3 center(ChunkPosition p) {
        return Vec3.func_72443_a((double)((double)p.field_151329_a + 0.5), (double)((double)p.field_151327_b + 0.5), (double)((double)p.field_151328_c + 0.5));
    }

    private static ChunkPosition getNearBlock(Vec3 player, List<ChunkPosition> targets) {
        ChunkPosition result = null;
        double minDistance = Double.MAX_VALUE;
        for (ChunkPosition target : targets) {
            double distance = ClientFinderHelperUtils.getDistance(player, target);
            if (!(distance < minDistance)) continue;
            result = target;
            minDistance = distance;
        }
        return result;
    }

    private static double getDistance(Vec3 player, ChunkPosition target) {
        double deltaX = (double)target.field_151329_a - player.field_72450_a;
        double deltaY = (double)target.field_151327_b - player.field_72448_b;
        double deltaZ = (double)target.field_151328_c - player.field_72449_c;
        return Math.sqrt(deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY);
    }
}

