/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.AccessibilitySettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.AdvancedSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.BiomeSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.DimensionSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.DisplaySettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.GeneralSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.ServerSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.StatusMessagesGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.ScrollableTextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.class_388;

public class MainGui
extends ConfigurationGui<Config> {
    private final Config INSTANCE;
    private final Config DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl biomeSet;
    private ExtendedButtonControl dimensionSet;
    private ExtendedButtonControl serverSet;

    public MainGui(class_388 parentScreen) {
        super(parentScreen, "gui.config.title");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int currentY = -1;
        String releaseNotice = "";
        if ("Release".equalsIgnoreCase("alpha")) {
            releaseNotice = Constants.TRANSLATOR.translate("gui.config.message.tentative", "v2.3.9");
        } else if (!ModUtils.MCVersion.equalsIgnoreCase("1.7.10")) {
            releaseNotice = Constants.TRANSLATOR.translate("gui.config.message.version_difference", ModUtils.MCVersion, "1.7.10");
        }
        if (!StringUtils.isNullOrEmpty(releaseNotice)) {
            this.childFrame.addWidget(new ScrollableTextWidget(this.childFrame, true, 0, this.getButtonY(++currentY), this.childFrame.getScreenWidth(), releaseNotice));
        }
        this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, "gui.config.title.general", () -> this.openScreen(new GeneralSettingsGui(this.currentScreen)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.title.general", new Object[0]))), new String[0]));
        this.biomeSet = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, "gui.config.title.biome_messages", () -> this.openScreen(new BiomeSettingsGui(this.currentScreen)), () -> {
            if (!this.biomeSet.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))));
            }
        }, new String[0]));
        this.dimensionSet = this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, "gui.config.title.dimension_messages", () -> this.openScreen(new DimensionSettingsGui(this.currentScreen)), () -> {
            if (!this.dimensionSet.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))));
            }
        }, new String[0]));
        this.serverSet = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, "gui.config.title.server_messages", () -> this.openScreen(new ServerSettingsGui(this.currentScreen)), () -> {
            if (!this.serverSet.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player."))));
            }
        }, new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, "gui.config.title.status_messages", () -> this.openScreen(new StatusMessagesGui(this.currentScreen)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.title.status_messages", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, "gui.config.title.advanced", () -> this.openScreen(new AdvancedSettingsGui(this.currentScreen)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.title.advanced", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, "gui.config.title.accessibility", () -> this.openScreen(new AccessibilitySettingsGui(this.currentScreen)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.title.accessibility", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, "gui.config.title.display_settings", () -> this.openScreen(new DisplaySettingsGui(this.currentScreen)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.display_settings", new Object[0]))), new String[0]));
    }

    @Override
    protected void method_1024(char typedChar, int keyCode) {
        if (keyCode == 1 && this.getCurrentData().hasChanged) {
            this.syncData();
        }
        super.method_1024(typedChar, keyCode);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.getCurrentData().hasChanged = this.hasChangesBetween(this.getCurrentData(), this.getInstanceData());
        this.biomeSet.setControlEnabled(CraftPresence.BIOMES.enabled);
        this.dimensionSet.setControlEnabled(CraftPresence.DIMENSIONS.enabled);
        this.serverSet.setControlEnabled(CraftPresence.SERVER.enabled);
        this.proceedButton.setControlMessage(this.getCurrentData().hasChanged ? "gui.config.message.button.save" : "gui.config.message.button.back");
    }

    @Override
    protected boolean canReset() {
        return this.allowedToReset() && this.hasChangesBetween(this.getCurrentData(), this.getDefaultData());
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.getDefaultData());
    }

    @Override
    protected void applySettings() {
        if (this.getCurrentData().hasChanged) {
            this.getCurrentData().save();
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
            this.getCurrentData().applyFrom(this.getInstanceData());
        }
    }

    @Override
    protected Config getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Config getCurrentData() {
        return CraftPresence.CONFIG;
    }

    @Override
    protected Config getDefaultData() {
        this.DEFAULTS.displaySettings.dynamicIcons = this.getCurrentData().displaySettings.dynamicIcons;
        return this.DEFAULTS;
    }

    @Override
    protected Config getSyncData() {
        return Config.loadOrCreate();
    }
}

