/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.ModUpdaterUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.realms.RealmsSharedConstants;

public class ModUtils {
    public static final String MCVersion = RealmsSharedConstants.VERSION_STRING;
    public static final int MCProtocolID = RealmsSharedConstants.NETWORK_PROTOCOL_VERSION;
    public static final String BRAND = ModUtils.findGameBrand();
    public static final boolean IS_LEGACY_HARD = Constants.IS_LEGACY_SOFT && MCProtocolID <= 61;
    public static final boolean IS_LEGACY_ALPHA = IS_LEGACY_HARD && MCProtocolID <= 2;
    public static final ModUpdaterUtils UPDATER = new ModUpdaterUtils("craftpresence", "https://raw.githubusercontent.com/CDAGaming/VersionLibrary/master/CraftPresence/update.json", "v2.3.9", MCVersion);
    public static final TranslationUtils RAW_TRANSLATOR = ModUtils.findGameTranslations();
    public static final boolean IS_TEXT_FORMATTING_BLOCKED = Constants.IS_LEGACY_SOFT && MCProtocolID <= 23;

    private static String findGameBrand() {
        String result = null;
        try {
            result = System.getProperty("minecraft.launcher.brand");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return StringUtils.getOrDefault(result, ClientBrandRetriever.getClientModName());
    }

    private static TranslationUtils findGameTranslations() {
        boolean hasVanillaTranslations;
        boolean bl = hasVanillaTranslations = !Constants.IS_LEGACY_SOFT || MCProtocolID >= 7;
        return hasVanillaTranslations ? new TranslationUtils("minecraft", !Constants.IS_LEGACY_SOFT && MCProtocolID >= 353).setUsingAssetsPath(!Constants.IS_LEGACY_SOFT || MCProtocolID >= 72).setDefaultLanguage(MCProtocolID >= 315 ? "en_us" : "en_US").build() : null;
    }
}

