/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.ButtonWidget;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.ScrollableTextWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;

public class ControlsGui
extends ExtendedScreen {
    private final Map<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> keyMappings;
    private final Map<String, List<String>> categorizedNames = StringUtils.newHashMap();
    private String backupKeyString;
    private Tuple<ExtendedButtonControl, ExtendedButtonControl, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entryData = null;
    private ScrollPane childFrame;

    public ControlsGui(GuiScreen parentScreen) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings();
        this.sortMappings();
    }

    public ControlsGui(GuiScreen parentScreen, KeyUtils.FilterMode filterMode, List<String> filterData) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings(filterMode, filterData);
        this.sortMappings();
    }

    public ControlsGui(GuiScreen parentScreen, KeyUtils.FilterMode filterMode, String ... filterData) {
        this(parentScreen, filterMode, StringUtils.newArrayList(filterData));
    }

    @Override
    public void initializeUi() {
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "gui.config.message.button.back", () -> {
            if (this.entryData == null) {
                this.openScreen(this.parentScreen);
            }
        }, new String[0]));
        this.childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 32));
        this.setupScreenData();
        super.initializeUi();
    }

    @Override
    public void renderExtra() {
        String mainTitle = Constants.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = Constants.TRANSLATOR.translate("gui.config.message.button.controls", new Object[0]);
        this.renderScrollingString(mainTitle, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
        this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
        super.renderExtra();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.entryData != null) {
            this.setKeyData(keyCode);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private void sortMappings() {
        for (Map.Entry<String, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>> entry : this.keyMappings.entrySet()) {
            String keyName = entry.getKey();
            Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = entry.getValue();
            if (!this.categorizedNames.containsKey(keyData.getFirst().func_151466_e())) {
                this.categorizedNames.put(keyData.getFirst().func_151466_e(), StringUtils.newArrayList(keyName));
                continue;
            }
            if (this.categorizedNames.get(keyData.getFirst().func_151466_e()).contains(keyName)) continue;
            this.categorizedNames.get(keyData.getFirst().func_151466_e()).add(keyName);
        }
    }

    private void setupScreenData() {
        this.clearEntryData();
        int currentAllocatedRow = 0;
        for (Map.Entry<String, List<String>> entry : this.categorizedNames.entrySet()) {
            if (!Constants.IS_LEGACY_SOFT) {
                this.childFrame.addWidget(new ScrollableTextWidget(this.childFrame, true, 0, this.getButtonY(currentAllocatedRow), this.childFrame.getScreenWidth(), Constants.TRANSLATOR.translate(entry.getKey(), new Object[0])));
            }
            ++currentAllocatedRow;
            int middle = this.childFrame.getScreenWidth() / 2 + 3;
            for (String keyName : entry.getValue()) {
                Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData = this.keyMappings.get(keyName);
                String keyTitle = keyData.getFirst().func_151464_g();
                int keyCode = CraftPresence.KEYBINDINGS.keySyncQueue.getOrDefault(keyName, keyData.getFirst().func_151463_i());
                ButtonWidget keyCodeWidget = new ButtonWidget(this.getButtonY(currentAllocatedRow), 95, 20, KeyUtils.getKeyName(keyCode), keyTitle, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate(keyTitle.replace(".name", ".description"), new Object[0]))), keyName);
                ExtendedButtonControl keyResetButton = new ExtendedButtonControl(middle + keyCodeWidget.getControlWidth() + 15, this.getButtonY(currentAllocatedRow), 70, 20, "gui.config.message.button.reset", new String[0]);
                keyResetButton.setOnClick(() -> this.resetEntryData(keyCodeWidget, keyResetButton, keyData));
                keyCodeWidget.setOnClick(() -> this.setupEntryData(keyCodeWidget, keyResetButton, keyData));
                keyResetButton.setControlEnabled(keyCode != keyData.getFirst().func_151469_h());
                this.childFrame.addControl(keyCodeWidget);
                this.childFrame.addControl(keyResetButton);
                ++currentAllocatedRow;
            }
        }
    }

    private void setupEntryData(ExtendedButtonControl button, ExtendedButtonControl resetButton, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Tuple<ExtendedButtonControl, ExtendedButtonControl, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>>(button, resetButton, keyData);
            this.backupKeyString = button.getControlMessage();
            button.setControlMessage("gui.config.message.editor.enter_key");
        }
    }

    private void resetEntryData(ExtendedButtonControl button, ExtendedButtonControl resetButton, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>> keyData) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Tuple<ExtendedButtonControl, ExtendedButtonControl, Tuple<KeyBinding, Tuple<Runnable, BiConsumer<Integer, Boolean>, Predicate<Integer>>, Consumer<Throwable>>>(button, resetButton, keyData);
            this.setKeyData(keyData.getFirst().func_151469_h());
        }
    }

    private void setKeyData(int keyCode) {
        int keyToSubmit = keyCode;
        if (!KeyUtils.isValidKeyCode(keyToSubmit) || KeyUtils.isValidClearCode(keyToSubmit)) {
            keyToSubmit = 0;
        }
        String formattedKey = KeyUtils.getKeyName(keyToSubmit);
        String internalName = this.entryData.getFirst().getOptionalArgs()[0];
        try {
            this.entryData.getThird().getSecond().getSecond().accept(keyToSubmit, false);
            CraftPresence.KEYBINDINGS.keySyncQueue.put(internalName, keyToSubmit);
            CraftPresence.CONFIG.hasChanged = true;
            this.entryData.getFirst().setControlMessage(formattedKey);
        }
        catch (Throwable ex) {
            this.entryData.getFirst().setControlMessage(this.backupKeyString);
            Constants.LOG.debugError(ex);
        }
        this.entryData.getSecond().setControlEnabled(keyToSubmit != this.entryData.getThird().getFirst().func_151469_h());
        this.clearEntryData();
    }

    private void clearEntryData() {
        this.backupKeyString = null;
        this.entryData = null;
    }
}

