/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable.shapes;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Color;
import net.minecraft.client.renderer.Tessellator;
import org.jetbrains.annotations.Contract;

public class Circle
implements IDrawable {
    public static final double PI2 = Math.PI * 2;
    private int colorInner = 0;
    private int colorOuter = 0;
    private int segments = 40;

    @Contract(value="_ -> this")
    public Circle setColorInner(int colorInner) {
        this.colorInner = colorInner;
        return this;
    }

    public Circle setColorOuter(int colorOuter) {
        this.colorOuter = colorOuter;
        return this;
    }

    public Circle setColor(int inner, int outer) {
        this.colorInner = inner;
        this.colorOuter = outer;
        return this;
    }

    public Circle setSegments(int segments) {
        this.segments = segments;
        return this;
    }

    @Override
    public void applyThemeColor(int color) {
        if (this.colorInner == 0 && this.colorOuter == 0) {
            IDrawable.super.applyThemeColor(color == 0 ? -1 : color);
        }
    }

    @Override
    public void draw(float x0, float y0, float width, float height, float partialTicks) {
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.disableLighting();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel(7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        float x_2 = x0 + width / 2.0f;
        float y_2 = y0 + height / 2.0f;
        tessellator.func_78371_b(6);
        tessellator.func_78370_a(Color.getRed(this.colorInner), Color.getGreen(this.colorInner), Color.getBlue(this.colorInner), Color.getAlpha(this.colorInner));
        tessellator.func_78377_a((double)x_2, (double)y_2, 0.0);
        float incr = (float)(Math.PI * 2 / (double)this.segments);
        for (int i = 0; i <= this.segments; ++i) {
            float angle = incr * (float)i;
            float x = (float)(Math.sin(angle) * (double)(width / 2.0f) + (double)x_2);
            float y = (float)(Math.cos(angle) * (double)(height / 2.0f) + (double)y_2);
            tessellator.func_78371_b(6);
            tessellator.func_78370_a(Color.getRed(this.colorOuter), Color.getGreen(this.colorOuter), Color.getBlue(this.colorOuter), Color.getAlpha(this.colorOuter));
            tessellator.func_78377_a((double)x, (double)y, 0.0);
        }
        tessellator.func_78381_a();
        GlStateManager.shadeModel(7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }
}

