/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import openblocks.client.Icons;
import openmods.Log;

public class SoundIconRegistry {
    private static final String ICON_FRAME = "openblocks:sound_frame";
    public static final String CATEGORY_STREAMING = "!streaming";
    private final Icons.IDrawableIcon genericIcon = SoundIconRegistry.simpleIcon("generic", 0xFFFFFF);
    private final Icons.IDrawableIcon unknownIcon = SoundIconRegistry.simpleIcon("unknown", 0xFFFFFF);
    private final MappedCategory defaultRoot = new MappedCategory();
    private final Map<String, MappedCategory> roots = Maps.newHashMap();
    private Map<ResourceLocation, Icons.IDrawableIcon> iconCache = Maps.newConcurrentMap();
    public static final int DEFAULT_COLOR = 0xFFFFFF;

    private static String iconIdPrefix(String id) {
        return "openblocks:sound_" + id;
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent evt) {
        TextureMap map = evt.map;
        int textureType = map.func_130086_a();
        this.genericIcon.registerIcons(textureType, (IIconRegister)map);
        this.unknownIcon.registerIcons(textureType, (IIconRegister)map);
        this.defaultRoot.registerIcons(textureType, (IIconRegister)map);
        for (MappedCategory category : this.roots.values()) {
            category.registerIcons(textureType, (IIconRegister)map);
        }
    }

    private Icons.IDrawableIcon findIcon(ResourceLocation sound) {
        try {
            Icons.IDrawableIcon result;
            MappedCategory domainRoot = this.roots.get(sound.func_110624_b());
            Iterable path = Splitter.on((char)'.').split((CharSequence)sound.func_110623_a());
            if (domainRoot != null && (result = domainRoot.getIcon(path.iterator())) != null) {
                return result;
            }
            result = this.defaultRoot.getIcon(path.iterator());
            return result != null ? result : this.genericIcon;
        }
        catch (NoSuchElementException e) {
            Log.warn((String)"Malformed sound name: %s", (Object[])new Object[]{sound});
            return this.defaultRoot.defaultIcon;
        }
    }

    public Icons.IDrawableIcon getIcon(ResourceLocation sound) {
        Icons.IDrawableIcon result = this.iconCache.get(sound);
        if (result == null) {
            result = this.findIcon(sound);
            this.iconCache.put(sound, result);
        }
        return result;
    }

    private static Icons.IDrawableIcon simpleIcon(String id, int color) {
        return Icons.itemIcon(SoundIconRegistry.iconIdPrefix(id), color);
    }

    private static Icons.IDrawableIcon makeLayeredIcon(Icons.IDrawableIcon front, Icons.IDrawableIcon back) {
        return new Icons.ComposedIcon(front, back, 1.0, 1.0E-5);
    }

    public static Icons.IDrawableIcon makeFramedIcon(Icons.IDrawableIcon inner, Icons.IDrawableIcon frame) {
        return new Icons.ComposedIcon(frame, inner, 0.6, 0.0);
    }

    public static Icons.IDrawableIcon makeFramedIcon(Icons.IDrawableIcon front, Icons.IDrawableIcon back, Icons.IDrawableIcon frame) {
        Icons.IDrawableIcon inner = SoundIconRegistry.makeLayeredIcon(front, back);
        return new Icons.ComposedIcon(frame, inner, 0.6, 0.0);
    }

    private static Icons.IDrawableIcon makeFramedItemIcon(String innerIcon, int innerColor, Icons.IDrawableIcon frame) {
        Icons.IDrawableIcon inner = Icons.itemIcon(innerIcon, innerColor);
        return SoundIconRegistry.makeFramedIcon(inner, frame);
    }

    private static Icons.IDrawableIcon makeFramedItemIcon(String innerIcon, Icons.IDrawableIcon frame) {
        return SoundIconRegistry.makeFramedItemIcon(innerIcon, 0xFFFFFF, frame);
    }

    private static Icons.IDrawableIcon makeFramedBlockIcon(String innerIcon, int innerColor, Icons.IDrawableIcon frame) {
        Icons.IDrawableIcon inner = Icons.blockIcon(innerIcon, innerColor);
        return SoundIconRegistry.makeFramedIcon(inner, frame);
    }

    private static Icons.IDrawableIcon makeFramedBlockIcon(String innerIcon, Icons.IDrawableIcon frame) {
        return SoundIconRegistry.makeFramedBlockIcon(innerIcon, 0xFFFFFF, frame);
    }

    private static Icons.IDrawableIcon makeBlockIcon(String block, Icons.IDrawableIcon front, Icons.IDrawableIcon frame) {
        Icons.IDrawableIcon back = Icons.blockIcon(block);
        return SoundIconRegistry.makeFramedIcon(SoundIconRegistry.makeLayeredIcon(front, back), frame);
    }

    private static void addBlocks(MappedCategory cat, Icons.IDrawableIcon front, Icons.IDrawableIcon frame) {
        cat.add("cloth", SoundIconRegistry.makeBlockIcon("wool_colored_white", front, frame));
        cat.add("grass", SoundIconRegistry.makeBlockIcon("dirt", front, frame));
        cat.add("gravel", SoundIconRegistry.makeBlockIcon("gravel", front, frame));
        cat.add("sand", SoundIconRegistry.makeBlockIcon("sand", front, frame));
        cat.add("snow", SoundIconRegistry.makeBlockIcon("snow", front, frame));
        cat.add("stone", SoundIconRegistry.makeBlockIcon("stone", front, frame));
        cat.add("wood", SoundIconRegistry.makeBlockIcon("log_oak_top", front, frame));
        cat.add("ladder", SoundIconRegistry.makeBlockIcon("ladder", front, frame));
    }

    private MappedCategory createRoot(String id) {
        MappedCategory root = new MappedCategory();
        this.roots.put(id, root);
        return root;
    }

    public void registerDefaults() {
        Icons.IDrawableIcon frameWhite = Icons.itemIcon(ICON_FRAME, 0xFFFFFF);
        Icons.IDrawableIcon frameRed = Icons.itemIcon(ICON_FRAME, 0xFF0000);
        Icons.IDrawableIcon frameGreen = Icons.itemIcon(ICON_FRAME, 65280);
        Icons.IDrawableIcon frameBlue = Icons.itemIcon(ICON_FRAME, 255);
        Icons.IDrawableIcon frameYellow = Icons.itemIcon(ICON_FRAME, 0xFFFF00);
        Icons.IDrawableIcon shovel = Icons.itemIcon("diamond_shovel");
        Icons.IDrawableIcon boots = Icons.itemIcon("diamond_boots");
        this.defaultRoot.defaultIcon = this.unknownIcon;
        MappedCategory mcRoot = this.createRoot("minecraft");
        mcRoot.defaultIcon = this.unknownIcon;
        MappedCategory ambient = mcRoot.add("ambient", new MappedCategory());
        MappedCategory weather = ambient.add("weather", new MappedCategory());
        weather.add("rain", SoundIconRegistry.simpleIcon("rain", 255));
        weather.add("thunder", this.genericIcon);
        MappedCategory fire = mcRoot.add("fire", new MappedCategory());
        fire.add("fire", SoundIconRegistry.makeFramedBlockIcon("fire_layer_0", frameRed));
        fire.add("ignite", SoundIconRegistry.makeFramedItemIcon("flint_and_steel", frameRed));
        mcRoot.add("fireworks", SoundIconRegistry.makeFramedItemIcon("fireworks", frameRed));
        SoundIconRegistry.addBlocks(mcRoot.add("dig", new MappedCategory()), shovel, frameYellow);
        SoundIconRegistry.addBlocks(mcRoot.add("step", new MappedCategory()), boots, frameGreen);
        TintedIconCategory liquid = mcRoot.add("liquid", new TintedIconCategory(SoundIconRegistry.iconIdPrefix("liquid")));
        liquid.add("lava", SoundIconRegistry.makeFramedBlockIcon("lava_flow", frameRed));
        liquid.add("water", SoundIconRegistry.makeFramedBlockIcon("water_flow", frameBlue));
        liquid.add("lavapop", 0xFF0000);
        Icons.IDrawableIcon hurt = SoundIconRegistry.makeFramedItemIcon(SoundIconRegistry.iconIdPrefix("mob_hurt"), 0xFFFFFF, frameWhite);
        Icons.IDrawableIcon death = SoundIconRegistry.makeFramedItemIcon(SoundIconRegistry.iconIdPrefix("mob_death"), 0xFFFFFF, frameWhite);
        MappedCategory game = mcRoot.add("game", new MappedCategory());
        MappedCategory potion = game.add("potion", new MappedCategory());
        potion.add("smash", SoundIconRegistry.makeFramedItemIcon("potion_bottle_splash", frameWhite));
        potion = game.add("tnt", new MappedCategory());
        potion.add("primed", SoundIconRegistry.makeFramedBlockIcon("tnt_side", frameRed));
        Icons.IDrawableIcon hostileBack = SoundIconRegistry.simpleIcon("mob_hostile", 0xFFFFFF);
        MappedCategory hostile = game.add("hostile", new MappedCategory());
        hostile.defaultIcon = SoundIconRegistry.makeFramedIcon(hostileBack, frameWhite);
        hostile.add("die", SoundIconRegistry.makeFramedIcon(death, hostileBack, frameRed));
        hostile.add("hurt", SoundIconRegistry.makeFramedIcon(hurt, hostileBack, frameRed));
        Icons.IDrawableIcon neutralBack = SoundIconRegistry.simpleIcon("mob_friendly", 0xFFFFFF);
        MappedCategory netural = game.add("neutral", new MappedCategory());
        netural.defaultIcon = SoundIconRegistry.makeFramedIcon(neutralBack, frameWhite);
        netural.add("die", SoundIconRegistry.makeFramedIcon(death, neutralBack, frameRed));
        netural.add("hurt", SoundIconRegistry.makeFramedIcon(hurt, neutralBack, frameRed));
        Icons.IDrawableIcon playerBack = Icons.itemIcon("skull_steve", 0xFFFFFF);
        MappedCategory player = game.add("player", new MappedCategory());
        player.defaultIcon = SoundIconRegistry.makeFramedIcon(playerBack, frameWhite);
        player.add("die", SoundIconRegistry.makeFramedIcon(hurt, playerBack, frameRed));
        player.add("hurt", SoundIconRegistry.makeFramedIcon(hurt, playerBack, frameRed));
        MappedCategory records = mcRoot.add("records", new MappedCategory());
        records.add("13", SoundIconRegistry.makeFramedItemIcon("record_13", frameBlue));
        records.add("cat", SoundIconRegistry.makeFramedItemIcon("record_cat", frameBlue));
        records.add("blocks", SoundIconRegistry.makeFramedItemIcon("record_blocks", frameBlue));
        records.add("chirp", SoundIconRegistry.makeFramedItemIcon("record_chirp", frameBlue));
        records.add("far", SoundIconRegistry.makeFramedItemIcon("record_far", frameBlue));
        records.add("mall", SoundIconRegistry.makeFramedItemIcon("record_mall", frameBlue));
        records.add("mellohi", SoundIconRegistry.makeFramedItemIcon("record_mellohi", frameBlue));
        records.add("stal", SoundIconRegistry.makeFramedItemIcon("record_stal", frameBlue));
        records.add("strad", SoundIconRegistry.makeFramedItemIcon("record_strad", frameBlue));
        records.add("ward", SoundIconRegistry.makeFramedItemIcon("record_ward", frameBlue));
        records.add("11", SoundIconRegistry.makeFramedItemIcon("record_11", frameBlue));
        records.add("wait", SoundIconRegistry.makeFramedItemIcon("record_wait", frameBlue));
        MobSounds mobs = mcRoot.add("mob", new MobSounds());
        mobs.addMob("blaze", 61, true);
        mobs.addMob("creeper", 50, true);
        mobs.addMob("magmacube", 62, true);
        mobs.addMob("silverfish", 60, true);
        mobs.addMob("skeleton", 51, true);
        mobs.addMob("slime", 55, true);
        mobs.addMob("spider", 52, true);
        mobs.addMob("wither", 64, true);
        mobs.addMob("zombie", 54, true);
        mobs.addMob("enderdragon", 62, true);
        mobs.addMob("endermen", 58, true);
        mobs.addMob("ghast", 56, true);
        mobs.addMob("witch", 66, true);
        mobs.addMob("bat", 65, false);
        mobs.addMob("cat", 62, false);
        mobs.addMob("chicken", 93, false);
        mobs.addMob("cow", 92, false);
        mobs.addMob("horse", 100, false);
        mobs.addMob("irongolem", 99, false);
        mobs.addMob("pig", 90, false);
        mobs.addMob("sheep", 91, false);
        mobs.addMob("villager", 120, false);
        mobs.addMob("zombiepig", 57, false);
        mobs.addMob("wolf", 95, false);
        TintedIconCategory note = mcRoot.add("note", new TintedIconCategory(SoundIconRegistry.iconIdPrefix("note")));
        note.add("bass", 255);
        note.add("bassattack", 0xFFFF00);
        note.add("bd", 65535);
        note.add("harp", 0xFF0000);
        note.add("hat", 65280);
        note.add("pling", 0xFF00FF);
        note.add("snare", 0xFFFFFF);
        mcRoot.add("portal", SoundIconRegistry.makeFramedBlockIcon("portal", frameWhite));
        mcRoot.add("minecart", SoundIconRegistry.makeFramedItemIcon("minecart_normal", frameWhite));
        MappedCategory random = mcRoot.add("random", new MappedCategory());
        Icons.IDrawableIcon anvil = SoundIconRegistry.makeFramedBlockIcon("anvil_base", frameWhite);
        random.add("anvil_land", anvil);
        random.add("anvil_use", anvil);
        random.add("anvil_break", anvil);
        random.add("bow", SoundIconRegistry.makeFramedItemIcon("bow_standby", frameWhite));
        random.add("bowhit", SoundIconRegistry.makeFramedItemIcon("arrow", frameWhite));
        Icons.IDrawableIcon damage = SoundIconRegistry.makeFramedBlockIcon("destroy_stage_5", frameWhite);
        random.add("break", damage);
        Icons.IDrawableIcon eat = SoundIconRegistry.makeFramedItemIcon("potato_baked", frameWhite);
        random.add("eat", eat);
        random.add("burp", eat);
        Icons.IDrawableIcon chest = SoundIconRegistry.makeFramedBlockIcon("planks_oak", frameWhite);
        random.add("chestclosed", chest);
        random.add("chestopen", chest);
        Icons.IDrawableIcon click = SoundIconRegistry.simpleIcon("click", 0xFFFFFF);
        random.add("click", click);
        random.add("wood_click", click);
        random.add("pop", click);
        Icons.IDrawableIcon door = SoundIconRegistry.makeFramedItemIcon("door_wood", frameWhite);
        random.add("door_close", door);
        random.add("door_open", door);
        Icons.IDrawableIcon drink = SoundIconRegistry.makeFramedItemIcon("potion_bottle_drinkable", frameWhite);
        random.add("drink", drink);
        Icons.IDrawableIcon tnt = SoundIconRegistry.makeFramedBlockIcon("tnt_side", frameWhite);
        random.add("explode", tnt);
        random.add("fizz", SoundIconRegistry.simpleIcon("fizz", 0xFFFFFF));
        Icons.IDrawableIcon exp = SoundIconRegistry.makeFramedItemIcon("experience_bottle", frameWhite);
        random.add("levelup", exp);
        random.add("orb", exp);
        Icons.IDrawableIcon glass = SoundIconRegistry.makeFramedBlockIcon("glass", frameWhite);
        random.add("splash", glass);
        MappedCategory tile = mcRoot.add("tile", new MappedCategory());
        Icons.IDrawableIcon piston = SoundIconRegistry.makeFramedBlockIcon("piston_side", frameWhite);
        tile.add("piston", piston);
        mcRoot.add("creeper", SoundIconRegistry.makeFramedItemIcon("skull_creeper", frameGreen));
        Icons.IDrawableIcon potato = SoundIconRegistry.makeFramedItemIcon("potato_baked", frameWhite);
        Icons.IDrawableIcon apple = SoundIconRegistry.makeFramedItemIcon("apple", frameWhite);
        Icons.IDrawableIcon pearl = SoundIconRegistry.makeFramedItemIcon("ender_pearl", frameWhite);
        Icons.IDrawableIcon write = SoundIconRegistry.makeFramedItemIcon("book_writable", frameWhite);
        MappedCategory openblocks = this.createRoot("openblocks");
        openblocks.defaultIcon = this.genericIcon;
        MappedCategory elevator = openblocks.add("elevator", new MappedCategory());
        elevator.defaultIcon = pearl;
        MappedCategory luggage = openblocks.add("luggage", new MappedCategory());
        luggage.defaultIcon = this.genericIcon;
        MappedCategory eat2 = luggage.add("eat", new MappedCategory());
        eat2.add("item", apple);
        eat2.add("food", potato);
        MappedCategory crayon = openblocks.add("crayon", new MappedCategory());
        crayon.add("place", write);
    }

    public static class SkipPath
    implements ISoundCategory {
        private final ISoundCategory child;

        private SkipPath(ISoundCategory child) {
            Preconditions.checkNotNull((Object)child);
            this.child = child;
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            path.next();
            return this.child.getIcon(path);
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            this.child.registerIcons(type, registry);
        }
    }

    private static class MobSounds
    implements ISoundCategory {
        private Map<String, MobIcons> mobs = Maps.newHashMap();
        private MobIcons unknownMob = MobSounds.createMobIcons("mob_unknown", 0xFFFFFF, 0xFFFFFF);

        private static MobIcons createMobIcons(String innerIcon, int innerColor, int frameColor) {
            Icons.IDrawableIcon frame = Icons.itemIcon(SoundIconRegistry.ICON_FRAME, frameColor);
            Icons.IDrawableIcon normal = SoundIconRegistry.makeFramedItemIcon(SoundIconRegistry.iconIdPrefix(innerIcon), innerColor, frame);
            Icons.IDrawableIcon hurt = SoundIconRegistry.makeFramedItemIcon(SoundIconRegistry.iconIdPrefix("mob_hurt"), innerColor, frame);
            Icons.IDrawableIcon death = SoundIconRegistry.makeFramedItemIcon(SoundIconRegistry.iconIdPrefix("mob_death"), innerColor, frame);
            return new MobIcons(normal, hurt, death);
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            String mobName = path.next();
            String actionName = path.next();
            MobIcons mob = this.mobs.get(mobName);
            if (mob == null) {
                mob = this.unknownMob;
            }
            if (actionName.equals("hit")) {
                return mob.hurtIcon;
            }
            if (actionName.equals("death")) {
                return mob.deathIcon;
            }
            return mob.normalIcon;
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            this.unknownMob.registerIcons(type, registry);
            for (MobIcons icons : this.mobs.values()) {
                icons.registerIcons(type, registry);
            }
        }

        public void addMob(String soundId, int mobId, boolean isHostile) {
            EntityList.EntityEggInfo mobInfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(mobId);
            if (mobInfo != null) {
                this.mobs.put(soundId, MobSounds.createMobIcons(isHostile ? "mob_hostile" : "mob_friendly", mobInfo.field_75611_b, mobInfo.field_75612_c));
            } else {
                this.mobs.put(soundId, this.unknownMob);
            }
        }
    }

    private static class MobIcons {
        public final Icons.IDrawableIcon normalIcon;
        public final Icons.IDrawableIcon hurtIcon;
        public final Icons.IDrawableIcon deathIcon;

        private MobIcons(Icons.IDrawableIcon normalIcon, Icons.IDrawableIcon hurtIcon, Icons.IDrawableIcon deathIcon) {
            this.normalIcon = normalIcon;
            this.hurtIcon = hurtIcon;
            this.deathIcon = deathIcon;
        }

        private void registerIcons(int type, IIconRegister registry) {
            this.normalIcon.registerIcons(type, registry);
            this.hurtIcon.registerIcons(type, registry);
            this.deathIcon.registerIcons(type, registry);
        }
    }

    private static class TintedIconCategory
    extends MappedCategory {
        private final String iconId;

        private TintedIconCategory(String iconId) {
            this.iconId = iconId;
        }

        public void add(String id, int color) {
            Icons.IDrawableIcon icon = Icons.itemIcon(this.iconId, color);
            this.add(id, new ConstantIcon(icon));
        }
    }

    private static class MappedCategory
    implements ISoundCategory {
        public Icons.IDrawableIcon defaultIcon;
        private final Map<String, ISoundCategory> subCategories = Maps.newHashMap();

        private MappedCategory() {
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            String id = path.next();
            ISoundCategory result = this.subCategories.get(id);
            if (result == null) {
                return this.defaultIcon;
            }
            Icons.IDrawableIcon icon = result.getIcon(path);
            return icon != null ? icon : this.defaultIcon;
        }

        public <T extends ISoundCategory> T add(String id, T subcategory) {
            this.subCategories.put(id, subcategory);
            return subcategory;
        }

        public void add(String id, Icons.IDrawableIcon icon) {
            this.subCategories.put(id, new ConstantIcon(icon));
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            if (this.defaultIcon != null) {
                this.defaultIcon.registerIcons(type, registry);
            }
            for (ISoundCategory cat : this.subCategories.values()) {
                cat.registerIcons(type, registry);
            }
        }
    }

    public static class ConstantIcon
    implements ISoundCategory {
        private final Icons.IDrawableIcon icon;

        private ConstantIcon(Icons.IDrawableIcon icon) {
            this.icon = icon;
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            this.icon.registerIcons(type, registry);
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            return this.icon;
        }
    }

    public static interface ISoundCategory {
        public Icons.IDrawableIcon getIcon(Iterator<String> var1);

        public void registerIcons(int var1, IIconRegister var2);
    }
}

