/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.packets;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.sg.SGCraft;
import gcewing.sg.interfaces.ChannelInput;
import gcewing.sg.interfaces.ChannelOutput;
import gcewing.sg.packets.DataHandler;
import gcewing.sg.packets.DataPacket;
import gcewing.sg.packets.HandlerMap;
import io.netty.channel.ChannelHandler;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;

public class BaseDataChannel {
    public String name;
    public List handlers = new ArrayList();
    protected EnumMap<Side, FMLEmbeddedChannel> pipes;

    public BaseDataChannel(String name, Object ... handlers) {
        this.name = name;
        DataHandler handler = new DataHandler(this);
        this.pipes = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{handler});
        this.handlers.add(this);
        for (Object h : handlers) {
            this.handlers.add(h);
        }
    }

    protected ChannelOutput openTarget(String message, Side fromSide, FMLOutboundHandler.OutboundTarget target) {
        return this.openTarget(message, fromSide, target, null);
    }

    protected ChannelOutput openTarget(String message, Side fromSide, FMLOutboundHandler.OutboundTarget target, Object arg) {
        DataPacket out = new DataPacket(this, fromSide, target, arg);
        out.writeUTF(message);
        return out;
    }

    public ChannelOutput openServer(String message) {
        return this.openTarget(message, Side.CLIENT, FMLOutboundHandler.OutboundTarget.TOSERVER);
    }

    public ChannelOutput openPlayer(EntityPlayer player, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.PLAYER, player);
    }

    @ServerMessageHandler(value=".container.")
    public void onServerContainerMessage(EntityPlayer player, ChannelInput data) {
        String message = data.readUTF();
        BaseDataChannel.doServerDispatch(player.field_71070_bA, message, player, data);
    }

    @SideOnly(value=Side.CLIENT)
    @ClientMessageHandler(value=".container.")
    public void onClientContainerMessage(ChannelInput data) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        String message = data.readUTF();
        BaseDataChannel.doClientDispatch(player.field_71070_bA, message, data);
    }

    protected void onReceiveFromClient(EntityPlayer player, ChannelInput data) {
        String message = data.readUTF();
        for (Object h : this.handlers) {
            if (!BaseDataChannel.serverDispatch(h, message, player, data)) continue;
            return;
        }
        SGCraft.log.warn(String.format("No ServerMessageHandler for '%s' found in registered handlers of %s", message, this));
    }

    public static void doServerDispatch(Object handler, String message, EntityPlayer player, ChannelInput data) {
        if (!BaseDataChannel.serverDispatch(handler, message, player, data)) {
            SGCraft.log.warn(String.format("No ServerMessageHandler for '%s' found in %s", message, handler.getClass().getName()));
        }
    }

    public static boolean serverDispatch(Object handler, String message, EntityPlayer player, ChannelInput data) {
        Method meth;
        if (handler != null && (meth = HandlerMap.SERVER.get(handler, message)) != null) {
            try {
                meth.invoke(handler, player, data);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception while calling server-side handler %s.%s for message %s", handler.getClass().getName(), meth.getName(), message), e);
            }
            return true;
        }
        return false;
    }

    protected void onReceiveFromServer(ChannelInput data) {
        String message = data.readUTF();
        for (Object h : this.handlers) {
            if (!BaseDataChannel.clientDispatch(h, message, data)) continue;
            return;
        }
        SGCraft.log.warn(String.format("No ClientMessageHandler for '%s' found in registered handlers", message));
    }

    public static void doClientDispatch(Object handler, String message, ChannelInput data) {
        if (!BaseDataChannel.clientDispatch(handler, message, data)) {
            SGCraft.log.warn(String.format("No ClientMessageHandler for '%s' found in %s", message, handler.getClass().getName()));
        }
    }

    public static boolean clientDispatch(Object handler, String message, ChannelInput data) {
        Method meth;
        if (handler != null && (meth = HandlerMap.CLIENT.get(handler, message)) != null) {
            try {
                meth.invoke(handler, data);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception while calling client-side handler %s.%s for message %s", handler.getClass().getName(), meth.getName(), message), e);
            }
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClientMessageHandler {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ServerMessageHandler {
        public String value();
    }
}

