/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.core;

import bq_standard.commands.BQS_Commands;
import bq_standard.core.proxies.CommonProxy;
import bq_standard.handlers.ConfigHandler;
import bq_standard.handlers.GuiHandler;
import bq_standard.handlers.LootSaveLoad;
import bq_standard.items.ItemLootChest;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="bq_standard", name="Standard Expansion", version="3.5.15-GTNH", dependencies="required-after:betterquesting", guiFactory="bq_standard.handlers.ConfigGuiFactory")
public class BQ_Standard {
    public static final String MODID = "bq_standard";
    public static final String NAME = "Standard Expansion";
    public static final String VERSION = "3.5.15-GTNH";
    public static final String PROXY = "bq_standard.core.proxies";
    public static final String CHANNEL = "BQ_STANDARD";
    public static boolean hasNEI = false;
    @Mod.Instance(value="bq_standard")
    public static BQ_Standard instance;
    @SidedProxy(clientSide="bq_standard.core.proxies.ClientProxy", serverSide="bq_standard.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static Item lootChest;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerItem((Item)lootChest, (String)"loot_chest");
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"betterquesting")) {
            proxy.registerExpansion();
        }
        hasNEI = Loader.isModLoaded((String)"NotEnoughItems");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new BQS_Commands());
        LootSaveLoad.INSTANCE.LoadLoot(event.getServer());
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        LootSaveLoad.INSTANCE.UnloadLoot();
    }

    static {
        lootChest = new ItemLootChest();
    }
}

