/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.GregTechOre;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTList;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTNamed;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

public class DetailedChunkAnalysis {
    private final int dimensionId;
    public final int chunkX;
    public final int chunkZ;
    private final Map<Short, Integer>[] oresPerY = new HashMap[256];

    public DetailedChunkAnalysis(int dimensionId, int chunkX, int chunkZ) {
        this.dimensionId = dimensionId;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public void processMinecraftChunk(NBTCompound chunkRoot) {
        for (NBTNamed tileEntity : ((NBTList)chunkRoot.getTag((String)"Level.TileEntities")).elements) {
            GregTechOre gtOre = new GregTechOre((NBTCompound)tileEntity);
            if (!gtOre.isValidGTOre) continue;
            if (this.oresPerY[gtOre.blockY] == null) {
                this.oresPerY[gtOre.blockY] = new HashMap<Short, Integer>();
            }
            if (!this.oresPerY[gtOre.blockY].containsKey(gtOre.metaData)) {
                this.oresPerY[gtOre.blockY].put(gtOre.metaData, 0);
            }
            this.oresPerY[gtOre.blockY].put(gtOre.metaData, this.oresPerY[gtOre.blockY].get(gtOre.metaData) + 1);
        }
    }

    public void cleanUpWithNeighbors(Map<Long, Integer> veinChunkY) {
        OreVeinPosition[] neighbors = new OreVeinPosition[]{ServerCache.instance.getOreVein(this.dimensionId, this.chunkX - 3, this.chunkZ + 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX, this.chunkZ + 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX + 3, this.chunkZ + 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX + 3, this.chunkZ), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX + 3, this.chunkZ - 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX, this.chunkZ - 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX - 3, this.chunkZ - 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX - 3, this.chunkZ)};
        int[] neighborVeinBlockY = new int[]{veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX - 3), Utils.mapToCenterOreChunkCoord(this.chunkZ + 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX), Utils.mapToCenterOreChunkCoord(this.chunkZ + 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX + 3), Utils.mapToCenterOreChunkCoord(this.chunkZ + 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX + 3), Utils.mapToCenterOreChunkCoord(this.chunkZ)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX + 3), Utils.mapToCenterOreChunkCoord(this.chunkZ - 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX), Utils.mapToCenterOreChunkCoord(this.chunkZ - 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX - 3), Utils.mapToCenterOreChunkCoord(this.chunkZ - 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX - 3), Utils.mapToCenterOreChunkCoord(this.chunkZ)), 0)};
        for (int neighborId = 0; neighborId < neighbors.length; ++neighborId) {
            int blockY;
            boolean canOverlap;
            OreVeinPosition neighbor = neighbors[neighborId];
            boolean atCoordinateAxis = Math.abs(neighbor.chunkX - this.chunkX) < 3 || Math.abs(neighbor.chunkZ - this.chunkZ) < 3;
            boolean bl = canOverlap = atCoordinateAxis ? neighbor.veinType.canOverlapIntoNeighborOreChunkAtCoordinateAxis() : neighbor.veinType.canOverlapIntoNeighborOreChunk();
            if (neighbor.veinType == VeinType.NO_VEIN || !canOverlap) continue;
            int veinBlockY = neighborVeinBlockY[neighborId];
            for (int layerBlockY = 0; layerBlockY < 9 && (blockY = veinBlockY + layerBlockY) <= 255; ++layerBlockY) {
                if (this.oresPerY[blockY] == null) continue;
                for (short metaData : neighbor.veinType.getOresAtLayer(layerBlockY)) {
                    this.oresPerY[blockY].remove(metaData);
                }
            }
        }
    }

    public VeinType getMatchedVein() {
        HashSet<VeinType> matchedVeins = new HashSet<VeinType>();
        HashMap allOres = new HashMap();
        for (Map<Short, Integer> oreLevel : this.oresPerY) {
            if (oreLevel == null || oreLevel.isEmpty()) continue;
            oreLevel.forEach((metaData, numberOfBlocks) -> allOres.merge(metaData, numberOfBlocks, Integer::sum));
        }
        Optional<Short> dominantOre = allOres.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(Map.Entry::getKey).findFirst();
        if (dominantOre.isPresent()) {
            for (VeinType veinType2 : VeinTypeCaching.veinTypes) {
                if (!veinType2.matchesWithSpecificPrimaryOrSecondary(allOres.keySet(), dominantOre.get())) continue;
                matchedVeins.add(veinType2);
            }
        }
        if (matchedVeins.size() == 1) {
            return (VeinType)matchedVeins.stream().findAny().get();
        }
        if (matchedVeins.size() >= 2) {
            matchedVeins.removeIf(veinType -> IntStream.range(veinType.minBlockY, veinType.maxBlockY).boxed().noneMatch(blockY -> this.isOreVeinGeneratedAtHeight((VeinType)veinType, (int)blockY)));
            if (matchedVeins.size() == 1) {
                return (VeinType)matchedVeins.stream().findAny().get();
            }
        }
        return VeinType.NO_VEIN;
    }

    private boolean isOreVeinGeneratedAtHeight(VeinType veinType, int blockY) {
        for (int layer = 0; layer < 9; ++layer) {
            if (this.oresPerY[blockY + layer] != null && this.oresPerY[blockY + layer].keySet().containsAll(veinType.getOresAtLayer(layer))) continue;
            return false;
        }
        return true;
    }
}

