/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.sinthoras.visualprospecting.integration.model.SupportedMods;
import com.sinthoras.visualprospecting.integration.model.buttons.ButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.waypoints.Waypoint;
import com.sinthoras.visualprospecting.integration.model.waypoints.WaypointManager;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import journeymap.client.model.BlockCoordIntPair;

public abstract class WaypointProviderManager
extends LayerManager {
    private List<? extends IWaypointAndLocationProvider> visibleElements = new ArrayList<IWaypointAndLocationProvider>();
    private Map<SupportedMods, WaypointManager> waypointManagers = new EnumMap<SupportedMods, WaypointManager>(SupportedMods.class);
    protected Waypoint activeWaypoint = null;

    public WaypointProviderManager(ButtonManager buttonManager) {
        super(buttonManager);
    }

    public void setActiveWaypoint(Waypoint waypoint) {
        this.activeWaypoint = waypoint;
        this.visibleElements.forEach(element -> element.onWaypointUpdated(waypoint));
        this.waypointManagers.values().forEach(translator -> translator.updateActiveWaypoint(waypoint));
    }

    public void clearActiveWaypoint() {
        this.activeWaypoint = null;
        this.visibleElements.forEach(IWaypointAndLocationProvider::onWaypointCleared);
        this.waypointManagers.values().forEach(WaypointManager::clearActiveWaypoint);
    }

    public boolean hasActiveWaypoint() {
        return this.activeWaypoint != null;
    }

    public boolean doActionOutsideLayer(BlockCoordIntPair blockCoord) {
        return false;
    }

    public void registerWaypointManager(SupportedMods map, WaypointManager waypointManager) {
        this.waypointManagers.put(map, waypointManager);
    }

    public WaypointManager getWaypointManager(SupportedMods map) {
        return this.waypointManagers.get((Object)map);
    }

    protected abstract List<? extends IWaypointAndLocationProvider> generateVisibleElements(int var1, int var2, int var3, int var4);

    @Override
    protected void checkAndUpdateElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        if (this.forceRefresh || this.needsRegenerateVisibleElements(minBlockX, minBlockZ, maxBlockX, maxBlockZ)) {
            this.visibleElements = this.generateVisibleElements(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
            if (this.hasActiveWaypoint()) {
                for (IWaypointAndLocationProvider iWaypointAndLocationProvider : this.visibleElements) {
                    iWaypointAndLocationProvider.onWaypointUpdated(this.activeWaypoint);
                }
            }
            this.layerRenderer.values().forEach(layer -> layer.updateVisibleElements(this.visibleElements));
            this.forceRefresh = false;
        }
    }
}

