/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net.data;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.data.MultiTileEntityProcess;
import gregtech.api.net.data.PacketData;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.util.ChunkCoordinates;

public class CasingData
extends PacketData<MultiTileEntityProcess> {
    public static final int CASING_DATA_ID = 4;
    private int currentMode;
    private int allowedModes;
    private ChunkCoordinates controllerCoords;

    public CasingData() {
    }

    public CasingData(int currentMode, int allowedModes, ChunkCoordinates controllerCoords) {
        this.currentMode = currentMode;
        this.allowedModes = allowedModes;
        this.controllerCoords = controllerCoords;
    }

    @Override
    public void decode(@Nonnull ByteArrayDataInput in) {
        this.currentMode = in.readInt();
        this.allowedModes = in.readInt();
        this.controllerCoords = new ChunkCoordinates(in.readInt(), in.readInt(), in.readInt());
    }

    @Override
    public void encode(@Nonnull ByteBuf out) {
        out.writeInt(this.currentMode);
        out.writeInt(this.allowedModes);
        out.writeInt(this.controllerCoords.field_71574_a);
        out.writeInt(this.controllerCoords.field_71572_b);
        out.writeInt(this.controllerCoords.field_71573_c);
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public void process(MultiTileEntityProcess processData) {
    }
}

