/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import appeng.api.AEApi;
import bartworks.API.BorosilicateGlass;
import com.google.common.collect.MapMaker;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.ResultMissingItem;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.render.TileEntityWormhole;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;

public class MTEWormholeGenerator
extends MTEEnhancedMultiBlockBase<MTEWormholeGenerator>
implements ISurvivalConstructable {
    public static int WH_ENERGY_AVG_WINDOW = 5;
    public static double TRANSFER_EFFICIENCY = 0.995;
    public static double DECAY_RATE = 0.25;
    public static double COLLAPSE_THRESHOLD = 20.0;
    public static double MAX_OVERCLOCKS = 2.0;
    public static int SCAN_AVG_WINDOW = 10;
    public static double RENDER_PERCENT_TARGET = 0.1;
    public static double RENDER_TARGET_ENERGY = TierEU.IV * 256L;
    public static double RENDER_MAX_RADIUS = 2.999 / Math.sqrt(3.0);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final byte GLASS_TIER_UNSET = -2;
    private static final int TT_CASING_INDEX = 1024;
    private static final int TOP_HATCH = 0;
    private static final int BOTTOM_HATCH = 1;
    private static final int LEFT_HATCH = 2;
    private static final int RIGHT_HATCH = 3;
    private static final int BACK_HATCH = 4;
    private static final int FRONT_HATCH = 5;
    private static final int MAX_HATCHES = 6;
    private static final int[] OPPOSITES = new int[]{1, 0, 3, 2, 5, 4};
    private static final String[] HATCH_NAMES = new String[]{"Top", "Bottom", "Left", "Right", "Back", "Front"};
    private static final boolean[] HATCH_MASK = new boolean[]{true, true, true, true, false, false};
    private byte mGlassTier = (byte)-2;
    private boolean mStructureBadGlassTier = false;
    private final MTEHatchEnergyMulti[] mSendHatches = new MTEHatchEnergyMulti[6];
    private final MTEHatchDynamoMulti[] mReceiveHatches = new MTEHatchDynamoMulti[6];
    private final ItemStack singularity = (ItemStack)AEApi.instance().definitions().materials().singularity().maybeStack(1).get();
    private final ItemStack qeSingularity = (ItemStack)AEApi.instance().definitions().materials().qESingularity().maybeStack(1).get();
    private WormholeLink mLink;
    private final WeakReference<MTEWormholeGenerator> mSelfReference = new WeakReference<MTEWormholeGenerator>(this);
    private double mWormholeEnergy_UI = 0.0;
    private boolean mAllowOverclocks = true;
    private boolean mIsUnloading = false;
    private static final IStructureDefinition<MTEWormholeGenerator> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "   F   ", "  EEE  ", " FEtEF ", "  EEE  ", "   F   ", "       "}, {"   F   ", " AADAA ", " A B A ", "FDBBBDF", " A B A ", " AADAA ", "   F   "}, {"  EEE  ", " A B A ", "E     E", "EB   BE", "E     E", " A B A ", "  EEE  "}, {" FE~EF ", "FA B AF", "E     E", "lB   Br", "E     E", "FA B AF", " FEEEF "}, {"  EEE  ", " A B A ", "E     E", "EB   BE", "E     E", " A B A ", "  EEE  "}, {"   F   ", " AADAA ", " A B A ", "FDBBBDF", " A B A ", " AADAA ", "   F   "}, {"       ", "   F   ", "  EEE  ", " FEbEF ", "  EEE  ", "   F   ", "       "}})).addElement('E', GTStructureUtility.buildHatchAdder(MTEWormholeGenerator.class).atLeast(HatchElement.Maintenance, HatchElement.InputBus).casingIndex(1024).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0))})).addElement('A', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)-2, (te, t) -> {
        te.mGlassTier = t;
    }, te -> te.mGlassTier))).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)5)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)7)).addElement('F', (IStructureElement)StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)4))).addElement('t', GTStructureUtility.buildHatchAdder(MTEWormholeGenerator.class).anyOf(new TransferHatch(0)).casingIndex(1024).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0))})).addElement('b', GTStructureUtility.buildHatchAdder(MTEWormholeGenerator.class).anyOf(new TransferHatch(1)).casingIndex(1024).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0))})).addElement('l', GTStructureUtility.buildHatchAdder(MTEWormholeGenerator.class).anyOf(new TransferHatch(2)).casingIndex(1024).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0))})).addElement('r', GTStructureUtility.buildHatchAdder(MTEWormholeGenerator.class).anyOf(new TransferHatch(3)).casingIndex(1024).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.lazy(() -> StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0))})).build();

    public MTEWormholeGenerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEWormholeGenerator(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEWormholeGenerator(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1024), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1024), TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Machine_Controller_Advanced).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1024)};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GT_MACHINES_FUSION_LOOP;
    }

    @Override
    public IStructureDefinition<MTEWormholeGenerator> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        Arrays.fill(this.mSendHatches, null);
        Arrays.fill(this.mReceiveHatches, null);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 3, 0)) {
            return false;
        }
        this.mStructureBadGlassTier = false;
        for (MTEHatch energyHatch : this.mExoticEnergyHatches) {
            if (energyHatch.getBaseMetaTileEntity() == null || energyHatch.getTierForStructure() <= this.mGlassTier) continue;
            this.mStructureBadGlassTier = true;
            break;
        }
        return !this.mStructureBadGlassTier;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        this.destroyRenderBlock();
    }

    @Override
    public void onDisableWorking() {
        super.onDisableWorking();
    }

    @Override
    public void onStructureChange() {
        super.onStructureChange();
        if (!this.checkStructure(false, this.getBaseMetaTileEntity())) {
            this.destroyRenderBlock();
        }
    }

    private void destroyRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        if (gregTechTileEntity.getWorld() == null) {
            return;
        }
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        int xOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int yOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int zOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        int xTarget = x + xOffset;
        int yTarget = y + yOffset;
        int zTarget = z + zOffset;
        Optional.of(gregTechTileEntity).map(IHasWorldObjectAndCoords::getWorld).ifPresent(w -> w.func_147449_b(xTarget, yTarget, zTarget, Blocks.field_150350_a));
    }

    @Nullable
    private TileEntityWormhole createRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        World world = gregTechTileEntity.getWorld();
        if (world == null) {
            return null;
        }
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        int xOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int yOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int zOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        int xTarget = x + xOffset;
        int yTarget = y + yOffset;
        int zTarget = z + zOffset;
        world.func_147449_b(xTarget, yTarget, zTarget, Blocks.field_150350_a);
        world.func_147449_b(xTarget, yTarget, zTarget, GregTechAPI.sWormholeRender);
        return (TileEntityWormhole)world.func_147438_o(xTarget, yTarget, zTarget);
    }

    @Nullable
    private TileEntityWormhole getRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int wX = (int)((double)x + xOffset);
        int wY = (int)((double)y + yOffset);
        int wZ = (int)((double)z + zOffset);
        TileEntity tile = Optional.ofNullable(gregTechTileEntity.getWorld()).map(w -> w.func_147438_o(wX, wY, wZ)).orElse(null);
        if (tile instanceof TileEntityWormhole) {
            TileEntityWormhole wormhole = (TileEntityWormhole)tile;
            return wormhole;
        }
        return null;
    }

    public void updateRenderDim() {
        World target = Optional.ofNullable(this.mLink).map(link -> link.getDest(this.mSelfReference)).map(MetaTileEntity::getBaseMetaTileEntity).map(IHasWorldObjectAndCoords::getWorld).orElse(null);
        TileEntityWormhole hole = this.getRenderBlock();
        if (hole == null) {
            hole = this.createRenderBlock();
        }
        if (hole != null) {
            hole.setDimFromWorld(target);
        }
    }

    public void updateRenderRadius(double radius) {
        TileEntityWormhole hole = this.getRenderBlock();
        if (hole == null) {
            hole = this.createRenderBlock();
        }
        if (hole != null) {
            hole.setRadius(radius);
        }
    }

    private static double wormholeRadiusCalc(double energy) {
        if (energy < COLLAPSE_THRESHOLD) {
            return 0.0;
        }
        double offset = RENDER_TARGET_ENERGY + (COLLAPSE_THRESHOLD - RENDER_TARGET_ENERGY) / RENDER_PERCENT_TARGET;
        return RENDER_MAX_RADIUS * (COLLAPSE_THRESHOLD - energy) / (offset - energy);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.mIsUnloading = true;
        if (this.mLink != null) {
            this.mLink.disconnect(this.mSelfReference);
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!aPlayer.func_70093_af()) {
            boolean bl = this.mAllowOverclocks = !this.mAllowOverclocks;
            if (this.mAllowOverclocks) {
                GTUtility.sendChatToPlayer(aPlayer, String.format("Overclocks: \u00a7a%s\u00a7r", GTUtility.trans("088", "Enabled")));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, String.format("Overclocks: \u00a7c%s\u00a7r", GTUtility.trans("087", "Disabled")));
            }
        } else {
            super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        }
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.checkFrequency();
        this.mMaxProgresstime = 20;
        this.mEfficiency = Math.max(0, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000);
        if (this.doRandomMaintenanceDamage() && this.onRunningTick(this.mInventory[1])) {
            this.func_70296_d();
            if (++this.mProgresstime >= this.mMaxProgresstime) {
                this.mProgresstime = 0;
                if (this.mLink != null) {
                    this.mLink.update(this.mSelfReference);
                }
                this.checkRecipe();
            }
        }
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (this.mLink == null || !this.mLink.isConnected(this.mSelfReference) || this.getBaseMetaTileEntity() == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return SimpleCheckRecipeResult.ofFailure("none");
        }
        if (this.mLink.isActive()) {
            for (int i = 0; i < 6; ++i) {
                long optimal;
                if (!HATCH_MASK[i]) continue;
                long l = optimal = this.mLink.mWormholeEnergy > 9.223372036854776E18 ? Long.MAX_VALUE : (long)this.mLink.mWormholeEnergy;
                if (this.getTransferable(i) <= 0L) continue;
                if (this.mLink.mWormholeEnergy <= 0.0) {
                    ItemStack singularityStack = this.singularity.func_77946_l();
                    if (!this.depleteInput(singularityStack)) {
                        return new ResultMissingItem(singularityStack);
                    }
                    this.mLink.mWormholeEnergy = 1.0;
                    optimal = 1L;
                }
                this.transferPower(optimal, i);
            }
        }
        if (this.mLink.mWormholeEnergy > 0.0) {
            return SimpleCheckRecipeResult.ofSuccess("none");
        }
        return SimpleCheckRecipeResult.ofFailure("none");
    }

    private void checkFrequency() {
        Long freq;
        if (this.mIsUnloading) {
            return;
        }
        ItemStack link = null;
        for (ItemStack slot : this.mInventory) {
            if (slot == null || !this.qeSingularity.func_77969_a(slot)) continue;
            link = slot;
            break;
        }
        if (!Objects.equals(freq = link != null && link.func_77978_p() != null && link.func_77978_p().func_150297_b("freq", 4) ? Long.valueOf(link.func_77978_p().func_74763_f("freq")) : null, this.mLink == null ? null : Long.valueOf(this.mLink.mFrequency))) {
            if (this.mLink != null) {
                this.mLink.disconnect(this.mSelfReference);
                this.mLink = null;
            }
            if (freq != null) {
                this.mLink = WormholeLink.get(freq);
                this.mLink.connect(this.mSelfReference);
            }
        }
    }

    private long getTransferable(int index) {
        MTEWormholeGenerator dest = this.mLink.getDest(this.mSelfReference);
        if (dest == null || this.mMaxProgresstime == 0 || dest.mMaxProgresstime == 0) {
            return 0L;
        }
        MTEHatchEnergyMulti inputHatch = this.mSendHatches[index];
        MTEHatchDynamoMulti outputHatch = dest.mReceiveHatches[OPPOSITES[index]];
        if (inputHatch == null || outputHatch == null) {
            return 0L;
        }
        long available = inputHatch.getEUVar();
        long empty = outputHatch.maxEUStore() - outputHatch.getEUVar();
        return Math.min(available, empty);
    }

    private void transferPower(long optimal, int index) {
        MTEWormholeGenerator dest = this.mLink.getDest(this.mSelfReference);
        if (dest == null) {
            return;
        }
        MTEHatchEnergyMulti inputHatch = this.mSendHatches[index];
        MTEHatchDynamoMulti outputHatch = dest.mReceiveHatches[OPPOSITES[index]];
        if (inputHatch == null || outputHatch == null) {
            return;
        }
        long available = inputHatch.getEUVar();
        long empty = outputHatch.maxEUStore() - outputHatch.getEUVar();
        long maxSend = inputHatch.maxAmperesIn() * GTValues.V[inputHatch.mTier] * 20L;
        long maxReceive = outputHatch.maxAmperesOut() * GTValues.V[outputHatch.mTier] * 20L;
        long maxIO = (long)((double)optimal * Math.pow(4.0, MAX_OVERCLOCKS));
        double maintenance_efficiency = 1.0 - (double)(dest.getIdealStatus() - dest.getRepairStatus()) * 0.1;
        long toSend = GTUtility.min(available, empty, maxSend, maxReceive, maxIO);
        double overclocks = 0.0;
        if (this.mAllowOverclocks) {
            overclocks = Math.log((double)toSend / (double)optimal) / Math.log(4.0);
            overclocks = MathHelper.func_151237_a((double)overclocks, (double)0.0, (double)MAX_OVERCLOCKS);
        }
        long toReceive = (long)((double)toSend * (Math.pow(2.0, overclocks) / Math.pow(4.0, overclocks)) * maintenance_efficiency * TRANSFER_EFFICIENCY);
        inputHatch.setEUVar(inputHatch.getEUVar() - toSend);
        outputHatch.setEUVar(outputHatch.getEUVar() + toReceive);
        double size = MTEWormholeGenerator.wormholeRadiusCalc((double)optimal / 20.0);
        this.updateRenderRadius(size);
        dest.updateRenderRadius(size);
        this.mLink.onEnergyTransferred(toSend);
        int n = index;
        this.mLink.mSendAmounts[n] = this.mLink.mSendAmounts[n] + toSend;
        int n2 = OPPOSITES[index];
        this.mLink.mReceiveAmounts[n2] = this.mLink.mReceiveAmounts[n2] + toReceive;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mAllowOverclocks", this.mAllowOverclocks);
        try {
            if (this.mLink != null) {
                this.mLink.tryPromote();
                NBTTagCompound link = new NBTTagCompound();
                link.func_74772_a("mFrequency", this.mLink.mFrequency);
                link.func_74780_a("mWormholeEnergy", this.mLink.mWormholeEnergy);
                if (this.mLink.isMaster(this.mSelfReference)) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeInt(this.mLink.mReceiveAmounts.length);
                    for (long x : this.mLink.mReceiveAmounts) {
                        dos.writeLong(x);
                    }
                    dos.writeInt(this.mLink.mSendAmounts.length);
                    for (long x : this.mLink.mSendAmounts) {
                        dos.writeLong(x);
                    }
                    link.func_74773_a("data", baos.toByteArray());
                }
                aNBT.func_74782_a("mLink", (NBTBase)link);
            }
        }
        catch (Throwable t) {
            GTMod.GT_FML_LOGGER.error("Could not save MTEWormholeGenerator", t);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.checkFrequency();
        this.mAllowOverclocks = aNBT.func_74767_n("mAllowOverclocks");
        if (aNBT.func_74764_b("mLink") && this.mLink != null) {
            NBTTagCompound link = aNBT.func_74775_l("mLink");
            long freq = link.func_74763_f("mFrequency");
            try {
                if (freq == this.mLink.mFrequency && this.mLink.isMaster(this.mSelfReference)) {
                    this.mLink.mWormholeEnergy = link.func_74769_h("mWormholeEnergy");
                    ByteArrayInputStream bais = new ByteArrayInputStream(link.func_74770_j("data"));
                    DataInputStream dis = new DataInputStream(bais);
                    long[] recv_amounts = new long[dis.readInt()];
                    for (int i = 0; i < recv_amounts.length; ++i) {
                        recv_amounts[i] = dis.readLong();
                    }
                    System.arraycopy(recv_amounts, 0, this.mLink.mReceiveAmounts, 0, Math.min(recv_amounts.length, this.mLink.mReceiveAmounts.length));
                    long[] send_amounts = new long[dis.readInt()];
                    for (int i = 0; i < send_amounts.length; ++i) {
                        send_amounts[i] = dis.readLong();
                    }
                    System.arraycopy(send_amounts, 0, this.mLink.mSendAmounts, 0, Math.min(send_amounts.length, this.mLink.mSendAmounts.length));
                }
            }
            catch (Throwable t) {
                GTMod.GT_FML_LOGGER.error("Could not load MTEWormholeGenerator", t);
            }
        }
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Wormhole Generator").addInfo("Transfers EU between two wormhole generators.").addInfo("Wormholes are linked by placing an AE2 Entangled Singularity in each controller slot.").addInfo("The transfer rate is limited by the wormhole size, and the wormhole size is governed by the transfer rate.").addInfo("If the transfer rate is completely stable, the transfer efficiency is " + String.format("%.1f", TRANSFER_EFFICIENCY * 100.0) + "%.").addInfo("EU will only be transferred if there is space in the laser source hatch.").addInfo("Each laser target must have a laser source on the \u00a7oother\u00a77 controller, on the \u00a7oopposite\u00a77 side.").addInfo("Consumes an AE2 Singularity from an input bus each time the wormhole is kick-started.").addInfo("Right click the controller with a screwdriver to disable overclocking.").addTecTechHatchInfo().beginStructureBlock(7, 9, 7, false).addCasingInfoExactly("Molecular Casing", 24, false).addCasingInfoExactly("Europium Reinforced Radiation Proof Machine Casing", 4, false).addCasingInfoExactly("Fusion Coil Block", 22, false).addCasingInfoRange("High Power Casing", 49, 53, false).addCasingInfoExactly("Borosilicate Glass (any)", 36, true).addMaintenanceHatch("\u00a761\u00a7r (dot 1)").addInputBus("\u00a761\u00a7r (dot 1)").addDynamoHatch("\u00a760\u00a7r - \u00a764\u00a7r (laser only, dot 2)").addEnergyHatch("\u00a760\u00a7r - \u00a764\u00a7r (laser only, dot 2)").addStructureInfo("\u00a7rThe glass tier limits the hatch tier.").addSubChannelUsage("glass", "Borosilicate Glass Tier").toolTipFinisher(GTValues.AuthorPineapple + EnumChatFormatting.GRAY + ", Rendering by: " + EnumChatFormatting.WHITE + "BucketBrigade");
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        data.add(EnumChatFormatting.STRIKETHROUGH + "-----------------------");
        data.add("Wormhole Generator Info");
        if (this.mStructureBadGlassTier) {
            data.add("\u00a7cStructure errors:\u00a7r");
            data.add("\u00a7cGlass tier must be greater than or equal to the energy hatch tiers.\u00a7r");
        }
        if (this.mLink == null) {
            data.add("An entangled singularity must be present in the controller slot");
        } else if (!this.mLink.isFormed()) {
            data.add("Wormhole status: \u00a7cNo destination\u00a7f");
        } else {
            if (this.mLink.mWormholeEnergy > 0.0) {
                if (this.mLink.isActive()) {
                    data.add("Wormhole status: \u00a7bActive\u00a7f");
                } else {
                    data.add("Wormhole status: \u00a76Decaying\u00a7f");
                }
            } else {
                boolean anyTransferable = false;
                for (int i = 0; i < 6; ++i) {
                    if (!HATCH_MASK[i] || this.getTransferable(i) <= 0L) continue;
                    anyTransferable = true;
                    break;
                }
                if (anyTransferable) {
                    data.add("Wormhole status: \u00a77Inactive\u00a7f");
                } else {
                    data.add("Wormhole status: \u00a77No energy in input hatches\u00a7f");
                }
            }
            double radius = Math.sqrt(this.mLink.mWormholeEnergy / 20.0 / 32.0);
            data.add(String.format("Wormhole diameter: \u00a7b%,d\u00a7r angstrom", (long)(radius * 2.0)));
            data.add(String.format("Optimal transfer speed: \u00a7b%,.0f\u00a7r EU/t", this.mLink.mWormholeEnergy / 20.0));
        }
        for (int i = 0; i < 6; ++i) {
            if (!HATCH_MASK[i]) continue;
            MTEHatchEnergyMulti inputHatch = this.mSendHatches[i];
            MTEHatchDynamoMulti outputHatch = this.mReceiveHatches[i];
            long avgSend = 0L;
            long avgReceive = 0L;
            long avgSendOpposite = 0L;
            long avgReceiveOpposite = 0L;
            if (this.mLink != null) {
                long[] send = this.mLink.mAvgSendAmounts[i];
                long[] recv = this.mLink.mAvgReceiveAmounts[i];
                long[] sendOpposite = this.mLink.mAvgSendAmounts[OPPOSITES[i]];
                long[] recvOpposite = this.mLink.mAvgReceiveAmounts[OPPOSITES[i]];
                for (int second = 0; second < SCAN_AVG_WINDOW; ++second) {
                    avgSend += send[second];
                    avgReceive += recv[second];
                    avgSendOpposite += sendOpposite[second];
                    avgReceiveOpposite += recvOpposite[second];
                }
                avgSend /= (long)SCAN_AVG_WINDOW;
                avgReceive /= (long)SCAN_AVG_WINDOW;
                avgSendOpposite /= (long)SCAN_AVG_WINDOW;
                avgReceiveOpposite /= (long)SCAN_AVG_WINDOW;
            }
            if (inputHatch != null) {
                data.add(String.format("%s hatch (%,dA/t %s) transferred \u00a7b%,d\u00a7f EU (equivalent to %,dA/t) with an efficiency of %.3f%% in the last %d seconds", HATCH_NAMES[i], inputHatch.Amperes, GTValues.VN[inputHatch.mTier], avgSend, avgSend / 20L / GTValues.V[inputHatch.mTier], avgSend > 0L ? (double)avgReceiveOpposite / (double)avgSend * 100.0 : 0.0, SCAN_AVG_WINDOW));
                continue;
            }
            if (outputHatch != null) {
                data.add(String.format("%s hatch (%,dA/t %s) received \u00a7b%,d\u00a7f EU (equivalent to %,dA/t) with an efficiency of %.3f%% in the last %d seconds", HATCH_NAMES[i], outputHatch.Amperes, GTValues.VN[outputHatch.mTier], avgReceive, avgReceive / 20L / GTValues.V[outputHatch.mTier], avgSendOpposite > 0L ? (double)avgReceive / (double)avgSendOpposite * 100.0 : 0.0, SCAN_AVG_WINDOW));
                continue;
            }
            data.add(String.format("%s hatch is not present", HATCH_NAMES[i]));
        }
        data.add(EnumChatFormatting.STRIKETHROUGH + "-----------------------");
        return data.toArray(new String[0]);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widgets(new Widget[]{TextWidget.dynamicString(() -> {
            if (this.mLink == null) {
                return "\u00a77Missing Entangled Singularity\u00a7f";
            }
            if (!this.mLink.isFormed()) {
                return "\u00a77Wormhole status: \u00a7cNo destination\u00a7f";
            }
            if (this.mLink.mWormholeEnergy > 0.0 && !this.mLink.isActive()) {
                return "\u00a77Wormhole status: \u00a76Decaying\u00a7f";
            }
            if (this.mLink.mWormholeEnergy > 0.0) {
                return "\u00a77Wormhole status: \u00a7bActive\u00a7f";
            }
            return "\u00a77Wormhole status: Inactive\u00a7f";
        }), TextWidget.dynamicString(() -> {
            if (this.mLink == null) {
                return "";
            }
            double radius = Math.sqrt(this.mLink.mWormholeEnergy / 20.0 / 32.0);
            return String.format("\u00a77Wormhole diameter: \u00a7b%,d\u00a77 \u00c5\u00a7f", (long)(radius * 2.0));
        }).setEnabled(w -> this.mWormholeEnergy_UI > 0.0), TextWidget.dynamicString(() -> {
            if (this.mLink == null) {
                return "";
            }
            if (this.mLink.mWormholeEnergy >= 1.0E10) {
                return String.format("\u00a77Max I/O per hatch: \u00a7b%3.3e\u00a77 EU/t\u00a7f", this.mLink.mWormholeEnergy / 20.0);
            }
            return String.format("\u00a77Max I/O per hatch: \u00a7b%,d\u00a77 EU/t\u00a7f", (long)(this.mLink.mWormholeEnergy / 20.0));
        }).setEnabled(w -> this.mWormholeEnergy_UI > 0.0), new FakeSyncWidget.DoubleSyncer(() -> this.mLink != null ? this.mLink.mWormholeEnergy : 0.0, val -> {
            this.mWormholeEnergy_UI = val;
        })});
    }

    private static class WormholeLink {
        private static final Map<Long, WormholeLink> WORMHOLE_GENERATORS = new MapMaker().weakValues().makeMap();
        public final long mFrequency;
        public WeakReference<MTEWormholeGenerator> mMaster;
        public WeakReference<MTEWormholeGenerator> mSlave;
        public final long[] mSendAmounts = new long[6];
        public final long[] mReceiveAmounts = new long[6];
        public final long[][] mAvgSendAmounts = new long[6][SCAN_AVG_WINDOW];
        public final long[][] mAvgReceiveAmounts = new long[6][SCAN_AVG_WINDOW];
        public double mWormholeEnergy;
        private double mPendingEnergy;

        private WormholeLink(long frequency) {
            this.mFrequency = frequency;
        }

        public static WormholeLink get(long frequency) {
            return WORMHOLE_GENERATORS.computeIfAbsent(frequency, WormholeLink::new);
        }

        public void update(WeakReference<MTEWormholeGenerator> updater) {
            this.tryPromote();
            if (this.isMaster(updater)) {
                if (this.isActive() && this.mPendingEnergy > 0.0) {
                    double delta;
                    if (this.mPendingEnergy < this.mWormholeEnergy) {
                        delta = this.mWormholeEnergy * (1.0 - DECAY_RATE);
                        this.mWormholeEnergy = this.mWormholeEnergy - delta < this.mPendingEnergy ? this.mPendingEnergy : (this.mWormholeEnergy -= delta);
                    } else if (this.mPendingEnergy > this.mWormholeEnergy) {
                        delta = this.mPendingEnergy / (double)WH_ENERGY_AVG_WINDOW;
                        this.mWormholeEnergy = this.mWormholeEnergy + delta > this.mPendingEnergy ? this.mPendingEnergy : (this.mWormholeEnergy += delta);
                    }
                    this.mPendingEnergy = 0.0;
                } else {
                    this.mWormholeEnergy *= 1.0 - DECAY_RATE;
                    if (this.mWormholeEnergy < COLLAPSE_THRESHOLD) {
                        this.mWormholeEnergy = 0.0;
                    }
                }
                for (int hatch = 0; hatch < 6; ++hatch) {
                    for (int i = 0; i < SCAN_AVG_WINDOW; ++i) {
                        if (i < SCAN_AVG_WINDOW - 1) {
                            this.mAvgReceiveAmounts[hatch][i] = this.mAvgReceiveAmounts[hatch][i + 1];
                            this.mAvgSendAmounts[hatch][i] = this.mAvgSendAmounts[hatch][i + 1];
                            continue;
                        }
                        this.mAvgReceiveAmounts[hatch][i] = this.mReceiveAmounts[hatch];
                        this.mAvgSendAmounts[hatch][i] = this.mSendAmounts[hatch];
                    }
                }
                Arrays.fill(this.mSendAmounts, 0L);
                Arrays.fill(this.mReceiveAmounts, 0L);
            }
        }

        public void onEnergyTransferred(long amount) {
            this.mPendingEnergy += (double)amount;
        }

        public boolean isMaster(WeakReference<MTEWormholeGenerator> tile) {
            return this.mMaster == tile;
        }

        public boolean isConnected(WeakReference<MTEWormholeGenerator> tile) {
            return this.mMaster == tile || this.mSlave == tile;
        }

        public boolean isFormed() {
            return this.mMaster != null && this.mSlave != null;
        }

        public boolean connect(WeakReference<MTEWormholeGenerator> tile) {
            this.tryPromote();
            if (this.mMaster == null) {
                this.mMaster = tile;
                Optional.ofNullable(this.mMaster).map(Reference::get).ifPresent(MTEWormholeGenerator::updateRenderDim);
                Optional.ofNullable(this.mSlave).map(Reference::get).ifPresent(MTEWormholeGenerator::updateRenderDim);
                return true;
            }
            if (this.mSlave == null) {
                this.mSlave = tile;
                Optional.of(this.mMaster).map(Reference::get).ifPresent(MTEWormholeGenerator::updateRenderDim);
                Optional.ofNullable(this.mSlave).map(Reference::get).ifPresent(MTEWormholeGenerator::updateRenderDim);
                return true;
            }
            return false;
        }

        public void disconnect(WeakReference<MTEWormholeGenerator> tile) {
            Objects.requireNonNull((MTEWormholeGenerator)tile.get()).destroyRenderBlock();
            if (tile == this.mMaster) {
                this.mMaster = null;
            }
            if (tile == this.mSlave) {
                this.mSlave = null;
            }
            this.tryPromote();
            if (this.mMaster == null && this.mSlave == null) {
                WORMHOLE_GENERATORS.remove(this.mFrequency, this);
            }
        }

        public void tryPromote() {
            this.mMaster = WormholeLink.tryClean(this.mMaster);
            this.mSlave = WormholeLink.tryClean(this.mSlave);
            if (this.mMaster == null && this.mSlave != null) {
                this.mMaster = this.mSlave;
                this.mSlave = null;
            }
        }

        private static WeakReference<MTEWormholeGenerator> tryClean(WeakReference<MTEWormholeGenerator> tileReference) {
            if (tileReference != null) {
                MTEWormholeGenerator tile = (MTEWormholeGenerator)tileReference.get();
                if (tile == null) {
                    return null;
                }
                IGregTechTileEntity base = tile.getBaseMetaTileEntity();
                if (base == null || base.isDead()) {
                    return null;
                }
            }
            return tileReference;
        }

        public MTEWormholeGenerator getDest(WeakReference<MTEWormholeGenerator> tile) {
            if (tile == this.mMaster) {
                return this.mSlave != null ? (MTEWormholeGenerator)this.mSlave.get() : null;
            }
            if (tile == this.mSlave) {
                return this.mMaster != null ? (MTEWormholeGenerator)this.mMaster.get() : null;
            }
            return null;
        }

        public boolean isActive() {
            boolean masterCanWork = Optional.ofNullable(this.mMaster).map(Reference::get).map(MetaTileEntity::getBaseMetaTileEntity).map(IMachineProgress::isAllowedToWork).orElse(false);
            boolean slaveCanWork = Optional.ofNullable(this.mSlave).map(Reference::get).map(MetaTileEntity::getBaseMetaTileEntity).map(IMachineProgress::isAllowedToWork).orElse(false);
            return masterCanWork && slaveCanWork;
        }
    }

    private static class TransferHatch
    implements IHatchElement<MTEWormholeGenerator> {
        public final int mIndex;

        public TransferHatch(int index) {
            this.mIndex = index;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Arrays.asList(MTEHatchEnergyMulti.class, MTEHatchDynamoMulti.class);
        }

        @Override
        public IGTHatchAdder<? super MTEWormholeGenerator> adder() {
            return (tile, aTileEntity, aBaseCasingIndex) -> {
                if (aTileEntity == null) {
                    return false;
                }
                IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
                if (aMetaTileEntity == null) {
                    return false;
                }
                if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
                    MTEHatchEnergyMulti input = (MTEHatchEnergyMulti)aMetaTileEntity;
                    input.updateTexture(aBaseCasingIndex.shortValue());
                    input.updateCraftingIcon(tile.getMachineCraftingIcon());
                    ((MTEWormholeGenerator)tile).mSendHatches[this.mIndex] = input;
                    return true;
                }
                if (aMetaTileEntity instanceof MTEHatchDynamoMulti) {
                    MTEHatchDynamoMulti output = (MTEHatchDynamoMulti)aMetaTileEntity;
                    output.updateTexture(aBaseCasingIndex.shortValue());
                    output.updateCraftingIcon(tile.getMachineCraftingIcon());
                    ((MTEWormholeGenerator)tile).mReceiveHatches[this.mIndex] = output;
                    return true;
                }
                return false;
            };
        }

        @Override
        public String name() {
            return "TransferHatch";
        }

        @Override
        public long count(MTEWormholeGenerator t) {
            return t.mExoticEnergyHatches.size();
        }
    }
}

