/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class MTEIndustrialFluidHeater
extends GTPPMultiBlockBase<MTEIndustrialFluidHeater>
implements ISurvivalConstructable {
    private int mCasing1;
    private static IStructureDefinition<MTEIndustrialFluidHeater> STRUCTURE_DEFINITION = null;

    public MTEIndustrialFluidHeater(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialFluidHeater(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialFluidHeater(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fluid Heater";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("120% faster than using single block machines of the same voltage").addInfo("Only uses 90% of the EU/t normally required").addInfo("Processes eight items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(5, 6, 5, true).addController("Front Center").addCasingInfoMin("Top/Bottom layer: Multi-use Casings", 34, false).addCasingInfoMin("Middle layers: Thermal Containment Casing", 47, false).addInputBus("Bottom Layer (optional)", 1).addInputHatch("Bottom Layer", 1).addOutputBus("Top Layer (optional)", 1).addOutputHatch("Top Layer", 1).addEnergyHatch("Any Multi-use Casing", 1).addMaintenanceHatch("Any Multi-use Casing", 1).addMufflerHatch("Any Multi-use Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialFluidHeater> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" TTT ", "TTTTT", "TTTTT", "TTTTT", " TTT "}, {" XXX ", "X---X", "X---X", "X---X", " XXX "}, {" XXX ", "X---X", "X---X", "X---X", " XXX "}, {" XXX ", "X---X", "X---X", "X---X", " XXX "}, {" X~X ", "X---X", "X---X", "X---X", " XXX "}, {" BBB ", "BBBBB", "BBBBB", "BBBBB", " BBB "}})).addElement('B', GTStructureUtility.buildHatchAdder(MTEIndustrialFluidHeater.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock2(), (int)this.getCasingMeta2())))).addElement('X', StructureUtility.ofBlock((Block)this.getCasingBlock1(), (int)this.getCasingMeta1())).addElement('T', GTStructureUtility.buildHatchAdder(MTEIndustrialFluidHeater.class).atLeast(HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock2(), (int)this.getCasingMeta2())))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing1 = 0;
        boolean didBuild = this.checkPiece(this.mName, 2, 4, 0);
        this.log("Built? " + didBuild + ", " + this.mCasing1);
        return didBuild && this.mCasing1 >= 34 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAFluidHeaterActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAFluidHeater;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 1);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fluidHeaterRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic().setSpeedBonus(0.45454543828964233)).setEuModifier(0.9f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialFluidHeater;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock1() {
        return ModBlocks.blockCasings2Misc;
    }

    public byte getCasingMeta1() {
        return 11;
    }

    public Block getCasingBlock2() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getCasingMeta2() {
        return 2;
    }

    public byte getCasingTextureIndex() {
        return (byte)TAE.getIndexFromPage(2, 2);
    }
}

