/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.commands.CoreCommand;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;

public class ParamSet
extends FreqParam {
    @Override
    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.chatT("wrcbe_core.param.set.usage", new Object[0]);
        listener.chatT("wrcbe_core.param.set.usage1", new Object[0]);
        listener.chatT("wrcbe_core.param.set.usage2", new Object[0]);
        listener.chatT("wrcbe_core.param.set.usage3", new Object[0]);
    }

    @Override
    public String getName() {
        return "set";
    }

    @Override
    public void handleCommand(String playername, String[] subArray, CoreCommand.WCommandSender listener) {
        int freq;
        RedstoneEther ether = RedstoneEther.get(false);
        if (subArray.length != 3) {
            listener.chatT("wrcbe_core.param.invalidno", new Object[0]);
            return;
        }
        try {
            freq = Integer.parseInt(subArray[2]);
        }
        catch (NumberFormatException ne) {
            listener.chatT("", new Object[0]);
            return;
        }
        if (subArray[1].equals("public")) {
            if (freq < 1 || freq > 5000) {
                listener.chatT("wrcbe_core.param.invalidfreq", new Object[0]);
                return;
            }
            ether.setLastPublicFrequency(freq);
            listener.chatOpsT("wrcbe_core.param.set.nowpublic", new Object[]{playername, ether.getLastPublicFrequency()});
            if (freq >= ether.getLastSharedFrequency()) {
                listener.chatOpsT("wrcbe_core.param.set.sharedpublic", new Object[]{playername});
            } else {
                listener.chatOpsT("wrcbe_core.param.set.nowshared", new Object[]{playername, freq + 1, ether.getLastSharedFrequency()});
            }
        } else if (subArray[1].equals("shared")) {
            if (freq < 1 || freq > 5000) {
                listener.chatT("wrcbe_core.param.invalidfreq", new Object[0]);
                return;
            }
            boolean wasPublic = ether.getLastPublicFrequency() >= ether.getLastSharedFrequency();
            ether.setLastSharedFrequency(freq);
            if (ether.getLastSharedFrequency() >= freq) {
                if (!wasPublic) {
                    listener.chatOpsT("wrcbe_core.param.set.sharedremoved", new Object[]{playername});
                } else {
                    listener.chatOpsT("wrcbe_core.param.set.nowshared", new Object[]{playername, ether.getLastPublicFrequency() + 1, freq});
                }
            }
        } else if (subArray[1].equals("private")) {
            if (freq < 0 || freq > 5000) {
                listener.chatT("Invalid Quantity.", new Object[0]);
                return;
            }
            ether.setNumPrivateFreqs(freq);
            listener.chatOpsT("wrcbe_core.param.set.privateno", new Object[]{playername, freq});
        } else {
            listener.chatT("wrcbe_core.param.set.invalidqty", new Object[0]);
        }
    }
}

