/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.TC4Transformer;
import net.glease.tc4tweak.asm.TransformerFactory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class BlockMagicalLeavesVisitor
extends ClassVisitor {
    private static final boolean hodgepodge = ASMUtils.isHodgepodgeFixActive("fixThaumcraftLeavesLag");

    private BlockMagicalLeavesVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public static TransformerFactory createFactory() {
        return new TransformerFactory(BlockMagicalLeavesVisitor::new){

            @Override
            public boolean isInactive() {
                if (super.isInactive()) {
                    return true;
                }
                if (hodgepodge) {
                    TC4Transformer.log.warn("Disabling TC4Tweaks's leaves lag fix to prevent conflict with hodgepodge.");
                }
                return hodgepodge;
            }
        };
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("func_149674_a") || name.equals("updateTick")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){
                private boolean foundNeedle;

                public void visitLineNumber(int line, Label start) {
                    super.visitLineNumber(line, start);
                    if (line == 292) {
                        this.foundNeedle = true;
                        TC4Transformer.log.trace("Found needle: Line 292");
                    }
                }

                public void visitVarInsn(int opcode, int var) {
                    if (this.foundNeedle && opcode == 25 && var == 0) {
                        TC4Transformer.log.trace("Removing ALOAD_0");
                        return;
                    }
                    super.visitVarInsn(opcode, var);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    String realName = name;
                    String realDesc = desc;
                    if (this.foundNeedle && name.equals("func_147465_d") || name.equals("setBlock")) {
                        realDesc = "(IIIII)Z";
                        realName = !LoadingPlugin.isDev() ? "func_72921_c" : "setBlockMetadataWithNotify";
                        TC4Transformer.log.debug("Replaced call {}#{}{} to {}#{}{}", new Object[]{owner, name, desc, owner, realName, realDesc});
                        this.foundNeedle = false;
                    }
                    super.visitMethodInsn(opcode, owner, realName, realDesc, itf);
                }
            };
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }
}

