/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.MinecraftForge;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.BlockDimPosStorage;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesLoadedChunkManager;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.events.team.ForgeTeamDataEvent;
import serverutils.events.universe.UniverseClosedEvent;
import serverutils.events.universe.UniverseLoadedEvent;
import serverutils.events.universe.UniverseSavedEvent;
import serverutils.lib.data.Universe;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.MathUtils;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.ranks.Ranks;

public class ServerUtilitiesUniverseData {
    public static final ServerUtilitiesUniverseData INST = new ServerUtilitiesUniverseData();
    public static final BlockDimPosStorage WARPS = new BlockDimPosStorage();
    private static final List<String> worldLog = new ArrayList<String>();
    private static final List<String> chatLog = new ArrayList<String>();

    public static boolean isInSpawn(MinecraftServer server, ChunkDimPos pos) {
        if (pos.dim != 0 || !server.func_71262_S() && !ServerUtilitiesConfig.world.spawn_area_in_sp) {
            return false;
        }
        int radius = ServerUtilitiesConfig.world.spawn_radius;
        if (radius <= 0) {
            return false;
        }
        ChunkCoordinates c = server.func_130014_f_().func_72861_E();
        int minX = MathUtils.chunk(c.field_71574_a - radius);
        int minZ = MathUtils.chunk(c.field_71573_c - radius);
        int maxX = MathUtils.chunk(c.field_71574_a + radius);
        int maxZ = MathUtils.chunk(c.field_71573_c + radius);
        return pos.posX >= minX && pos.posX <= maxX && pos.posZ >= minZ && pos.posZ <= maxZ;
    }

    @SubscribeEvent
    public void registerTeamData(ForgeTeamDataEvent event) {
        event.register(new ServerUtilitiesTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public void onCreateServerTeams(UniverseLoadedEvent.CreateServerTeams event) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerUtilitiesTeamData(event.getUniverse().fakePlayerTeam));
    }

    @SubscribeEvent
    public void onUniversePreLoaded(UniverseLoadedEvent.Pre event) {
        if (ServerUtilitiesConfig.world.chunk_claiming) {
            ClaimedChunks.instance = new ClaimedChunks(event.getUniverse());
        }
        Ranks.INSTANCE = new Ranks(event.getUniverse());
    }

    @SubscribeEvent
    public void onUniversePostLoaded(UniverseLoadedEvent.Post event) {
        NBTTagCompound nbt = event.getData("serverutilities");
        WARPS.deserializeNBT(nbt.func_74775_l("Warps"));
    }

    @SubscribeEvent
    public void onUniverseLoaded(UniverseLoadedEvent.Finished event) {
        long now = System.currentTimeMillis();
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.nextChunkloaderUpdate = now + Ticks.SECOND.millis();
        }
    }

    public static void worldLog(String s) {
        StringBuilder out = new StringBuilder();
        Calendar time = Calendar.getInstance();
        ServerUtilitiesUniverseData.appendNum(out, time.get(1), '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(2) + 1, '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(5), ' ');
        ServerUtilitiesUniverseData.appendNum(out, time.get(11), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(12), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(13), ' ');
        out.append(':');
        out.append(' ');
        out.append(s);
        worldLog.add(out.toString());
        Universe.get().markDirty();
    }

    public static void chatLog(String s) {
        StringBuilder out = new StringBuilder();
        Calendar time = Calendar.getInstance();
        ServerUtilitiesUniverseData.appendNum(out, time.get(1), '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(2) + 1, '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(5), ' ');
        ServerUtilitiesUniverseData.appendNum(out, time.get(11), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(12), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(13), ' ');
        out.append(':');
        out.append(' ');
        out.append(s);
        chatLog.add(out.toString());
        Universe.get().markDirty();
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @SubscribeEvent
    public void onUniverseSaved(UniverseSavedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.processQueue();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Warps", (NBTBase)WARPS.serializeNBT());
        event.setData("serverutilities", nbt);
        if (!worldLog.isEmpty()) {
            ArrayList<String> worldLogCopy = new ArrayList<String>(worldLog);
            worldLog.clear();
            ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(FileUtils.newFile(event.getUniverse().server.func_71209_f("logs/world.log")), true)));){
                    for (String s : worldLogCopy) {
                        out.println(s);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            });
        }
        if (!chatLog.isEmpty()) {
            ArrayList<String> chatLogCopy = new ArrayList<String>(chatLog);
            chatLog.clear();
            ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(FileUtils.newFile(event.getUniverse().server.func_71209_f("logs/chat.log")), true)));){
                    for (String s : chatLogCopy) {
                        out.println(s);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public void onUniverseClosed(UniverseClosedEvent event) {
        if (ClaimedChunks.instance != null) {
            ClaimedChunks.instance.clear();
            ClaimedChunks.instance = null;
        }
        ServerUtilitiesLoadedChunkManager.INSTANCE.clear();
    }
}

